/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogRepoSizeCollector
extends AbstractApplicationUsagesCollector {
    public static final GroupDescriptor ID = GroupDescriptor.create("VCS Log");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getProjectUsages"));
        }
        VcsLogManager logManager = VcsLogContentProvider.findLogManager(project);
        VisiblePack dataPack = VcsLogRepoSizeCollector.getDataPack(logManager);
        if (dataPack != null) {
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            HashSet usages = ContainerUtil.newHashSet();
            usages.add(new UsageDescriptor("vcs.log.commit.count", permanentGraph.getAllCommits().size()));
            for (VcsKey vcs : groupedRoots.keySet()) {
                usages.add(new UsageDescriptor("vcs.log." + vcs.getName().toLowerCase() + ".root.count", groupedRoots.get((Object)vcs).size()));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getProjectUsages"));
            }
            return hashSet;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getProjectUsages"));
        }
        return set;
    }

    @Nullable
    private static VisiblePack getDataPack(@Nullable VcsLogManager logManager) {
        VcsLogUiImpl ui;
        if (logManager != null && (ui = logManager.getLogUi()) != null) {
            final Ref dataPack = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    dataPack.set((Object)ui.getDataPack());
                }
            }, ModalityState.defaultModalityState());
            return (VisiblePack)dataPack.get();
        }
        return null;
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "groupRootsByVcs"));
        }
        MultiMap result = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result.putValue((Object)vcs, (Object)root);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "groupRootsByVcs"));
        }
        return multiMap;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

