/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HTMLControls;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.HtmlUtil");
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    private static final String HTML5_DATA_ATTR_PREFIX = "data-";
    public static final String SCRIPT_TAG_NAME = "script";
    public static final String STYLE_TAG_NAME = "style";
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String[] CONTENT_TYPES = ArrayUtil.toStringArray(MimeTypeDictionary.getContentTypes());
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String[] RFC2616_HEADERS = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Refresh", "Retry-After", "Server", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final Set<String> EMPTY_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] OPTIONAL_END_TAGS = new String[]{"head", "p", "li", "dd", "dt", "thead", "tfoot", "tbody", "colgroup", "tr", "th", "td", "option", "embed", "noembed"};
    private static final Set<String> OPTIONAL_END_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] BLOCK_TAGS = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment"};
    @NonNls
    private static final String[] POSSIBLY_INLINE_TAGS = new String[]{"a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"};
    private static final Set<String> BLOCK_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] INLINE_ELEMENTS_CONTAINER = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "dt"};
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = new THashSet();
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] HTML5_TAGS = new String[]{"article", "aside", "audio", "canvas", "command", "datalist", "details", "embed", "figcaption", "figure", "footer", "header", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "video", "wbr", "main"};
    private static final Set<String> HTML5_TAGS_SET = new THashSet();
    private static final Map<String, Set<String>> AUTO_CLOSE_BY_MAP = new THashMap();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName.toLowerCase(Locale.US));
    }

    public static boolean isSingleHtmlTagL(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName);
    }

    public static boolean isOptionalEndForHtmlTag(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName.toLowerCase(Locale.US));
    }

    public static boolean isOptionalEndForHtmlTagL(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName);
    }

    public static boolean canTerminate(String childTagName, String tagName) {
        Set<String> closingTags = AUTO_CLOSE_BY_MAP.get(tagName);
        return closingTags != null && closingTags.contains(childTagName);
    }

    public static boolean isHtmlBlockTag(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName.toLowerCase(Locale.US));
    }

    public static boolean isPossiblyInlineTag(String tagName) {
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName);
    }

    public static boolean isHtmlBlockTagL(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName);
    }

    public static boolean isInlineTagContainer(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName.toLowerCase(Locale.US));
    }

    public static boolean isInlineTagContainerL(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName);
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor, XmlTag element, List<XmlElementDescriptor> variants) {
        block4: {
            PsiElement parent;
            block5: {
                String name = descriptor.getName((PsiElement)element);
                if (name == null || !HtmlUtil.isOptionalEndForHtmlTag(name)) break block4;
                parent = element.getParent();
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof HtmlTag)) break block5;
                XmlElementDescriptor parentDescriptor = ((HtmlTag)parent).getDescriptor();
                if (parentDescriptor == descriptor || parentDescriptor == null) break block4;
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName())) continue;
                    variants.add(elementsDescriptor);
                }
                break block4;
            }
            if (parent instanceof HtmlDocumentImpl) {
                XmlNSDescriptor nsDescriptor = descriptor.getNSDescriptor();
                for (XmlElementDescriptor elementDescriptor : nsDescriptor.getRootElementsDescriptors((XmlDocument)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementDescriptor.getName()) || variants.contains(elementDescriptor)) continue;
                    variants.add(elementDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        return HtmlPsiUtil.getRealXmlDocument(doc);
    }

    public static String[] getHtmlTagNames() {
        return HtmlDescriptorsTable.getHtmlTagNames();
    }

    public static boolean isShortNotationOfBooleanAttributePreferred() {
        return Registry.is((String)"html.prefer.short.notation.of.boolean.attributes", (boolean)true);
    }

    public static void setShortNotationOfBooleanAttributeIsPreferred(boolean value, Disposable parent) {
        final boolean oldValue = HtmlUtil.isShortNotationOfBooleanAttributePreferred();
        final RegistryValue registryValue = Registry.get((String)"html.prefer.short.notation.of.boolean.attributes");
        registryValue.setValue(value);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                registryValue.setValue(oldValue);
            }
        });
    }

    public static boolean isBooleanAttribute(@NotNull XmlAttributeDescriptor descriptor, @Nullable PsiElement context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/HtmlUtil", "isBooleanAttribute"));
        }
        if (descriptor instanceof HtmlAttributeDescriptorImpl && descriptor.isEnumerated()) {
            String[] values = descriptor.getEnumeratedValues();
            if (values == null) {
                return false;
            }
            if (values.length == 2) {
                return values[0].isEmpty() && values[1].equals(descriptor.getName()) || values[1].isEmpty() && values[0].equals(descriptor.getName());
            }
            if (values.length == 1) {
                return descriptor.getName().equals(values[0]);
            }
        }
        return context != null && HtmlUtil.isCustomBooleanAttribute(descriptor.getName(), context);
    }

    public static boolean isCustomBooleanAttribute(@NotNull String attributeName, @NotNull PsiElement context) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/xml/util/HtmlUtil", "isCustomBooleanAttribute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/util/HtmlUtil", "isCustomBooleanAttribute"));
        }
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownBooleanAttribute");
        if (entitiesString != null) {
            StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(XmlElement context) {
        String entitiesString = HtmlUtil.getEntitiesString((PsiElement)context, "HtmlUnknownAttribute");
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.length() == 0) continue;
            descriptors[index++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(@Nullable PsiElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownTag");
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String tagName = tokenizer.nextToken();
            if (tagName.length() == 0) continue;
            descriptors[index++] = new XmlElementDescriptorImpl(null){

                @Override
                public String getName(PsiElement context) {
                    return tagName;
                }

                @Override
                public String getDefaultName() {
                    return tagName;
                }

                @Override
                public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
                    return true;
                }
            };
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(@Nullable PsiElement context, @NotNull String inspectionName) {
        if (inspectionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionName", "com/intellij/xml/util/HtmlUtil", "getEntitiesString"));
        }
        if (context == null) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(context.getProject()).getInspectionProfile();
        XmlEntitiesInspection inspection = (XmlEntitiesInspection)profile.getUnwrappedTool(inspectionName, (PsiElement)containingFile);
        if (inspection != null) {
            return inspection.getAdditionalEntries();
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttribute context) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors((XmlElement)context));
            return descriptors;
        }
        boolean isJsfHtmlNamespace = false;
        for (String jsfHtmlUri : XmlUtil.JSF_HTML_URIS) {
            if (declarationTag.getPrefixByNamespace(jsfHtmlUri) == null) continue;
            isJsfHtmlNamespace = true;
            break;
        }
        if (isJsfHtmlNamespace && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            }, XmlAttributeDescriptor.class);
        }
        return descriptors;
    }

    public static boolean isHtml5Document(XmlDocument doc) {
        VirtualFile vFile;
        XmlDoctype doctype;
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype xmlDoctype = doctype = prolog != null ? prolog.getDoctype() : null;
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)doc)) {
            return false;
        }
        PsiFile htmlFile = doc.getContainingFile();
        String htmlFileFullName = htmlFile != null ? ((vFile = htmlFile.getVirtualFile()) != null ? vFile.getPath() : htmlFile.getName()) : "unknown";
        if (doctype == null) {
            LOG.debug("DOCTYPE for " + htmlFileFullName + " is null");
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(doc.getProject()));
        }
        boolean html5Doctype = HtmlUtil.isHtml5Doctype(doctype);
        String doctypeDescription = "text: " + doctype.getText() + ", dtdUri: " + doctype.getDtdUri() + ", publicId: " + doctype.getPublicId() + ", markupDecl: " + doctype.getMarkupDecl();
        LOG.debug("DOCTYPE for " + htmlFileFullName + "; " + doctypeDescription + "; HTML5: " + html5Doctype);
        return html5Doctype;
    }

    public static boolean isHtml5Doctype(XmlDoctype doctype) {
        return doctype.getDtdUri() == null && doctype.getPublicId() == null && doctype.getMarkupDecl() == null;
    }

    public static boolean isHtml5Context(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        return HtmlUtil.isHtml5Document(doc);
    }

    public static boolean isHtmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/HtmlUtil", "isHtmlTag"));
        }
        if (tag.getLanguage() != HTMLLanguage.INSTANCE) {
            return false;
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlDocument.class);
        String doctype = null;
        if (doc != null) {
            doctype = XmlUtil.getDtdUri(doc);
        }
        doctype = doctype == null ? ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(tag.getProject()) : doctype;
        return XmlUtil.XHTML4_SCHEMA_LOCATION.equals(doctype) || !StringUtil.containsIgnoreCase((String)doctype, (String)"xhtml");
    }

    public static boolean hasNonHtml5Doctype(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        return doctype != null && !HtmlUtil.isHtml5Doctype(doctype);
    }

    public static boolean isHtml5Tag(String tagName) {
        return HTML5_TAGS_SET.contains(tagName);
    }

    public static boolean isCustomHtml5Attribute(String attributeName) {
        return attributeName.startsWith(HTML5_DATA_ATTR_PREFIX);
    }

    @Nullable
    public static String getHrefBase(XmlFile file) {
        XmlTag root = file.getRootTag();
        XmlTag head = root != null ? root.findFirstSubTag("head") : null;
        XmlTag base = head != null ? head.findFirstSubTag("base") : null;
        return base != null ? base.getAttributeValue("href") : null;
    }

    public static boolean isOwnHtmlAttribute(XmlAttributeDescriptor descriptor) {
        PsiElement declaration = descriptor.getDeclaration();
        PsiFile file = declaration != null ? declaration.getContainingFile() : null;
        String name = file != null ? file.getName() : null;
        return "meta.rnc".equals(name);
    }

    public static boolean tagHasHtml5Schema(@NotNull XmlTag context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/util/HtmlUtil", "tagHasHtml5Schema"));
        }
        XmlElementDescriptor descriptor = context.getDescriptor();
        if (descriptor != null) {
            XmlNSDescriptor nsDescriptor = descriptor.getNSDescriptor();
            XmlFile descriptorFile = nsDescriptor.getDescriptorFile();
            String descriptorPath = descriptorFile != null ? descriptorFile.getVirtualFile().getPath() : null;
            return Comparing.equal((String)Html5SchemaProvider.getHtml5SchemaLocation(), (String)descriptorPath) || Comparing.equal((String)Html5SchemaProvider.getXhtml5SchemaLocation(), (String)descriptorPath);
        }
        return false;
    }

    public static Charset detectCharsetFromMetaTag(@NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/xml/util/HtmlUtil", "detectCharsetFromMetaTag"));
        }
        int charPrefix = StringUtil.indexOf((CharSequence)content, (CharSequence)CHARSET);
        while (true) {
            int charsetPrefixEnd;
            if (charPrefix == -1) {
                return null;
            }
            for (charsetPrefixEnd = charPrefix + CHARSET.length(); charsetPrefixEnd < content.length() && Character.isWhitespace(content.charAt(charsetPrefixEnd)); ++charsetPrefixEnd) {
            }
            if (charsetPrefixEnd < content.length() && content.charAt(charsetPrefixEnd) == '=') break;
            charPrefix = StringUtil.indexOf((CharSequence)content, (CharSequence)CHARSET, (int)charsetPrefixEnd);
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content).build(new XmlBuilder(){
                @NonNls
                final Set<String> inTag = new THashSet();
                boolean metHttpEquiv = false;
                boolean metHttml5Charset = false;
                private String contentAttributeValue;

                @Override
                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
                }

                @Override
                public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                    String name = localName.toString().toLowerCase();
                    this.inTag.add(name);
                    if (!this.inTag.contains("head") && !"html".equals(name)) {
                        this.terminate();
                    }
                    return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                }

                private void terminate() {
                    throw TerminateException.INSTANCE;
                }

                @Override
                public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                    String name = localName.toString().toLowerCase();
                    if ("meta".equals(name) && (this.metHttpEquiv || this.metHttml5Charset) && this.contentAttributeValue != null) {
                        String charsetName;
                        if (this.metHttpEquiv) {
                            int start = this.contentAttributeValue.indexOf(HtmlUtil.CHARSET_PREFIX);
                            if (start == -1) {
                                return;
                            }
                            int end = this.contentAttributeValue.indexOf(59, start += HtmlUtil.CHARSET_PREFIX.length());
                            if (end == -1) {
                                end = this.contentAttributeValue.length();
                            }
                            charsetName = this.contentAttributeValue.substring(start, end);
                        } else {
                            charsetName = StringUtil.stripQuotesAroundValue((String)this.contentAttributeValue);
                        }
                        charsetNameRef.set((Object)charsetName);
                        this.terminate();
                    }
                    if ("head".equals(name)) {
                        this.terminate();
                    }
                    this.inTag.remove(name);
                    this.metHttpEquiv = false;
                    this.metHttml5Charset = false;
                    this.contentAttributeValue = null;
                }

                @Override
                public void attribute(CharSequence localName, CharSequence v, int startoffset, int endoffset) {
                    String name = localName.toString().toLowerCase();
                    if (this.inTag.contains("meta")) {
                        String value = v.toString().toLowerCase();
                        if (name.equals("http-equiv")) {
                            this.metHttpEquiv |= value.equals("content-type");
                        } else if (name.equals(HtmlUtil.CHARSET)) {
                            this.metHttml5Charset = true;
                            this.contentAttributeValue = value;
                        }
                        if (name.equals("content")) {
                            this.contentAttributeValue = value;
                        }
                    }
                }

                @Override
                public void textElement(CharSequence display, CharSequence physical, int startoffset, int endoffset) {
                }

                @Override
                public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                }

                @Override
                public void error(String message, int startOffset, int endOffset) {
                }
            });
        }
        catch (TerminateException terminateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = (String)charsetNameRef.get();
        return CharsetToolkit.forName((String)name);
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName) {
        return tagName != null && "br".equalsIgnoreCase(tagName);
    }

    public static boolean hasHtml(PsiFile file) {
        return HtmlUtil.isHtmlFile((PsiElement)file) || file.getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }

    public static boolean supportsXmlTypedHandlers(PsiFile file) {
        return "JavaScript".equals(file.getLanguage().getID());
    }

    public static boolean hasHtmlPrefix(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/xml/util/HtmlUtil", "hasHtmlPrefix"));
        }
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//") || url.startsWith("ftp://");
    }

    public static boolean isHtmlFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/HtmlUtil", "isHtmlFile"));
        }
        Language language = element.getLanguage();
        return language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE;
    }

    public static boolean isHtmlFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/util/HtmlUtil", "isHtmlFile"));
        }
        FileType fileType = file.getFileType();
        return fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                return true;
            }
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
            if (document instanceof HtmlDocumentImpl) {
                return true;
            }
            FileViewProvider provider = containingFile.getViewProvider();
            Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
            return language == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isScriptTag(@Nullable XmlTag tag) {
        return tag != null && tag.getLocalName().equalsIgnoreCase(SCRIPT_TAG_NAME);
    }

    static {
        for (HTMLControls.Control control : HTMLControls.getControls()) {
            String tagName = control.name.toLowerCase(Locale.US);
            if (control.endTag == HTMLControls.TagState.FORBIDDEN) {
                EMPTY_TAGS_MAP.add(tagName);
            }
            AUTO_CLOSE_BY_MAP.put(tagName, (Set<String>)new THashSet(control.autoClosedBy));
        }
        ContainerUtil.addAll(OPTIONAL_END_TAGS_MAP, (Object[])OPTIONAL_END_TAGS);
        ContainerUtil.addAll(BLOCK_TAGS_MAP, (Object[])BLOCK_TAGS);
        ContainerUtil.addAll(INLINE_ELEMENTS_CONTAINER_MAP, (Object[])INLINE_ELEMENTS_CONTAINER);
        ContainerUtil.addAll(POSSIBLY_INLINE_TAGS_MAP, (Object[])POSSIBLY_INLINE_TAGS);
        ContainerUtil.addAll(HTML5_TAGS_SET, (Object[])HTML5_TAGS);
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

