/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementOnlyUsedFromTestCodeInspection
extends BaseGlobalInspection {
    private static final Key<Boolean> ONLY_USED_FROM_TEST_CODE = Key.create((String)"ONLY_USED_FROM_TEST_CODE");

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("element.only.used.from.test.code.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "getAnnotator"));
        }
        return new ElementOnlyUsedFromTestCodeAnnotator();
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        PsiIdentifier identifier;
        PsiElement element;
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "checkElement"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "checkElement"));
        }
        if (!ElementOnlyUsedFromTestCodeInspection.isOnlyUsedFromTestCode(refEntity, false)) {
            return null;
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return null;
        }
        RefJavaElement javaElement = (RefJavaElement)refEntity;
        if (!javaElement.isReferenced()) {
            return null;
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            for (RefMethod superMethod : refMethod.getSuperMethods()) {
                if (ElementOnlyUsedFromTestCodeInspection.isOnlyUsedFromTestCode((RefEntity)superMethod, true)) continue;
                return null;
            }
            for (RefMethod derivedMethod : refMethod.getDerivedMethods()) {
                if (ElementOnlyUsedFromTestCodeInspection.isOnlyUsedFromTestCode((RefEntity)derivedMethod, true)) continue;
                return null;
            }
        }
        if ((element = javaElement.getElement()) instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            identifier = aClass.getNameIdentifier();
            if (identifier == null) {
                return null;
            }
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("class.only.used.from.test.code.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            identifier = method.getNameIdentifier();
            if (identifier == null) {
                return null;
            }
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("method.only.used.from.test.code.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            identifier = field.getNameIdentifier();
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("field.only.used.from.test.code.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
        }
        return null;
    }

    private static boolean isInsideTestClass(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/siyeh/ig/redundancy/ElementOnlyUsedFromTestCodeInspection", "isInsideTestClass"));
        }
        PsiClass aClass = ElementOnlyUsedFromTestCodeInspection.getTopLevelParentClass(e);
        return aClass != null && TestFrameworks.getInstance().isTestClass(aClass);
    }

    private static boolean isUnderTestSources(PsiElement e) {
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)e.getProject());
        VirtualFile file = e.getContainingFile().getVirtualFile();
        return file != null && rootManager.getFileIndex().isInTestSourceContent(file);
    }

    @Nullable
    public static PsiClass getTopLevelParentClass(PsiElement e) {
        PsiClass result = null;
        for (PsiElement parent = e; parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiClass)) continue;
            result = (PsiClass)parent;
        }
        return result;
    }

    private static boolean isOnlyUsedFromTestCode(RefEntity refElement, boolean orNotUsed) {
        Boolean usedFromTestCode = (Boolean)refElement.getUserData(ONLY_USED_FROM_TEST_CODE);
        if (usedFromTestCode != null) {
            return usedFromTestCode;
        }
        return orNotUsed;
    }

    private static class ElementOnlyUsedFromTestCodeAnnotator
    extends RefGraphAnnotator {
        private ElementOnlyUsedFromTestCodeAnnotator() {
        }

        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            RefMethod what;
            RefMethod method;
            if (!(refWhat instanceof RefMethod || refWhat instanceof RefField || refWhat instanceof RefClass)) {
                return;
            }
            if (referencedFromClassInitializer || refFrom instanceof RefImplicitConstructor) {
                return;
            }
            PsiElement whatElement = refWhat.getElement();
            if (ElementOnlyUsedFromTestCodeInspection.isInsideTestClass(whatElement) || ElementOnlyUsedFromTestCodeInspection.isUnderTestSources(whatElement)) {
                return;
            }
            if (refFrom instanceof RefMethod && refWhat instanceof RefClass && (method = (RefMethod)refFrom).isConstructor() && method.getOwnerClass() == refWhat) {
                return;
            }
            Boolean onlyUsedFromTestCode = (Boolean)refWhat.getUserData(ONLY_USED_FROM_TEST_CODE);
            if (onlyUsedFromTestCode == null) {
                refWhat.putUserData(ONLY_USED_FROM_TEST_CODE, (Object)Boolean.TRUE);
            } else if (!onlyUsedFromTestCode.booleanValue()) {
                return;
            }
            PsiElement fromElement = refFrom.getElement();
            if (ElementOnlyUsedFromTestCodeInspection.isInsideTestClass(fromElement) || ElementOnlyUsedFromTestCodeInspection.isUnderTestSources(fromElement)) {
                return;
            }
            if (refWhat instanceof RefMethod && (what = (RefMethod)refWhat).isConstructor()) {
                RefClass ownerClass = what.getOwnerClass();
                ownerClass.putUserData(ONLY_USED_FROM_TEST_CODE, (Object)Boolean.FALSE);
            }
            refWhat.putUserData(ONLY_USED_FROM_TEST_CODE, (Object)Boolean.FALSE);
        }
    }
}

