/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertToScientificNotationPredicate
implements PsiElementPredicate {
    ConvertToScientificNotationPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        PsiType type = expression.getType();
        if (!PsiType.DOUBLE.equals((Object)type) && !PsiType.FLOAT.equals((Object)type)) {
            return false;
        }
        String text = expression.getText();
        if (text == null) {
            return false;
        }
        if ((text = text.toLowerCase()).startsWith("-")) {
            text = text.substring(1);
        }
        if (!text.contains(".") && text.startsWith("0")) {
            return false;
        }
        return !text.contains("e");
    }
}

