/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0007\b)\t2\u000b^1uS\u000e4\u0015\u000e\\3IC:$G.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u0001\"-^5mi&sw+\u001a2TKJ4XM\u001d\u0006\u0015/\u0016\u00147+\u001a:wKJ4\u0015\u000e\\3IC:$G.\u001a:\u000b\rqJg.\u001b;?\u00151\u00198/\u001b)s_\u000e,7o]8s\u00151\u00196/\u001b)s_\u000e,7o]8s\u0015\r\u00198/\u001b\u0006\nQ\u0006\u001c\u0018iY2fgNTaA]3tk2$(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\b\u0005>|G.Z1o\u0015\u0019Yw\u000e\u001e7j]*9\u0001O]8dKN\u001c(\u0002\u00024jY\u0016T1BV5siV\fGNR5mK*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018NC\u0002wMNTAcY1o_:L7-\u00197SKF,Xm\u001d;QCRD'\u0002D\"iCJ\u001cV-];f]\u000e,'b\u00029s_*,7\r\u001e\u0006\b!J|'.Z2u\u0015\u001d\u0011X-];fgRTqBR;mY\"#H\u000f\u001d*fcV,7\u000f\u001e\u0006\u0006]\u0016$H/\u001f\u0006\bQ\u0006tG\r\\3s\u0015\u0015\u0019w\u000eZ3d\u0015\u0011AG\u000f\u001e9\u000b\u000f\rD\u0017M\u001c8fY*91\t[1o]\u0016d'\u0002D5t\u0007V\u001cHo\\7I_N$(\u0002\u00027b]\u001eT!\u0002\u001d:pG\u0016\u001c8oU:j\u0015\u0011)f.\u001b;k\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!B\u0002\u0005\u0003!\u0001A\u0002A\u0003\u0004\t\u0005A!\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002B\u0003\u0004\t\u000bA9\u0001\u0004\u0001\u0006\u0005\u0011\u0015\u0001rA\u0003\u0002\u0011\u0019)!\u0001\u0002\u0003\t\u000e\u0015\u0019A\u0011\u0002E\u0006\u0019\u0001)\u0011\u0001c\u0004\u0006\u0007\u0011-\u0001b\u0002\u0007\u0001\u000b\t!I\u0001c\u0003\u0006\u0003!MQA\u0001\u0003\b\u0011))!\u0001b\u0004\t\u0016\u0015\u0011A\u0001\u0003\u0005\f\u000b\r!\t\u0002C\u0005\r\u0001\u0015\u0019A1\u0002\u0005\r\u0019\u0001)!\u0001\u0002\u0005\t\u001a\u0015\u0019AA\u0003\u0005\u000e\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u0011Y\u0001RD\u0003\u0003\t/Aq\"\u0002\u0002\u0005\u0019!}QA\u0001C\r\u0011A)1\u0001B\u0007\t\u001d1\u0001QA\u0001C\f\u0011C)1\u0001\u0002\b\t#1\u0001QA\u0001C\t\u0011%)!\u0001\u0002\u0003\t%\u0015\u0011Aq\u0004\u0005\r\u000b\t!!\u0002C\u0007\u0006\u0005\u0011i\u0001BD\u0003\u0003\t9A\u0011#B\u0002\u0005\f!\u0019B\u0002\u0001\u0003\u0002\u0019\u0007I\"!B\u0001\t\u00055bA!1\u0007\u0019\u0007\u0005\u001aQ!\u0001\u0005\u0004\u0019\u0003)6\u0001B\u0003\u0004\t\rI\u0011\u0001c\u0002.'\u0011\t\u0001\u0014BO\u0007\t\u0001AQ!\u0004\u0002\u0006\u0003!)\u0001k\u0001\u0001\"\u0005\u0015\t\u0001BB)\u0004\u000b\u0011%\u0011\"\u0001C\u0001\u001b\u0005Ai!,b\u0001\t-A\u0002\"(\u0004\u0005\u0001!EQBA\u0003\u0002\u0011%\u00016\u0001AO\u0007\t\u0001A9\"\u0004\u0002\u0006\u0003!M\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001\u0012D\u0007\u0003\u000b\u0005A)\u0002U\u0002\u0002;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0004u5A\u0001\u0001E\u0011\u001b\t)\u0011\u0001#\bQ\u0007\tij\u0001\u0002\u0001\t$5\u0011Q!\u0001\u0005\u0007!\u000e\u0015\u0011EA\u0003\u0002\u0011\u0019\t6a\u0004\u0003\t\u0013\u0005!\t!D\u0001\t\u001f5\t\u0001\u0002E\u0007\u0002\u0011Ci\u0011\u0001C\t\u000e\u0003!\rR\"\u0001C\u0001[\u000b\u0007A!\u0001M\u0013;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0001u5A\u0001\u0001E\f\u001b\t)\u0011\u0001c\u0005Q\u0007\u0003ij\u0001\u0002\u0001\t\u001a5\u0011Q!\u0001E\u000b!\u000e\tQT\u0002\u0003\u0001\u00117i!!B\u0001\t\u001cA\u001b\u0019!(\u0004\u0005\u0001!\u0005RBA\u0003\u0002\u0011;\u00016AAO\u0007\t\u0001A\u0019#\u0004\u0002\u0006\u0003!1\u0001k!\u0002\"\u0005\u0015\t\u0001BE)\u0004\u001f\u0011\u0015\u0012\"\u0001\u0003\u0001\u001b\u0005Aq\"D\u0001\t!5\t\u0001\u0012E\u0007\u0002\u0011Ei\u0011\u0001c\t\u000e\u0003\u0011\u0005QgC\u0003\u000b\t\r\b\u0001TA\u0011\u0003\u000b\u0005A\u0019!U\u0002\u0004\t\u000bI\u0011\u0001\u0002\u0001"})
public final class StaticFileHandler
extends WebServerFileHandler {
    public static final /* synthetic */ KClass $kotlinClass;
    private SsiProcessor ssiProcessor;

    static {
        $kotlinClass = Reflection.createKotlinClass(StaticFileHandler.class);
    }

    @Override
    public boolean process(@JetValueParameter(name="file") @NotNull VirtualFile file, @JetValueParameter(name="canonicalRequestPath") @NotNull CharSequence canonicalRequestPath, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="request") @NotNull FullHttpRequest request, @JetValueParameter(name="channel") @NotNull Channel channel, @JetValueParameter(name="isCustomHost") boolean isCustomHost) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if (file.isInLocalFileSystem()) {
            File ioFile;
            CharSequence nameSequence = file.getNameSequence();
            if (StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm")) {
                this.processSsi(file, canonicalRequestPath, project, request, channel, isCustomHost);
                return true;
            }
            File file2 = ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"ioFile");
            if (this.hasAccess(file2)) {
                FileResponses.sendFile((HttpRequest)request, channel, ioFile);
            } else {
                Responses.sendStatus(HttpResponseStatus.FORBIDDEN, channel, (HttpRequest)request);
            }
        } else {
            HttpResponse httpResponse = FileResponses.prepareSend((HttpRequest)request, channel, file.getTimeStamp(), file.getPath());
            if (httpResponse == null) {
                return true;
            }
            HttpResponse response = httpResponse;
            boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (request.method() != HttpMethod.HEAD) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file.getLength());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                channel.write((Object)new ChunkedStream(file.getInputStream()));
            }
            ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!keepAlive) {
                future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processSsi(@JetValueParameter(name="file") VirtualFile file, @JetValueParameter(name="canonicalRequestPath") CharSequence canonicalRequestPath, @JetValueParameter(name="project") Project project, @JetValueParameter(name="request") FullHttpRequest request, @JetValueParameter(name="channel") Channel channel, @JetValueParameter(name="isCustomHost") boolean isCustomHost) {
        boolean keepAlive;
        String path = PathUtilRt.getParentPath((String)((Object)canonicalRequestPath).toString());
        if (!isCustomHost) {
            path = KotlinPackage.substring((String)path, (int)(KotlinPackage.indexOf$default((String)path, (char)'/', (int)1, (boolean)false, (int)4) + 1));
        }
        if (this.ssiProcessor == null) {
            this.ssiProcessor = new SsiProcessor(false);
        }
        ByteBuf buffer = channel.alloc().ioBuffer();
        boolean releaseBuffer = true;
        try {
            HttpResponse httpResponse;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            long lastModified = ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file.getParent()), VfsUtilCore.loadText((VirtualFile)file), file.getTimeStamp(), new ByteBufUtf8Writer(buffer));
            if (FileResponses.prepareSend((HttpRequest)request, channel, lastModified, file.getPath()) == null) return;
            HttpResponse response = httpResponse;
            keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (request.method() != HttpMethod.HEAD) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (!releaseBuffer) return;
            buffer.release();
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive) return;
        future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private final boolean hasAccess(@JetValueParameter(name="result") File result) {
        return !result.isDirectory() && result.canRead() && !result.isHidden() && !KotlinPackage.startsWith$default((String)result.getName(), (String)".ht", (boolean)false, (int)2);
    }
}

