/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PairFunction;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerPackage;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

public class WebServerPathToFileManager {
    private static final PairFunction<String, VirtualFile, VirtualFile> RELATIVE_PATH_RESOLVER = new PairFunction<String, VirtualFile, VirtualFile>(){

        @Nullable
        public VirtualFile fun(String path, VirtualFile parent) {
            return parent.findFileByRelativePath(path);
        }
    };
    private static final PairFunction<String, VirtualFile, VirtualFile> EMPTY_PATH_RESOLVER = new PairFunction<String, VirtualFile, VirtualFile>(){

        @Nullable
        public VirtualFile fun(String path, VirtualFile parent) {
            return BuiltInWebServerPackage.findIndexFile(parent);
        }
    };
    private final Project project;
    final Cache<String, VirtualFile> pathToFileCache;
    private final Cache<VirtualFile, PathInfo> fileToRoot;

    public static WebServerPathToFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "getInstance"));
        }
        return (WebServerPathToFileManager)ServiceManager.getService((Project)project, WebServerPathToFileManager.class);
    }

    public WebServerPathToFileManager(@NotNull Application application, @NotNull Project project) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "<init>"));
        }
        this.pathToFileCache = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.fileToRoot = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        this.project = project;
        application.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/builtInWebServer/WebServerPathToFileManager$3", "after"));
                }
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        VirtualFile file = ((VFileContentChangeEvent)vFileEvent).getFile();
                        for (WebServerRootsProvider rootsProvider : (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions()) {
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file)) continue;
                            WebServerPathToFileManager.this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    WebServerPathToFileManager.this.clearCache();
                    break;
                }
            }
        });
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                WebServerPathToFileManager.this.clearCache();
            }
        });
    }

    private void clearCache() {
        this.pathToFileCache.invalidateAll();
        this.fileToRoot.invalidateAll();
    }

    @Nullable
    public VirtualFile get(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "get"));
        }
        return this.get(path, true);
    }

    @Nullable
    public VirtualFile get(@NotNull String path, boolean cacheResult) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "get"));
        }
        VirtualFile result = (VirtualFile)this.pathToFileCache.getIfPresent((Object)path);
        if (result == null || !result.isValid()) {
            result = this.findByRelativePath(this.project, path);
            if (cacheResult && result != null && result.isValid()) {
                this.pathToFileCache.put((Object)path, (Object)result);
            }
        }
        return result;
    }

    @Nullable
    public String getPath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "getPath"));
        }
        PathInfo pathInfo = this.getRoot(file);
        return pathInfo == null ? null : pathInfo.getPath();
    }

    @Nullable
    public PathInfo getRoot(@NotNull VirtualFile child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "getRoot"));
        }
        PathInfo result = (PathInfo)this.fileToRoot.getIfPresent((Object)child);
        if (result == null) {
            for (WebServerRootsProvider rootsProvider : (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions()) {
                result = rootsProvider.getRoot(child, this.project);
                if (result == null) continue;
                this.fileToRoot.put((Object)child, (Object)result);
                break;
            }
        }
        return result;
    }

    @Nullable
    VirtualFile findByRelativePath(@NotNull Project project, @NotNull String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "findByRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "findByRelativePath"));
        }
        for (WebServerRootsProvider rootsProvider : (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions()) {
            PathInfo result = rootsProvider.resolve(path, project);
            if (result == null) continue;
            this.fileToRoot.put((Object)result.getChild(), (Object)result);
            return result.getChild();
        }
        return null;
    }

    @NotNull
    public PairFunction<String, VirtualFile, VirtualFile> getResolver(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "getResolver"));
        }
        PairFunction<String, VirtualFile, VirtualFile> pairFunction = path.isEmpty() ? EMPTY_PATH_RESOLVER : RELATIVE_PATH_RESOLVER;
        if (pairFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/WebServerPathToFileManager", "getResolver"));
        }
        return pairFunction;
    }
}

