/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.suppress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointManager$$TImpl;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.FunctionSupport;
import org.jetbrains.util.concurrency.ConcurrencyPackage;
import org.jetbrains.util.concurrency.Promise;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"A\f))\"I]3bWB|\u0017N\u001c;NC:\fw-\u001a:CCN,'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\tI\u0016\u0014WoZ4fe*\tAK\u0003\bCe\u0016\f7\u000e]8j]R\u0014\u0015m]3\u000b#\t\u0013X-Y6q_&tG/T1oC\u001e,'O\u0003\u0004=S:LGO\u0010\u0006\u001eEJ,\u0017m\u001b9pS:$H)\u001e9mS\u000e\fG/[8o\u0005f$\u0016M]4fi*i1i\u001c8dkJ\u0014XM\u001c;NCBTAA[1wC*!Q\u000f^5m\u0015)\u0019wN\\2veJ,g\u000e\u001e\u0006!O\u0016$(I]3bWB|\u0017N\u001c;EkBd\u0017nY1uS>t')\u001f+be\u001e,GOC\u0006ce\u0016\f7\u000e]8j]R\u001c(BC'vi\u0006\u0014G.Z*fi*11n\u001c;mS:T1aU3u\u001599W\r\u001e\"sK\u0006\\\u0007o\\5oiNT!\u0002Z5ta\u0006$8\r[3s\u0015=)e/\u001a8u\t&\u001c\b/\u0019;dQ\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\nCe\u0016\f7\u000e]8j]Rd\u0015n\u001d;f]\u0016\u0014(\"D4fi\u0012K7\u000f]1uG\",'OC\u000bbI\u0012\u0014%/Z1la>Lg\u000e\u001e'jgR,g.\u001a:\u000b\u00111L7\u000f^3oKJTA!\u00168ji*!#I]3bWB|\u0017N\u001c;NC:\fw-\u001a:%\u0005J,\u0017m\u001b9pS:$H*[:uK:,'O\u0003\tde\u0016\fG/\u001a\"sK\u0006\\\u0007o\\5oi*1A/\u0019:hKRT\u0001C\u0011:fC.\u0004x.\u001b8u)\u0006\u0014x-\u001a;\u000b\t1Lg.\u001a\u0006\u0004\u0013:$(BB2pYVlgNC\u0005d_:$\u0017\u000e^5p]*11\u000b\u001e:j]\u001eT1\"[4o_J,7i\\;oi*9QM\\1cY\u0016$'b\u0002\"p_2,\u0017M\u001c\u0006\u0005Y\u0006twMC\te_\u000ecW-\u0019:Ce\u0016\f7\u000e]8j]RT!B\u0019:fC.\u0004x.\u001b8u\u0015\u001d\u0001&o\\7jg\u0016T1bY8oGV\u0014(/\u001a8ds*yAm\\*fi\n\u0013X-Y6q_&tGO\u0003\u0006Ce\u0016\f7\u000e]8j]RT\u0011#\u001a8bE2,'I]3bWB|\u0017N\u001c;t\u0015\u00151G.^:i\u0015\u0001rw\u000e^5gs\n\u0013X-Y6q_&tGOU3t_24X\r\u001a'jgR,g.\u001a:\u000b\rI,Wn\u001c<f\u0015%\u0011X-\\8wK\u0006cGNC\u0007tKR\u0014%/Z1la>Lg\u000e\u001ew\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQa\u0001\u0003\u0002\u0011\u0001a\u0001!B\u0002\u0005\u0003!\u0015A\u0002A\u0003\u0004\t\u0005A1\u0001\u0004\u0001\u0006\u0003!)QA\u0001\u0003\u0004\u0011\u0017)!\u0001b\u0002\t\r\u0015\u0019A\u0001\u0002E\u0005\u0019\u0001)!\u0001\u0002\u0003\t\n\u0015\t\u0001\u0002C\u0003\u0004\t\u0017Ay\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0012C\u0003\u0002\u0011+)!\u0001B\u0004\t\u0017\u0015\u0011Aq\u0002E\u0006\u000b\r!\u0001\u0002\u0003\u0006\r\u0001\u0015\u0019AQ\u0001E\f\u0019\u0001)!\u0001\u0002\u0005\t\u0015\u0015\u0019A1\u0002E\u000e\u0019\u0001)!\u0001B\u0001\t\u001d\u0015\u0019A!\u0001E\u0010\u0019\u0001)1\u0001b\u0003\t\"1\u0001Qa\u0001C\u0006\u0011Ia\u0001!B\u0002\u0005\f!\u001dB\u0002A\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0003!}QA\u0001\u0003\u0004\u0011Q)!\u0001\u0002\b\t%\u0015\u0011A\u0011\u0001E\u0006\u000b\t!q\u0002\u0003\f\u0006\u0007\u0011}\u00012\u0006\u0007\u0001\u000b\t!y\u0002c\u000b\u0006\u0007\u0011\t\u0001b\u0006\u0007\u0001\u000b\t!\u0011\u0001C\f\u0005'1\rQc\u0002\u0003\u0001\u0011\t)B!B\u0001\t\u0005%\tA1A\r\u0003\u000b\u0005A)!L\r\u0005E\u0012AB!\t\u0007\u0006\u0003!%\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0001)6\u0001C\u0003\u0004\t\u0011I\u0011\u0001C\u0003\u000e\u0007\u00115\u0011\"\u0001\u0005\u0006[Q!1\u000e\u0002\r\bC\u001d)\u0011\u0001\u0003\u0004\n\t%\u0019QA\u0001C\u0001\u0011\u0001)6\u0001C\u0003\u0004\t\u001dI\u0011\u0001#\u0004\u000e\u0007\u0011I\u0011\"\u0001E\u0007[M!!\r\u0002M\nC\u0019)\u0011\u0001#\u0005\n\u0007%\u0011Q!\u0001\u0005\n+\u000eAQa\u0001C\n\u0013\u0005A\u0019\"D\u0002\u0005\u0019%\t\u00012C\u0017\u0014\t-AJ\"(\u0004\u0005\u0001!iQBA\u0003\u0002\u0011%\u00016\u0001A\u0011\u0003\u000b\u0005A!\"U\u0002\u0006\t3I\u0011\u0001\u0002\u0001\u000e\u0003!UQ\u00162\u0001\u0005%auQT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0017A\u001b\u0001!(\u0004\u0005\u0001!\u0001RBA\u0003\u0002\u0011/\u00016\u0011AO\u0007\t\u0001A\u0011#\u0004\u0002\u0006\u0003!]\u0001kA\u0001\u001e\u0010\u0011\u0001\u00012E\u0007\u0004\u000b\u0005AA\u0002$\u0001Q\u0007\u0007ij\u0001\u0002\u0001\t&5\u0011Q!\u0001E\f!\u000e\u0011QT\u0002\u0003\u0001\u0011Mi!!B\u0001\t\u001aA\u001b)!I\u0002\u0006\u0005\u0011\u0005\u0001\u0002A)\u0004\u001f\u0011u\u0011\"\u0001\u0005\u000e\u001b\u0005AY\"D\u0001\u0005\u00065\tAQA\u0007\u0002\u0011;i\u0011\u0001\"\u0002\u000e\u0003\u0011\u0005QF\u0006\u0003\u00131Siz\u0001\u0002\u0001\t+5\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001A\u0011\u0005\u000b\u0005A\u0001#C\u0001\u0005\u0004E\u001bQ\u0001\"\u000b\n\u0003!\u0005R\"\u0001\u0005\u000e[\u0007\"!\u0003'\f\u001e\u000e\u0011\u0001\u0001bD\u0007\u0003\u000b\u0005A1\u0002U\u0002\u0001;\u001f!\u0001\u0001C\u000b\u000e\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005\u0011EB\u0003\u0002\u0011AI1!\u0003\u0002\u0006\u0003!\t\u0012kA\u0004\u0005.%\t\u0001\u0012E\u0007\u0002\u00117i\u0011\u0001C\u0007.+\u0011Y\u0001tFO\u0007\t\u0001A1#\u0004\u0002\u0006\u0003!e\u0001k\u0001\u0001\"\t\u0015\t\u0001\u0002E\u0005\u0002\t\u0007\t6!\u0002C\u0018\u0013\u0005A\t#D\u0001\u0005\u00025*Bq\u0003\r\u0019;\u001b!\u0001\u0001C\u000b\u000e\u0005\u0015\t\u0001\"\u0005)\u0004\u0001\u0005\"Q!\u0001\u0005\u0011\u0013\u0005!\u0019!U\u0002\u0006\taI\u0011\u0001#\t\u000e\u0003!\rR\u0006\u0006\u0003\u00031ciz\u0001\u0002\u0001\t+5\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001A\u0011\u0003\u000b\u0005A!\"U\u0002\u0006\tcI\u0011\u0001\u0002\u0001\u000e\u0003!iQ&\u0006\u0003\f1eij\u0001\u0002\u0001\t+5\u0011Q!\u0001\u0005\u0012!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011AI\u0011\u0001b\u0001R\u0007\u0015!\u0011$C\u0001\t\"5\t\u00012EW\f\t-A\u001a$\t\u0003\u0006\u0003!\u0001\u0012\"\u0001C\u0002#\u000e\u0019A1G\u0005\u0002\u0011Ci;\u0019\u0001\u0003\f1iij\u0001\u0002\u0001\t\u001f5\u0011Q!\u0001\u0005\f!\u000e\u0001QT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\t!(\u0004\u0005\u0001!\tRBA\u0003\u0002\u0011/\u00016!AO\b\t\u0001A\u0019#D\u0002\u0006\u0003!aA\u0012\u0001)\u0004\u0004u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001c\u0006Q\u0007\tij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\r!\u000e\u0015\u0011EA\u0003\u0002\u0011E\t6a\u0004\u0003\u001b\u0013\u0005A\u0019#D\u0001\t\u001c5\tAQA\u0007\u0002\t\u000bi\u0011\u0001#\b\u000e\u0003\u0011\u0015Q\"\u0001C\u0001ka)q\u0003Br\u0001#\u001d!\u0001\u0001\u0003\u0002\u0016\t\u0015\t\u0001BA\u0005\u0002\t\u0007A:!I\u0004\u0006\u0003!\r\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001R\u0007\r!9!C\u0001\u0005\u0001\u0001"})
public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Set<T> breakpoints;
    @NotNull
    private final ConcurrentMap<T, T> breakpointDuplicationByTarget;
    @NotNull
    private final EventDispatcher<BreakpointManager.BreakpointListener> dispatcher;

    static {
        $kotlinClass = Reflection.createKotlinClass(BreakpointManagerBase.class);
    }

    @NotNull
    public Set<T> getBreakpoints() {
        return this.breakpoints;
    }

    @NotNull
    protected final ConcurrentMap<T, T> getBreakpointDuplicationByTarget() {
        return this.breakpointDuplicationByTarget;
    }

    @NotNull
    protected final EventDispatcher<BreakpointManager.BreakpointListener> getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    protected abstract T createBreakpoint(@JetValueParameter(name="target") @NotNull BreakpointTarget var1, @JetValueParameter(name="line") int var2, @JetValueParameter(name="column") int var3, @JetValueParameter(name="condition", type="?") @Nullable String var4, @JetValueParameter(name="ignoreCount") int var5, @JetValueParameter(name="enabled") boolean var6);

    @NotNull
    protected abstract Promise<Breakpoint> doSetBreakpoint(@JetValueParameter(name="target") @NotNull BreakpointTarget var1, @JetValueParameter(name="breakpoint") @NotNull T var2);

    @Override
    @NotNull
    public Breakpoint setBreakpoint(@JetValueParameter(name="target") @NotNull BreakpointTarget target, @JetValueParameter(name="line") int line, @JetValueParameter(name="column") int column, @JetValueParameter(name="condition", type="?") @Nullable String condition, @JetValueParameter(name="ignoreCount") int ignoreCount, @JetValueParameter(name="enabled") boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        T breakpoint = this.createBreakpoint(target, line, column, condition, ignoreCount, enabled);
        BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
        if (existingBreakpoint != null) {
            return existingBreakpoint;
        }
        this.getBreakpoints().add(breakpoint);
        if (enabled) {
            this.doSetBreakpoint(target, breakpoint).rejected((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, breakpoint){
                final /* synthetic */ BreakpointManagerBase this$0;
                final /* synthetic */ BreakpointBase $breakpoint;

                public final void invoke(@JetValueParameter(name="it") @NotNull Throwable it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    BreakpointManager.BreakpointListener breakpointListener = (BreakpointManager.BreakpointListener)this.this$0.getDispatcher().getMulticaster();
                    Breakpoint breakpoint = this.$breakpoint;
                    String string = it.getMessage();
                    if (string == null) {
                        string = it.toString();
                    }
                    breakpointListener.errorOccurred(breakpoint, string);
                }
                {
                    this.this$0 = breakpointManagerBase;
                    this.$breakpoint = breakpointBase;
                    super(1);
                }
            }));
        }
        return (Breakpoint)breakpoint;
    }

    @Override
    @NotNull
    public Promise<?> remove(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        Breakpoint breakpoint2 = breakpoint;
        if (breakpoint2 == null) {
            throw new TypeCastException("org.jetbrains.debugger.Breakpoint cannot be cast to T");
        }
        BreakpointBase b = (BreakpointBase)breakpoint2;
        boolean existed = this.getBreakpoints().remove(b);
        if (existed) {
            this.breakpointDuplicationByTarget.remove(b);
        }
        return !existed || !b.isVmRegistered() ? ConcurrencyPackage.ResolvedPromise() : this.doClearBreakpoint(b);
    }

    @Override
    @NotNull
    public Promise<?> removeAll() {
        List list = KotlinPackage.toList((Iterable)this.getBreakpoints());
        this.getBreakpoints().clear();
        this.breakpointDuplicationByTarget.clear();
        SmartList promises = new SmartList();
        for (BreakpointBase b : list) {
            if (!b.isVmRegistered()) continue;
            promises.add(this.doClearBreakpoint(b));
        }
        return Promise.Companion.all((Collection)promises);
    }

    @NotNull
    protected abstract Promise<?> doClearBreakpoint(@JetValueParameter(name="breakpoint") @NotNull T var1);

    @Override
    public void addBreakpointListener(@JetValueParameter(name="listener") @NotNull BreakpointManager.BreakpointListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    protected final void notifyBreakpointResolvedListener(@JetValueParameter(name="breakpoint") @NotNull T breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        if (((BreakpointBase)breakpoint).getIsResolved()) {
            ((BreakpointManager.BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }

    @Override
    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public Promise<?> flush(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        Breakpoint breakpoint2 = breakpoint;
        if (breakpoint2 == null) {
            throw new TypeCastException("org.jetbrains.debugger.Breakpoint cannot be cast to T");
        }
        return ((BreakpointBase)breakpoint2).flush(this);
    }

    @Override
    @NotNull
    public Promise<?> enableBreakpoints(@JetValueParameter(name="enabled") boolean enabled) {
        return ConcurrencyPackage.RejectedPromise("Unsupported");
    }

    public BreakpointManagerBase() {
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.newConcurrentSet<T>()");
        this.breakpoints = set;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)new TObjectHashingStrategy<T>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(breakpointDuplicationByTarget.1.class);
            }

            public int computeHashCode(@JetValueParameter(name="b") @NotNull T b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                int result = ((BreakpointBase)b).getLine();
                result *= 31 + ((BreakpointBase)b).getColumn();
                if (((BreakpointBase)b).getCondition() != null) {
                    String string = ((BreakpointBase)b).getCondition();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    result *= 31 + string.hashCode();
                }
                return result *= 31 + ((BreakpointBase)b).getTarget().hashCode();
            }

            public boolean equals(@JetValueParameter(name="b1") @NotNull T b1, @JetValueParameter(name="b2") @NotNull T b2) {
                Intrinsics.checkParameterIsNotNull(b1, (String)"b1");
                Intrinsics.checkParameterIsNotNull(b2, (String)"b2");
                return Intrinsics.areEqual(((BreakpointBase)b1).getTarget().getClass(), ((BreakpointBase)b2).getTarget().getClass()) && Intrinsics.areEqual((Object)((BreakpointBase)b1).getTarget(), (Object)((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && StringUtil.equals((CharSequence)((BreakpointBase)b1).getCondition(), (CharSequence)((BreakpointBase)b2).getCondition());
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurr\u2026ition, b2.condition)\n  })");
        this.breakpointDuplicationByTarget = concurrentMap;
        EventDispatcher eventDispatcher = EventDispatcher.create(BreakpointManager.BreakpointListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(j\u2026er.BreakpointListener>())");
        this.dispatcher = eventDispatcher;
    }

    @Override
    public boolean getRegExpBreakpointSupported() {
        return BreakpointManager$$TImpl.getRegExpBreakpointSupported(this);
    }

    @Override
    @Nullable
    public FunctionSupport getFunctionSupport() {
        return BreakpointManager$$TImpl.getFunctionSupport(this);
    }

    @Override
    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager$$TImpl.getMuteMode(this);
    }
}

