/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"( )\u0001B)\u001a2vOB\u0013xnY3tg&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015!!WMY;hO\u0016\u0014(\"A\"\u000b\u0019Yk7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0015\r|gN\\3di&|gNC\u0007Y\t\u0016\u0014Wo\u001a)s_\u000e,7o\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0013a$WMY;hO\u0016\u0014(B\u0002\u001fj]&$hHC\u0004tKN\u001c\u0018n\u001c8\u000b\u001ba#UMY;h'\u0016\u001c8/[8o\u0015=)G-\u001b;peN\u0004&o\u001c<jI\u0016\u0014(\u0002\u0007-EK\n,xmZ3s\u000b\u0012LGo\u001c:t!J|g/\u001b3fe*QQM^1mk\u0006$\u0018n\u001c8\u000b)Ml\u0017M\u001d;Ti\u0016\u0004\u0018J\u001c;p\u0011\u0006tG\r\\3s\u0015UA6+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT\u0001b\u001d;faBLgn\u001a\u0006\u0010Kb,7-\u001e;j_:\u0014Vm];mi*yQ\t_3dkRLwN\u001c*fgVdGOC\u0005fq\u0016\u001cW\u000f^5p]*\u0019rL\u0019:fC.\u0004x.\u001b8u\u0011\u0006tG\r\\3sg*)\u0011I\u001d:bs*11n\u001c;mS:T!\u0003\u0017\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7fe*Y!M]3bWB|\u0017N\u001c;t\u0015qy&M]3bWB|\u0017N\u001c;IC:$G.\u001a:tI\u0011,G.Z4bi\u0016T!\u0002\u001d:pa\u0016\u0014H/[3t\u0015A\u0011V-\u00193P]2L\bK]8qKJ$\u0018P\u0003\fhKR|&M]3bWB|\u0017N\u001c;IC:$G.\u001a:t\u001559W\r^\"p]:,7\r^5p]*iB-[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7OC\u0004C_>dW-\u00198\u000bA\u001d,G\u000fR5tC\ndW\rR8O_R\u001cF/\u001a9J]R|G*\u001b2sCJLWm\u001d\u0006!g\u0016$H)[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7O\u0003\nhKR,\u00050Z2vi&|gNU3tk2$(bC5t\r>\u00148-Z*uKBTabZ3u\u0013N4uN]2f'R,\u0007O\u0003\btKRL5OR8sG\u0016\u001cF/\u001a9\u000b\u001b1\f7\u000f^\"bY24%/Y7f\u0015%\u0019\u0015\r\u001c7Ge\u0006lWM\u0003\thKRd\u0015m\u001d;DC2dgI]1nK*\u00012/\u001a;MCN$8)\u00197m\rJ\fW.\u001a\u0006\tY\u0006\u001cHo\u0015;fa*Q1\u000b^3q\u0003\u000e$\u0018n\u001c8\u000b\u0017\u001d,G\u000fT1tiN#X\r\u001d\u0006\fg\u0016$H*Y:u'R,\u0007O\u0003\u0013qe>\u001cWm]:Ce\u0016\f7\u000e]8j]R\u001cuN\u001c3ji&|gn]!u\u0013\u0012,7+\u001b3f\u0015\u001d:W\r\u001e)s_\u000e,7o\u001d\"sK\u0006\\\u0007o\\5oi\u000e{g\u000eZ5uS>t7/\u0011;JI\u0016\u001c\u0016\u000eZ3\u000bOM,G\u000f\u0015:pG\u0016\u001c8O\u0011:fC.\u0004x.\u001b8u\u0007>tG-\u001b;j_:\u001c\u0018\t^%eKNKG-\u001a\u0006\u0013e\u0016\fG\u000e\u0015:pG\u0016\u001c8\u000fS1oI2,'O\u0003\bQe>\u001cWm]:IC:$G.\u001a:\u000b\u000fA\u0014xnY3tg*)r-\u001a;SK\u0006d\u0007K]8dKN\u001c\b*\u00198eY\u0016\u0014(B\u0004:fa\u0016\fGo\u0015;fa&sGo\u001c\u0006\u000e\u0003R|W.[2C_>dW-\u00198\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0006d_:\u001cWO\u001d:f]RTa!\u0019;p[&\u001c'\"E4fiJ+\u0007/Z1u'R,\u0007/\u00138u_*qQO\u001d7U_\u001aKG.Z\"bG\",'\"D\"p]\u000e,(O]3oi6\u000b\u0007OC\u0002Ve2T1BV5siV\fGNR5mK*9q\u000e]3oCBL'b\u0001<gg*\tr-\u001a;Ve2$vNR5mK\u000e\u000b7\r[3\u000b\u0005Yl'B\u0001,n\u0015\u00159W\r\u001e,n\u0015E\u0011'/Z1la>Lg\u000e\u001e*fC\u000eDW\r\u001a\u0006\u000bEJ,\u0017m\u001b9pS:$(b\u0003-Ce\u0016\f7\u000e]8j]RTa#\u001a<bYV\fG/\u001a3M_\u001e,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\u001dM,8\u000f]3oI\u000e{g\u000e^3yi*y\u0001lU;ta\u0016tGmQ8oi\u0016DHOC\u0003ge\u0006lWM\u0003\u0003V]&$(\u0002\u00027b]\u001eTqc\u00195fG.\u001c\u0015M\u001c)fe\u001a|'/\\\"p[6\fg\u000eZ:\u000b\u0015\r|g\u000e^5ok\u00164VN\u0003\u0006ti\u0016\u0004\u0018i\u0019;j_:T\u0001d\u0019:fCR,'I]3bWB|\u0017N\u001c;IC:$G.\u001a:t\u0015M!wnR3u!J|7-Z:t\u0011\u0006tG\r\\3s\u0015U9W\r\u001e\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7feNT\u0001eZ3u\u0007V\u0014(/\u001a8u'R\fG/\u001a%za\u0016\u0014H.\u001b8l\u0019&\u001cH/\u001a8fe*\t\u0002*\u001f9fe2Lgn\u001b'jgR,g.\u001a:\u000b\u000b)\fg/\u0019=\u000b\u000bM<\u0018N\\4\u000b\u000b\u00154XM\u001c;\u000b\u00119+H\u000e\\1cY\u0016T1\"\u00198o_R\fG/[8og*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0017O\u0016$8)\u001e:sK:$8\u000b^1uK6+7o]1hK*9aj\u001c;Ok2d'BE4fi\u0016#\u0017\u000e^8sgB\u0013xN^5eKJT\u0011dZ3u\u0019>\u001c\u0017\r^5p]N4uN\u001d\"sK\u0006\\\u0007o\\5oi*y\u0001\fT5oK\n\u0013X-Y6q_&tGOC\u000ep]2L8k\\;sG\u0016l\u0015\r\u001d9fI\n\u0013X-Y6q_&tGo\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0005M_\u000e\fG/[8o\u0015]9W\r^*nCJ$8\u000b^3q\u0013:$x\u000eS1oI2,'O\u0003\u000bjgZ\u000bG.^3t\u0007V\u001cHo\\7T_J$X\r\u001a\u0006\u0013SN4Vn\u0015;fa>+HoQ8se\u0016\u001cGOC\tqe>\u001cWm]:Ce\u0016\f7\u000e]8j]RTabU;ta\u0016tGmQ8oi\u0016DHOC\by'V\u001c\b/\u001a8e\u0007>tG/\u001a=u\u0015I\u0019Vo\u001d9f]\u0012\u001cuN\u001c;fqRLU\u000e\u001d7\u000bQA\u0014xnY3tg\n\u0013X-Y6q_&tG\u000fT8h\u000bb\u0004(/Z:tS>t\u0017I\u001c3TkN\u0004XM\u001c3\u000b\rI,7/^7f\u0015A\u0019\u0018M^3SKN|GN^3e\r&dWMC\u0002ve2TAAZ5mK*Q1/\u001a;Pm\u0016\u0014H.Y=\u000b%M$\u0018M\u001d;G_J\u001cWm\u0015;fa&sGo\u001c\u0006\rgR\f'\u000f\u001e)bkNLgn\u001a\u0006\u000egR\f'\u000f^*uKBLe\u000e^8\u000b\u0019M$\u0018M\u001d;Ti\u0016\u0004x*\u001e;\u000b\u001bM$\u0018M\u001d;Ti\u0016\u0004xJ^3s\u0015M)\b\u000fZ1uK2\u000b7\u000f^\"bY24%/Y7f1\u0013Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0004\t\u0005A\u0001\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001bA\u0003\u0004\t\tA)\u0001\u0004\u0001\u0006\u0003!!QA\u0001\u0003\u0004\u0011\u0013)!\u0001b\u0002\t\u000b\u0015\u0019A\u0001\u0002E\u0004\u0019\u0001)1\u0001\u0002\u0003\t\u000e1\u0001QA\u0001\u0003\u0005\u0011!)1\u0001b\u0003\t\u00101\u0001QA\u0001\u0003\u0005\u0011')1\u0001\"\u0004\t\u00131\u0001QA\u0001C\u0004\u0011-)1\u0001b\u0004\t\u00161\u0001QA\u0001\u0003\u0005\u0011\u001b)!\u0001\u0002\u0002\t\u0006\u0015\u0011A1\u0002E\b\u000b\t!i\u0001C\u0005\u0006\u0005\u0011=\u0001RC\u0003\u0002\u00113)1\u0001B\u0006\t\u00191\u0001QA\u0001\u0003\u0005\u00117)1\u0001\u0002\u0007\t\u001b1\u0001QA\u0001\u0003\f\u0011;)!\u0001B\u0007\t\u001f\u0015\u0011A\u0001\u0004\u0005\u000e\u000b\r!1\u0002C\t\r\u0001\u0015\u0019A!\u0001\u0005\u0016\u0019\u0001)!\u0001B\u0001\t+\u0015\u0019A!\u0001\u0005\u0018\u0019\u0001)!\u0001B\u0001\t/\u0015\u0011Aq\u0002\u0005\u001c\u000b\r!\u0011\u0003#\u000e\r\u0001\u0015\u0011A!\u0005E\u001b\u000b\u0005AQ$\u0002\u0002\u0005&!mRA\u0001\u0003\u0014\u0011y)!\u0001b\n\t>\u0015\u0019A\u0001\u0006E\u001d\u0019\u0001)!\u0001\u0002\u000b\t:\u0015\u0019Aq\u0005\u0005!\u0019\u0001)!\u0001b\u0002\t<\u0015\u0019AA\u0006E!\u0019\u0001)!\u0001b\u0002\tD\u0015\u0011Aa\u0006\u0005#\u000b\r!y\u0003C\u0011\r\u0001\u0015\u0011Aq\u0005\u0005!\u000b\r!\u0011\u0001c\u0012\r\u0001\u0015\u0011A!\u0001E$\u000b\r!A\u0002c\u0013\r\u0001\u0015\u0019Aa\u0003E'\u0019\u0001)!\u0001\u0002\u0003\tQ\u0015\u0019Aa\u0007E(\u0019\u0001)1\u0001B\u0006\tR1\u0001QA\u0001\u0003\r\u0011\u0017*!\u0001\"\n\tS\u0015\u0011A!\bE'\u000b\t!1\u0004c\u0014\u0006\u0003!mSA\u0001C\u001f\u00119*!\u0001B\u0010\t^\u0015\u0019Aq\b\u0005.\u0019\u0001)!\u0001\"\u0001\t`\u0015\u0019A\u0011\t\u00050\u0019\u0001)!\u0001b\u0010\t[\u0015\u0019A\u0011\t\u00052\u0019\u0001)1\u0001\u0002\u0007\tf1\u0001Qa\u0001\u0003\f\u0011Ob\u0001!B\u0002\u0005\u0003!!D\u0002A\u0003\u0003\tMA9'\u0002\u0002\u0005\u0019!\u0015Ta\u0001\u0003\u0002\u0011[b\u0001!\u0002\u0002\u0005\u0003!ASa\u0001C&\u0011_b\u0001!\u0002\u0002\u0005\u0003!5TA\u0001C&\u0011_*!\u0001\u0002\f\tB\u0015\u0011Aq\u0006\u0005\"\tMa\u0019!F\u0004\u0005\u0001!\u0011Q\u0003B\u0003\u0002\u0011\u000bI\u0011\u0001b\u0001\u001a\u0005\u0015\t\u0001\u0012B\u0017\u0018\t\u0005$\u0001tC\u0011\t\u000b\u0005A9\"C\u0003\n\t\u0015\t\u0001\u0012D\u0005\u0002\t\u0007!\u0013%V\u0002\n\u000b\r!a\"C\u0001\t\u001c5!AqD\u0005\u0003\u00119a\t!\f\t\u0005G\u0012A2!I\u0002\u0006\u0005\u0011\u0005\u0001\u0002A+\u0004\u0011\u0015\u0019AaA\u0005\u0002\u0011%i1\u0001\u0002\t\n\u0003!IQf\u0006CC\u001aa\u0005\u0012EA\u0003\u0002\u0011;!#\u0001\u000b\u0002V\u00079)1\u0001\"\t\n\u0003\u0011\u0005Qb\u0001C\u0012\u0013\u0005!\t!E\u0003\u0005%%\tA\u0001A\u0007\u0002\t\u0003i3\u0002B1\u00051\u001d\t#!B\u0001\t\rU\u001bA!B\u0002\u0005\u000f%\t\u00012C\u0017\u0011\t\t$\u0001DC\u0011\u0004\u000b\u0005A\u0001\u0002$\u0001V\u0007!)1\u0001\u0002\u0006\n\u0003!UQb\u0001C\u0013\u0013\u0005A)\"L\f\u0005\u00064A2#\t\u0002\u0006\u0003!uAE\u0001\u0015\u0003+\u000eqQa\u0001\u0003\u0014\u0013\u0005!\t!D\u0002\u0005(%\tA\u0011A\t\u0006\tQI\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0005Q\u0006\u0007CC\u001aa%\u0012eA\u0003\u0002\u0011=a\t\u0001\n\u0002)\u0005U\u001ba\"B\u0002\u0005*%\t\u0001rD\u0007\u0004\tWI\u0011\u0001c\b\u0012\u000b\u00111\u0012\"\u0001\u0003\u0001\u001b\u0005Ay\"\f\r\u0005\u00064Aj#I\u0002\u0006\u0003!\u0001B\u0012\u0001\u0013\u0003Q\t)6AD\u0003\u0004\t[I\u0011\u0001#\t\u000e\u0007\u0011=\u0012\"\u0001E\u0011#\u0015!\u0001$C\u0001\u0005\u00015\t\u0001\u0012E\u0017\u0016\t\rg\u0001\u0014G\u0011\u0003\u000b\u0005Ai\"V\u0002\u000f\u000b\r!\t$C\u0001\u0005\u00025\u0019A!G\u0005\u0002\t\u0003\tR\u0001b\r\n\u0003\u0011\u0001Q\"\u0001C\u0001[5!!\r\u0002\r\u001bC\r)\u0011\u0001c\t\r\u0002\u0011\u0012Sk\u0001\u0003\u000e\u0007\u0011]\u0012\"\u0001\u0005\u0013[=!!\r\u0002\r\u001dC\t)\u0011\u0001#\u000bV\u0007!)1\u0001\u0002\u000f\n\u0003!)Rb\u0001\u0003 \u0013\u0005AQ#\f\b\u0005C\u0012A\n\"I\u0003\u0006\u0003!9\u0011\"\u0001C\u0002\u0019\u0003)6\u0001B\u0003\u0004\t#I\u0011\u0001\u0003\u0006./\u0011\u0011G\u0001g\u0010\"\u0015\u0015\t\u00012F\u0005\u0004\u0013\t)\u0011\u0001#\f\n\u0007%\u0011Q!\u0001\u0005\u0019+\u000eAQa\u0001C \u0013\u0005A\t$D\u0002\u0005F%\t\u0001\u0012G\u0017\u000e\t\r$\u0001dI\u0011\u0004\u000b\u0005A\u0011\u0004$\u0001%GU\u001bA!D\u0002\u0005I%\t\u00012G\u0017*\t\u0005AJ%(\u0005\u0005\u0001!)S\u0002B\u0003\u0002\u0011iI\u0011\u0001b\u0001Q\u0007\u0001iz\u0001\u0002\u0001\tM5\u0019Q!\u0001E\u001b\u0019\u0003\u00016\u0011AO\u0007\t\u0001Aq%\u0004\u0002\u0006\u0003!]\u0002kA\u0001\"\u0005\u0015\t\u0001\u0002H)\u0004\u0013\u0011%\u0013\"\u0001\u0003\u0001\u001b\u0005AI$D\u0001\t<5\t\u0001BHW\n\t\rA\u001a&\t\u0002\u0006\u0003!u\u0011kA\u0002\u0005T%\tA\u0011A\u0017\u0014\t\tA\"&(\u0004\u0005\u0001!USBA\u0003\u0002\u0011A\u00016\u0001A\u0011\u0003\u000b\u0005AA$U\u0002\u0006\t)J\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\u0016\u0005\u0003\u00131-\n\u0003\"B\u0001\t\u0018%)\u0011\u0002B\u0003\u0002\u00113I\u0011\u0001b\u0001R\u0007\u0011!1&\u0003\u0002\t\u001d1\u0005Q6\u0003\u0003\u000b1/\n#!B\u0001\t$E\u001b1\u0001b\u0016\n\u0003!\u0011R\u0016\u0005\u0003\u000411\n\u0003\"B\u0001\t\u0018%)\u0011\u0002B\u0003\u0002\u00113I\u0011\u0001b\u0001R\u0007\u0011!A&\u0003\u0002\t\u001d1\u0005Qv\u0005\u0003\u000413\nC\"B\u0001\tAA\u0001T3B\u0003\u0002\u0011\u0001b\t!U\u0002\u0002\t\u0005\n6!\u0001\u0003\"#\u000e\u0019A\u0011L\u0005\u0002\u0011\u0007j;\u0003B\u0002\u0019b\u0005bQ!\u0001E\u001b!A*Z!B\u0001\t61\u0005\u0011kA\u0001\u0005EE\u001b\u0011\u0001\u0002\u0012R\u0007\r!\t'C\u0001\t<5NAa\u0001M2C\t)\u0011\u0001\u0003\u0004R\u0007\r!\u0019'C\u0001\t\u00145\u0016Ca\u0005\r3;#!\u0001\u0001C\u0013\u000e\t\u0015\t\u0001RI\u0005\u0002\t\u0007\u00016\u0001AO\u0007\t\u0001A1'\u0004\u0002\u0006\u0003!u\u0001k!\u0001\"\r\u0015\t\u0001bI\u0005\u0004\u0013\t)\u0011\u0001c\u0012R\u0007\u001d!!'C\u0001\tI5\t\u0001\u0012J\u0007\u0002\t\u0003iK\u0002B\u0002\u0019j\u0005*Q!\u0001\u0005\b\u0013\u0005!\u0019\u0001$\u0001R\u0007\r!I'C\u0001\t\u00155NAa\u0001\r6C\t)\u0011\u0001#\bR\u0007\r!Q'C\u0001\u0005\u00025NAA\u0003M6C\t)\u0011\u0001#\bR\u0007\r!Y'C\u0001\u0005\u00025BCA\u0001\r7;\u001b!\u0001\u0001C\u0014\u000e\u0005\u0015\t\u0001\"\n)\u0004\u0001uEA\u0001\u0001\u0005&\u001b\u0011)\u0011\u0001\u0003\u000e\n\u0003\u0011\r\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001bN\u0007\u0003\u000b\u0005Aa\u0005U\u0002\u0002C\t)\u0011\u0001\u0003\u000fR\u0007%!a'C\u0001\u0005\u00015\t\u0001RJ\u0007\u0002\u0011si\u0011\u0001C\u0014.Q\u0011\t\u0001\u0004OO\t\t\u0001AQ%\u0004\u0003\u0006\u0003!Q\u0012\"\u0001C\u0002!\u000e\u0001QT\u0002\u0003\u0001\u0011]j!!B\u0001\tMA\u001b\t!(\u0004\u0005\u0001!9SBA\u0003\u0002\u0011\u0015\u00026!A\u0011\u0003\u000b\u0005AA$U\u0002\n\taJ\u0011\u0001\u0002\u0001\u000e\u0003!eR\"\u0001\u0005(\u001b\u0005Ai%l\u0005\u0005\u0007aE\u0014EA\u0003\u0002\u0011q\t6a\u0001C9\u0013\u0005!\u0001!,\u000f\u0005\u0007aITT\u0002\u0003\u0001\u0011gj!!B\u0001\t.A\u001b\u0001!(\u0004\u0005\u0001!QTBA\u0003\u0002\u0011a\u00016\u0011A\u0011\u0003\u000b\u0005AA$U\u0002\b\teJ\u0011\u0001\u0002\u0001\u000e\u0003!=S\"\u0001\u0005)['!!\u0001'\u001e\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011U\u0014\"\u0001\u0003\u0001['!1\u0001G\u001e\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011Y\u0014\"\u0001\u0003\u0001['!1\u0001g\u001e\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011]\u0014\"\u0001\u0003\u0001['!1\u0001\u0007\u001f\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011a\u0014\"\u0001\u0003\u0001['!1\u0001'\u001f\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011e\u0014\"\u0001\u0003\u0001['!1\u0001G\u001f\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011i\u0014\"\u0001\u0003\u0001['!\u0011\u0001g\u001f\"\u0005\u0015\t\u0001\u0002H)\u0004\u0007\u0011m\u0014\"\u0001\u0003\u0001k5\u0007Qq3\u0001\u0005G\u0004\tr\u0001\u0002\u0001\t\u0005U!Q!\u0001E\u0003\u0013\u0005!\u0019\u0001g\u0003\u001e\u000e\u0011\u0001\u0001BB\u0007\u0003\u000b\u0005AQ\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0002\u000e\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011\u001di!!B\u0001\t\rA\u001b\u0011!h\u0005\u0005\u0001!EQ\"B\u0003\u0002\u0011\u001dI\u0011\u0001b\u0001\r\u0002A\u001b\u0019!h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011!a\t\u0001U\u0002\u0003C\u001d)\u0011\u0001c\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0001\t6!\u0004C\u0006\u0013\u0005!\u0001!D\u0001\t\u00125\t\u0001\"C\u0007\u0002\u0011'i\u0011\u0001\u0003\u0006\u000e\u0003!U\u0001"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final ReadOnlyProperty<? super Object, ? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DebugProcessImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_breakpointHandlers")};
    }

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@JetValueParameter(name="<set-?>", type="?") @Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@JetValueParameter(name="<set-?>", type="?") @Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean getIsForceStep() {
        return this.isForceStep;
    }

    protected final void setIsForceStep(@JetValueParameter(name="<set-?>") boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(@JetValueParameter(name="<set-?>") boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(@JetValueParameter(name="<set-?>") boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])this._breakpointHandlers$delegate.get((Object)this, $propertyMetadata[0]);
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    @NotNull
    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.get_breakpointHandlers();
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected final void continueVm(@JetValueParameter(name="stepAction") @NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@JetValueParameter(name="suspendContext") @NotNull SuspendContext suspendContext, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.1.class);
                }

                protected void consume(@JetValueParameter(name="evaluationResult") @NotNull String evaluationResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)evaluationResult, (String)"evaluationResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    if (Intrinsics.areEqual((Object)"false", (Object)evaluationResult)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.2.class);
                }

                protected void consume(@JetValueParameter(name="failure") @NotNull Throwable failure, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(@JetValueParameter(name="breakpoint") XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") SuspendContextImpl xSuspendContext, @JetValueParameter(name="suspendContext") SuspendContext suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.1.class);
                }

                protected void consume(@JetValueParameter(name="logResult") @NotNull String logResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, logResult, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, logExpression, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ String $logExpression;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.2.class);
                }

                protected void consume(@JetValueParameter(name="logResult") @NotNull Throwable logResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, "Failed to evaluate expression: " + this.$logExpression, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$logExpression = $captured_local_variable$2;
                    this.$xSuspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void breakpointReached(@JetValueParameter(name="breakpoint") XBreakpoint<?> breakpoint, @JetValueParameter(name="evaluatedLogExpression", type="?") String evaluatedLogExpression, @JetValueParameter(name="suspendContext") XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doGetProcessHandler.1.class);
                }

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@JetValueParameter(name="url") @NotNull Url url, @JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public abstract List<Location> getLocationsForBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> var1, @JetValueParameter(name="onlySourceMappedBreakpoints") boolean var2);

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@JetValueParameter(name="session") @NotNull XDebugSession session, @JetValueParameter(name="connection") @NotNull C connection, @JetValueParameter(name="editorsProvider") @NotNull XDebuggerEditorsProvider editorsProvider, @JetValueParameter(name="smartStepIntoHandler", type="?") @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @JetValueParameter(name="executionResult", type="?") @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        });
        ((VmConnection)this.connection).addListener(new SocketConnectionListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            @Override
            public void statusChanged(@JetValueParameter(name="status") @NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(status.getStatusText());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend$0(@JetValueParameter(name="$this", type="?") DebugProcessImpl<C> $this, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") @NotNull SuspendContextImpl xSuspendContext, @JetValueParameter(name="suspendContext") @NotNull SuspendContext suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached$1(@JetValueParameter(name="$this", type="?") DebugProcessImpl<C> $this, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="evaluatedLogExpression", type="?") @Nullable String evaluatedLogExpression, @JetValueParameter(name="suspendContext") @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }
}

