/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Vm;
import org.jetbrains.util.concurrency.ConcurrencyPackage;
import org.jetbrains.util.concurrency.Promise;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"`\u000e))B*\u001b8f\u0005J,\u0017m\u001b9pS:$X*\u00198bO\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\tI\u0016\u0014WoZ4fe*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019a\u0014N\\5u})\u0011a/\u001c\u0006\u0003-6TA\u0002Z3ck\u001e\u0004&o\\2fgNT\u0001\u0003R3ck\u001e\u0004&o\\2fgNLU\u000e\u001d7\u000b%%$W\rV8W[\n\u0013X-Y6q_&tGo\u001d\u0006\t)\"\u000b7\u000f['ba*\u0019qM\\;\u000b\u000bQ\u0014xN^3\u000b\u001fac\u0015N\\3Ce\u0016\f7\u000e]8j]RT1aY8n\u0015!Ig\u000e^3mY&T'\"\u0003=eK\n,xmZ3s\u0015-\u0011'/Z1la>Lg\u000e^:\u000b\u00175+H/\u00192mK2K7\u000f\u001e\u0006\u000b\u0005J,\u0017m\u001b9pS:$(\u0002\u00027pG.Taa\u00142kK\u000e$(\u0002\u00026bm\u0006TA\u0001\\1oO*A\"/\u001e8U_2{7-\u0019;j_:\u0014%/Z1la>Lg\u000e^:\u000b\u0011QC\u0015m\u001d5TKRT\u0011C^7U_&#WM\u0011:fC.\u0004x.\u001b8u\u0015!iU\u000f\u001c;j\u001b\u0006\u0004(\u0002B;uS2T!bY8oi\u0006Lg.\u001a:t\u0015Q9W\r\u001e,n)>LE-\u001a\"sK\u0006\\\u0007o\\5oi*9\"-\u001a4pe\u0016\u0014%/Z1la>Lg\u000e\u001e*f[>4X\r\u001a\u0006\u000bEJ,\u0017m\u001b9pS:$(b\u00023jg\u0006\u0014G.\u001a\u0006\b\u0005>|G.Z1o\u0015\u0011)f.\u001b;\u000b;\rdW-\u0019:Sk:$v\u000eT8dCRLwN\u001c\"sK\u0006\\\u0007o\\5oiNTAb\u0019:fCR,G+\u0019:hKRT\u0011C\u0019:fC.\u0004x.\u001b8u\u001b\u0006t\u0017mZ3s\u0015E\u0011%/Z1la>Lg\u000e^'b]\u0006<WM\u001d\u0006\tY>\u001c\u0017\r^5p]*AAj\\2bi&|gNC\u0006jgR+W\u000e]8sCJL(\u0002\u0005\"sK\u0006\\\u0007o\\5oiR\u000b'oZ3u\u0015I!wNU3n_Z,'I]3bWB|\u0017N\u001c;\u000b\u000fA\u0013x.\\5tK*Y1m\u001c8dkJ\u0014XM\\2z\u0015=!wNU;o)>dunY1uS>t'\u0002\u00039pg&$\u0018n\u001c8\u000b\u001fa\u001bv.\u001e:dKB{7/\u001b;j_:TA\u0001T5ti*yAm\\*fi\n\u0013X-Y6q_&tGO\u0003\rjg\u0006s\u0017PR5sgRd\u0015N\\3Ce\u0016\f7\u000e]8j]RT\u0001$[:Sk:$vnQ;sg>\u0014(I]3bWB|\u0017N\u001c;t\u0015Q\u0011X-\\8wK\u0006cGN\u0011:fC.\u0004x.\u001b8ug*\u0001\"/Z7pm\u0016\u0014%/Z1la>Lg\u000e\u001e\u0006\ni\u0016l\u0007o\u001c:befTQB];o)>dunY1uS>t'\"D:fi\n\u0013X-Y6q_&tGOC\u000ep]2L8k\\;sG\u0016l\u0015\r\u001d9fI\n\u0013X-Y6q_&tGo\u001d\u0006\nY>\u001c\u0017\r^5p]NTA#\u001e9eCR,\u0017\t\u001c7Ce\u0016\f7\u000e]8j]R\u001c\bZ\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0002\u0006\u0007\u0011\u0011\u0001B\u0001\u0007\u0001\u000b\r!\u0011\u0001\u0003\u0003\r\u0001\u0015\u0019A!\u0001\u0005\u0006\u0019\u0001)!\u0001B\u0001\t\t\u0015\u0011A!\u0001\u0005\u0006\u000b\u0005Ai!\u0002\u0002\u0005\u000b!9Qa\u0001C\u0006\u0011\u0019a\u0001!B\u0001\t\u0011\u0015\u0011AQ\u0002E\t\u000b\t!q\u0001C\u0005\u0006\u0005\u0011=\u00012C\u0003\u0004\t!Ay\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001B\u0003\u0007\u0001\u000b\r!\u0011\u0001#\u0006\r\u0001\u0015\u0011A1\u0002\u0005\u0007\u000b\u0005AA\"\u0002\u0002\u0005\u0016!eQa\u0001\u0003\f\u0011/a\u0001!\u0002\u0002\u0005\u0017!]Qa\u0001C\u0006\u00117a\u0001!\u0002\u0002\u0005\f!mQA\u0001\u0003\b\u0011=)!\u0001b\u0007\t \u0015\u0019AA\u0004E\u000f\u0019\u0001)!\u0001\u0002\b\t\u001e\u0015\u0019AA\u0001\u0005\u0013\u0019\u0001)1\u0001\u0002\u0002\t&1\u0001QA\u0001\u0003\t\u0011\u001f)1\u0001B\u0001\t*1\u0001Qa\u0001\u0003\u0002\u0011Wa\u0001!B\u0002\u0005\u0003!5B\u0002A\u0003\u0003\t\u0005Ai#\u0002\u0002\u0005\u0003!%RA\u0001\u0003\u0002\u0011W)!\u0001\"\u0001\t\u001f\u0015\u0011A\u0001\u0006\u0005\u0019\u000b\r!I\u0003c\f\r\u0001\u0015\u0011A\u0011\u0006E\u0018\u000b\r!y\u0001c\r\r\u0001\u0015\u0019AA\u0001\u0005\u001b\u0019\u0001)!\u0001\"\u0006\t\u001f\u0015\u0011Aa\u0006\u0005\u001b\u000b\t!y\u0001c\r\u0006\u0005\u0011\t\u0001R\u0003\u0003\u0014\u0019\u0007I\"!B\u0001\t\u00065jA!\u0019\u0003\u0019\n\u0005\"Q!\u0001E\u0004\u0013\u0005!\u0019!V\u0002\u0005\u000b\r!I!C\u0001\t\n5JB!\u0019\u0003\u0019\f\u0005\u0002R!\u0001\u0005\u0007\u0013\u0015IA!B\u0001\t\u0012%\tA1A\u0005\b\u0013\u0019)\u0011\u0001C\u0005\n\u0007%\u0011Q!\u0001E\n+\u000e!Qa\u0001C\u0006\u0013\u0005A!\"L\u0006\u0005C\u0012A2\"\t\u0002\u0006\u0003!]Qk\u0001\u0003\u0006\u0007\u0011Y\u0011\"\u0001\u0005\r[=!\u0011\r\u0002\r\u000eC\u0019)\u0011\u0001#\u0007\n\u0007%\u0011Q!\u0001E\n+\u000e!Qa\u0001\u0003\u000e\u0013\u0005AQ\"L\u0006\u0005C\u0012A:!\t\u0002\u0006\u0003!\u0019Qk\u0001\u0003\u0006\u0007\u0011\u001d\u0011\"\u0001\u0005\u0005[e!!\r\u0002\r\u000fC1)\u0011\u0001#\b\n\u0007%\u0011Q!\u0001E\n\u0013\u0015IA!B\u0001\t\u0012%\tA1A+\u0004\u0011\u0015\u0019AAD\u0005\u0002\u0011=i1\u0001\u0002\t\n\u0003!yQV\b\u0003\u000b1Ci\n\u0002\u0002\u0001\t#5!Q!\u0001E\t\u0013\u0005!\u0019\u0001U\u0002\u0001;\u001b!\u0001\u0001c\t\u000e\u0005\u0015\t\u0001r\u0004)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0011#\u000e9A\u0011E\u0005\u0002\t\u0001i\u0011\u0001#\t\u000e\u0003\u0011\u0005Q6\u0003\u0003\u00041M\t#!B\u0001\t!E\u001b1\u0001B\n\n\u0003\u0011\u0001QV\r\u0003\u00131Oi\u001a\u0002\u0002\u0001\t#5)Q!\u0001E\t\u0013\u0005!\u0019\u0001$\u0001Q\u0007\u0001ij\u0001\u0002\u0001\t)5\u0011Q!\u0001\u0005\u0012!\u000e\u0005QT\u0002\u0003\u0001\u0011Ui!!B\u0001\t$A\u001b\u0011!(\u0004\u0005\u0001!1RBA\u0003\u0002\u0011?\u000161A\u0011\u0003\u000b\u0005A!#U\u0002\f\tOI\u0011\u0001#\n\u000e\u0003!\u0005R\"\u0001\u0005\u0014\u001b\u0005A9#D\u0001\u0005\u00025\u0006Ca\u0001\r\u0018;#!\u0001\u0001C\t\u000e\t\u0015\t\u0001\u0012C\u0005\u0002\t\u0007\u00016\u0001AO\u0007\t\u0001A\u0019#\u0004\u0002\u0006\u0003!}\u0001k!\u0001\"\t\u0015\t\u0001\"F\u0005\u0002\t\u0007\t6a\u0002\u0003\u0018\u0013\u0005AY#D\u0001\t\"5\tA\u0011A\u0017\u0018\tIA\n$(\u0004\u0005\u0001!IRBA\u0003\u0002\u0011Y\u00016\u0001A\u0011\u0007\u000b\u0005Ai#C\u0002\n\u0005\u0015\t\u00012C)\u0004\u000b\u0011E\u0012\"\u0001E\u0018\u001b\u0005A\u0001$L\u0015\u0005\u0005aUR4\u0003\u0003\u0001\u0011EiQ!B\u0001\t\u0012%\tA1\u0001G\u0001!\u000e\u0001QT\u0002\u0003\u0001\u0011Ui!!B\u0001\t$A\u001b\t!(\u0004\u0005\u0001!1RBA\u0003\u0002\u0011?\u00016!A\u0011\u0003\u000b\u0005A\u0019\"U\u0002\n\tkI\u0011\u0001#\r\u000e\u0003!\u0005R\"\u0001E\u0014\u001b\u0005!\t!L\n\u0005\u0017aYRT\u0002\u0003\u0001\u0011Ei!!B\u0001\t\u0014A\u001b\u0001!\t\u0002\u0006\u0003!}\u0011kA\u0003\u00057%\tA\u0011A\u0007\u0002\u0011cis\u0003B\u0002\u00198uUA\u0001\u0001E\n\u001b\u0019)\u0011\u0001#\f\n\u0007%\u0011Q!\u0001E\n!\u000e\u0001\u0011EA\u0003\u0002\u0011?\t6!\u0002C\u001c\u0013\u0005!\t!D\u0001\t05^Aa\u0001\r\u001dC\u0011)\u0011\u0001C\u000b\n\u0003\u0011\r\u0011kA\u0002\u00059%\t\u00012FW!\t\rAJ$(\u0005\u0005\u0001!\tR\u0002B\u0003\u0002\u0011#I\u0011\u0001b\u0001Q\u0007\u0001ij\u0001\u0002\u0001\t;5\u0011Q!\u0001E\u0010!\u000e\u0005\u0011\u0005B\u0003\u0002\u0011UI\u0011\u0001b\u0001R\u0007\u001d!I$C\u0001\t,5\t\u0001\u0012E\u0007\u0002\t\u0003i3\u0003B\u0002\u0019<u5A\u0001\u0001\u0005\u001a\u001b\t)\u0011\u0001\u0003\fQ\u0007\u0001\t#!B\u0001\t!E\u001bQ\u0001b\u000f\n\u0003\u0011\u0001Q\"\u0001\u0005\u0019[{!1\u0001\u0007\u0010\u001e\u0012\u0011\u0001\u0001\"E\u0007\u0005\u000b\u0005A\t\"C\u0001\u0005\u0004A\u001b\u0001!(\u0004\u0005\u0001!uRBA\u0003\u0002\u0011?\u00016\u0011A\u0011\u0003\u000b\u0005A\u0001#U\u0002\b\tyI\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\"\u0001C\u0001[\u000b\"1\u0001\u0007\u0010\u001e\u0012\u0011\u0001\u0001\"E\u0007\u0005\u000b\u0005A\t\"C\u0001\u0005\u0004A\u001b\u0001!(\u0006\u0005\u0001!yRBB\u0003\u0002\u0011[I1!\u0003\u0002\u0006\u0003!\r\u0002k!\u0001\"\u0005\u0015\t\u0001\u0002E)\u0004\u000f\u0011q\u0012\"\u0001\u0003\u0001\u001b\u0005A\t#D\u0001\t05NAa\u0001M C\t)\u0011\u0001\u0003\tR\u0007\r!y$C\u0001\u0005\u0001U\u0002Sa\b\u0003d\u0002a\u0019QT\u0002\u0003\u0001\u0011\u000fi!!B\u0001\t\u0007A\u001b\u0001!(\u0005\u0005\u0001!%Q\u0002B\u0003\u0002\u0011\u000fI\u0011\u0001b\u0001Q\u0007\u0003\t#!B\u0001\t\u0004E\u001bq\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0005\u001b\u0005AI\u0001"})
public abstract class LineBreakpointManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private final THashMap<XLineBreakpoint<?>, List<Breakpoint>> ideToVmBreakpoints;
    @NotNull
    private final MultiMap<Breakpoint, XLineBreakpoint<?>> vmToIdeBreakpoint;
    private final THashSet<Breakpoint> runToLocationBreakpoints;
    private final Object lock;
    private final Vm vm;
    private final DebugProcessImpl<?> debugProcess;

    static {
        $kotlinClass = Reflection.createKotlinClass(LineBreakpointManager.class);
    }

    @NotNull
    protected final MultiMap<Breakpoint, XLineBreakpoint<?>> getVmToIdeBreakpoint() {
        return this.vmToIdeBreakpoint;
    }

    public boolean isAnyFirstLineBreakpoint(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="onlySourceMappedBreakpoints") boolean onlySourceMappedBreakpoints) {
        List list;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Object object = this.lock;
        synchronized (lock) {
            List list2 = (List)this.ideToVmBreakpoints.get(breakpoint);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : lock
            list = list2;
        }
        List target = list;
        if (target == null) {
            this.setBreakpoint(breakpoint, this.debugProcess.getLocationsForBreakpoint(breakpoint, onlySourceMappedBreakpoints));
        } else {
            BreakpointManager breakpointManager = this.vm.getBreakpointManager();
            for (Breakpoint vmBreakpoint : target) {
                if (vmBreakpoint.getEnabled()) continue;
                vmBreakpoint.setEnabled(true);
                breakpointManager.flush(vmBreakpoint).rejected((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, breakpoint){
                    final /* synthetic */ LineBreakpointManager this$0;
                    final /* synthetic */ XLineBreakpoint $breakpoint;

                    public final void invoke(@JetValueParameter(name="it") @NotNull Throwable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        LineBreakpointManager.access$getDebugProcess$3(this.this$0).getSession().updateBreakpointPresentation(this.$breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, it.getMessage());
                    }
                    {
                        this.this$0 = lineBreakpointManager;
                        this.$breakpoint = xLineBreakpoint;
                        super(1);
                    }
                }));
            }
        }
    }

    @NotNull
    public final Promise<?> removeBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="temporary") boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        boolean disable = temporary && this.vm.getBreakpointManager().getMuteMode() != BreakpointManager.MUTE_MODE.NONE;
        this.beforeBreakpointRemoved(breakpoint, disable);
        return this.doRemoveBreakpoint(breakpoint, disable);
    }

    protected void beforeBreakpointRemoved(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="disable") boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<?> doRemoveBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="disable") boolean disable) {
        void vmBreakpoints;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = KotlinPackage.emptySet();
        Object object = this.lock;
        synchronized (lock) {
            Object vmBreakpoint3;
            if (disable) {
                List list = (List)this.ideToVmBreakpoints.get(breakpoint);
                if (list == null) {
                    Promise<?> promise = ConcurrencyPackage.ResolvedPromise();
                    return promise;
                }
                List list2 = list;
                Iterator iterator = list2.iterator();
                vmBreakpoints.element = list2;
                while (iterator.hasNext()) {
                    Breakpoint vmBreakpoint2 = (Breakpoint)iterator.next();
                    if (this.getVmToIdeBreakpoint().get((Object)vmBreakpoint2).size() <= 1) continue;
                    iterator.remove();
                }
            } else {
                List list = (List)this.ideToVmBreakpoints.remove(breakpoint);
                if (list == null) {
                    Promise<?> promise = ConcurrencyPackage.ResolvedPromise();
                    return promise;
                }
                vmBreakpoints.element = list;
                if (!((List)((Collection)vmBreakpoints.element)).isEmpty()) {
                    for (Object vmBreakpoint3 : (Collection)vmBreakpoints.element) {
                        this.getVmToIdeBreakpoint().remove(vmBreakpoint3, breakpoint);
                        if (!this.getVmToIdeBreakpoint().containsKey(vmBreakpoint3)) continue;
                        Promise<?> promise = ConcurrencyPackage.ResolvedPromise();
                        return promise;
                    }
                }
            }
            vmBreakpoint3 = Unit.INSTANCE$;
        }
        if (((Collection)vmBreakpoints.element).isEmpty()) {
            return ConcurrencyPackage.ResolvedPromise();
        }
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        SmartList promises = new SmartList();
        if (disable) {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                vmBreakpoint.setEnabled(false);
                promises.add(breakpointManager.flush(vmBreakpoint));
            }
        } else {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                promises.add(breakpointManager.remove(vmBreakpoint));
            }
        }
        return Promise.Companion.all((Collection)promises);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@JetValueParameter(name="breakpoint") @NotNull XLineBreakpoint<?> breakpoint, @JetValueParameter(name="locations") @NotNull List<? extends Location> locations) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        if (locations.isEmpty()) {
            return;
        }
        SmartList vmBreakpoints = new SmartList();
        for (Location location : locations) {
            vmBreakpoints.add((Object)this.doSetBreakpoint(breakpoint, location, false));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ideToVmBreakpoints.put(breakpoint, (Object)vmBreakpoints);
            for (Breakpoint vmBreakpoint : vmBreakpoints) {
                this.getVmToIdeBreakpoint().putValue((Object)vmBreakpoint, breakpoint);
            }
            Iterator iterator = Unit.INSTANCE$;
        }
    }

    @NotNull
    protected final Breakpoint doSetBreakpoint(@JetValueParameter(name="breakpoint", type="?") @Nullable XLineBreakpoint<?> breakpoint, @JetValueParameter(name="location") @NotNull Location location, @JetValueParameter(name="isTemporary") boolean isTemporary) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        BreakpointTarget target = this.createTarget(breakpoint, breakpointManager, location, isTemporary);
        XLineBreakpoint<?> xLineBreakpoint = breakpoint;
        XExpression condition = xLineBreakpoint != null ? xLineBreakpoint.getConditionExpression() : null;
        XExpression xExpression = condition;
        return breakpointManager.setBreakpoint(target, location.getLine(), location.getColumn(), xExpression != null ? xExpression.getExpression() : null, Breakpoint.Companion.getEMPTY_VALUE(), true);
    }

    @NotNull
    protected abstract BreakpointTarget createTarget(@JetValueParameter(name="breakpoint", type="?") @Nullable XLineBreakpoint<?> var1, @JetValueParameter(name="breakpointManager") @NotNull BreakpointManager var2, @JetValueParameter(name="location") @NotNull Location var3, @JetValueParameter(name="isTemporary") boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runToLocation(@JetValueParameter(name="position") @NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Breakpoint> addedBreakpoints = this.doRunToLocation(position);
        if (addedBreakpoints.isEmpty()) {
            return;
        }
        Object lock = this.lock;
        synchronized (lock) {
            Boolean bl = this.runToLocationBreakpoints.addAll((Collection)addedBreakpoints);
        }
        this.debugProcess.resume();
    }

    @NotNull
    protected abstract List<Breakpoint> doRunToLocation(@JetValueParameter(name="position") @NotNull XSourcePosition var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunToCursorBreakpoints(@JetValueParameter(name="breakpoints") @NotNull List<? extends Breakpoint> breakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoints, (String)"breakpoints");
        THashSet<Breakpoint> lock = this.runToLocationBreakpoints;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.containsAll((Collection)breakpoints);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAllBreakpoints() {
        XLineBreakpoint[] xLineBreakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            Collection $receiver = this.ideToVmBreakpoints.keySet();
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("kotlin.Collection<T> cannot be cast to java.util.Collection<T>");
            }
            Collection thisCollection = collection;
            XLineBreakpoint[] xLineBreakpointArray2 = thisCollection.toArray(new XLineBreakpoint[thisCollection.size()]);
            if (xLineBreakpointArray2 == null) {
                throw new TypeCastException("kotlin.Array<(out) T?>! cannot be cast to kotlin.Array<T>");
            }
            XLineBreakpoint[] xLineBreakpointArray3 = (XLineBreakpoint[])((Object[])xLineBreakpointArray2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : lock
            xLineBreakpointArray = xLineBreakpointArray3;
        }
        XLineBreakpoint[] array = xLineBreakpointArray;
        for (int i = 0; i < array.length; ++i) {
            XLineBreakpoint breakpoint;
            XLineBreakpoint xLineBreakpoint = breakpoint = array[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
            this.removeBreakpoint(xLineBreakpoint, false);
            XLineBreakpoint xLineBreakpoint2 = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint2, (String)"breakpoint");
            this.setBreakpoint(xLineBreakpoint2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<?> removeAllBreakpoints() {
        Object lock = this.lock;
        synchronized (lock) {
            this.ideToVmBreakpoints.clear();
            this.getVmToIdeBreakpoint().clear();
            this.runToLocationBreakpoints.clear();
            Unit unit = Unit.INSTANCE$;
        }
        return this.vm.getBreakpointManager().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRunToLocationBreakpoints() {
        Breakpoint[] breakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            if (this.runToLocationBreakpoints.isEmpty()) {
                return;
            }
            Breakpoint[] breakpoints = (Breakpoint[])this.runToLocationBreakpoints.toArray((Object[])new Breakpoint[this.runToLocationBreakpoints.size()]);
            this.runToLocationBreakpoints.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : lock
            breakpointArray = breakpoints;
        }
        Breakpoint[] breakpoints = breakpointArray;
        BreakpointManager breakpointManager = this.vm.getBreakpointManager();
        for (int i = 0; i < breakpoints.length; ++i) {
            Breakpoint breakpoint;
            Breakpoint breakpoint2 = breakpoint = breakpoints[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpoint");
            breakpointManager.remove(breakpoint2);
        }
    }

    public LineBreakpointManager(@JetValueParameter(name="vm") @NotNull Vm vm, @JetValueParameter(name="debugProcess") @NotNull DebugProcessImpl<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.vm = vm;
        this.debugProcess = debugProcess;
        this.ideToVmBreakpoints = new THashMap();
        MultiMap multiMap = MultiMap.createSmart();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createSmart()");
        this.vmToIdeBreakpoint = multiMap;
        this.runToLocationBreakpoints = new THashSet();
        this.lock = new Object();
        this.vm.getBreakpointManager().addBreakpointListener(new BreakpointManager.BreakpointListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolved(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint) {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                Object lock = lock;
                synchronized (lock) {
                    Collection collection2 = this.getVmToIdeBreakpoint().get((Object)breakpoint);
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : lock
                    collection = collection2;
                }
                Collection breakpoints = collection;
                for (XLineBreakpoint ideBreakpoint : breakpoints) {
                    debugProcess.getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, (String)null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void errorOccurred(@JetValueParameter(name="breakpoint") @NotNull Breakpoint breakpoint, @JetValueParameter(name="errorMessage", type="?") @Nullable String errorMessage) {
                Collection collection;
                void lock;
                Boolean bl;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                if (this.isAnyFirstLineBreakpoint(breakpoint)) {
                    return;
                }
                Object lock2 = lock;
                synchronized (lock2) {
                    object = runToLocationBreakpoints.remove((Object)breakpoint);
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : lock
                    bl = object;
                }
                if (bl.booleanValue()) {
                    XDebugSession xDebugSession = debugProcess.getSession();
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot run to cursor: ");
                    String string = errorMessage;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    xDebugSession.reportError(stringBuilder.append(string).toString());
                    return;
                }
                object = lock;
                synchronized (lock) {
                    Collection collection2 = this.getVmToIdeBreakpoint().get((Object)breakpoint);
                    // MONITOREXIT @DISABLED, blocks:[1, 3] lbl30 : MonitorExitStatement: MONITOREXIT : lock
                    collection = collection2;
                }
                Collection breakpoints = collection;
                for (XLineBreakpoint ideBreakpoint : breakpoints) {
                    debugProcess.getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
                }
            }
        });
    }
}

