/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Variable;

public abstract class MemberFilterBase
implements MemberFilter {
    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/MemberFilterBase", "isMemberVisible"));
        }
        return variable.isReadable();
    }

    @Override
    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        List<Variable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/MemberFilterBase", "getAdditionalVariables"));
        }
        return list;
    }

    @Override
    public boolean hasNameMappings() {
        return false;
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/MemberFilterBase", "rawNameToSource"));
        }
        String string = variable.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/MemberFilterBase", "rawNameToSource"));
        }
        return string;
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/MemberFilterBase", "sourceNameToRaw"));
        }
        return null;
    }
}

