/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Locale;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiConstants;
import org.jetbrains.io.fastCgi.FastCgiPackage$FastCgiService$9abcc68c;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"s\b)qa)Y:u\u0007\u001eL'+Z9vKN$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0003S>TqAZ1ti\u000e;\u0017NC\u0002B]fTaa[8uY&t'B\u0002\u001fj]&$hHC\u0005sKF,Xm\u001d;JI*\u0019\u0011J\u001c;\u000b\u0013\u0005dGn\\2bi>\u0014(\u0002\u0005\"zi\u0016\u0014UOZ!mY>\u001c\u0017\r^8s\u0015\u0015qW\r\u001e;z\u0015\u0019\u0011WO\u001a4fe*9!)\u001f;f\u0005V4'\u0002D4fiJ+\u0017/^3ti&#'\"C1eI\"+\u0017\rZ3s\u0015\rYW-\u001f\u0006\u0007'R\u0014\u0018N\\4\u000b\u000bY\fG.^3\u000b\u0019\rC\u0017M]*fcV,gnY3\u000b\tUs\u0017\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002E<sSR,g)\u001b7f\u0011\u0016\fG-\u001a:t\u0015\u00111\u0017\u000e\\3\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*\u0019aOZ:\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(\u0002F2b]>t\u0017nY1m%\u0016\fX/Z:u!\u0006$\bNC\u0006xe&$X\rS3bI\u0016\u0014(\u0002\u0002;za\u0016Ta\u0001\\3oORD'\u0002D<sSR,\u0007*Z1eKJ\u001c(b\u0002:fcV,7\u000f\u001e\u0006\u0010\rVdG\u000e\u0013;uaJ+\u0017/^3ti*9\u0001.\u00198eY\u0016\u0014(\"B2pI\u0016\u001c'\u0002\u00025uiBTQb\u00197jK:$8\t[1o]\u0016d'bB\"iC:tW\r\u001c\u0006\bG\"\fgN\\3m\u0015Q9(/\u001b;f)>\u001cVM\u001d<fe\u000eC\u0017M\u001c8fY*91m\u001c8uK:$(B\u00044bgR\u001cu-[\"iC:tW\r\u001c\u0006\n\u0007>l\u0007/\u00198j_:D A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A1!B\u0002\u0005\u0006!\u0015A\u0002A\u0003\u0004\t\u000bAI\u0001\u0004\u0001\u0006\u0003!\rQA\u0001\u0003\u0005\u0011\u0019)!\u0001\"\u0003\t\u000e\u0015\u0019A!\u0002E\u0006\u0019\u0001)!\u0001B\u0003\t\f\u0015\u0019A!\u0002\u0005\b\u0019\u0001)!\u0001B\u0003\t\u000f\u0015\u0019AQ\u0001\u0005\n\u0019\u0001)1\u0001\"\u0002\t\u00151\u0001Qa\u0001C\u0003\u0011+a\u0001!B\u0001\t\u0017\u0015\u0011A!\u0003E\f\u000b\t!\u0019\u0002C\u0005\u0006\u0005\u0011M\u0001BC\u0003\u0002\u00117)!\u0001B\u0006\t\u001d\u0015\u0011Aq\u0003E\u000f\u000b\t!A\u0002C\b\u0006\u0007\u0011e\u0001\"\u0004\u0007\u0001\u000b\t!A\u0002c\b\u0006\u0007\u0011m\u0001\u0002\u0005\u0007\u0001\u000b\t!I\u0002C\u0007\u0006\u0005\u0011m\u0001\u0002E\u0003\u0003\t\u0013AA#\u0002\u0002\u0005 !%RA\u0001\u0003\u0011\u0011U)1\u0001\"\t\t(1\u0001QA\u0001C\u0005\u0011[)1\u0001b\t\t-1\u0001QA\u0001C\u0011\u0011O)!\u0001b\t\t-\u0011\u0001AB\u0001I\u00193\t)\u0011\u0001C\u0002\u001d25bA!1\u0007\u0019\u000e\u0005\u001aQ!\u0001E\u0007\u0019\u0003)6\u0001B\u0003\u0004\t\u001bI\u0011\u0001C\u0004.\u001f\u0011\u0001G\u0001\u0007\u0003\"\u0005\u0015\t\u0001rA+\u0004\u0011\u0015\u0019A\u0001B\u0005\u0002\t\u000bi1\u0001b\u0004\n\u0003\u0011\u0015Q6\b\u0003\u00041!ij\u0001\u0002\u0001\t\u00125\u0011Q!\u0001E\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011'i1!B\u0001\t\u00111\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001\u0012C)\u0004\u000f\u0011A\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"D\u0001\t\u001652Ca\u0001\r\r;\u001b!\u0001\u0001#\u0007\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001u5A\u0001\u0001E\u0010\u001b\t)\u0011\u0001\u0003\bQ\u0007\u0003ij\u0001\u0002\u0001\t\"5\u0011Q!\u0001\u0005\t!\u000e\t\u0011EA\u0003\u0002\u0011#\t6!\u0003\u0003\r\u0013\u0005!\u0001!D\u0001\t\u001e5\t\u0001bD\u0007\u0002\u0011+ic\u0005B\u0001\u0019#u5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001#\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t$5\u0011Q!\u0001E\u0004!\u000e\u0005QT\u0002\u0003\u0001\u0011Ii!!B\u0001\t\bA\u001b\u0011!\t\u0002\u0006\u0003!E\u0011kA\u0005\u0005#%\tA\u0001A\u0007\u0002\u0011\u001di\u0011\u0001\"\u0002\u000e\u0003\u0011\u0015Q\u0016\b\u0003\u00041Kij\u0001\u0002\u0001\t'5\u0011Q!\u0001\u0005\u0012!\u000e\u0001QT\u0002\u0003\u0001\u0011Wi!!B\u0001\t%A\u001b\t!\t\u0002\u0006\u0003!E\u0011kA\u0004\u0005&%\tA\u0001A\u0007\u0002\u0011Ki\u0011\u0001C\n.<\u0011\u0001\u0001dFO\b\t\u0001Ay#D\u0002\u0006\u0003!5A\u0012\u0001)\u0004\u0001u5A\u0001\u0001\u0005\u0019\u001b\t)\u0011\u0001\u0003\nQ\u0007\u0003\t#!B\u0001\t\u0012E\u001bq\u0001B\f\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005A1#\u000e\u0010\u0006;\u0011\u0019\u000f\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005A9\u0001U\u0002\u0001;\u001b!\u0001\u0001C\u0003\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0003#\u000e9AqA\u0005\u0002\t\u0001i\u0011\u0001\"\u0002\u000e\u0003!1\u0001"})
public final class FastCgiRequest {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final int PARAMS = 4;
    private static final int BEGIN_REQUEST = 1;
    private static final int RESPONDER = 1;
    private static final int FCGI_KEEP_CONNECTION = 1;
    private static final int STDIN = 5;
    private static final int VERSION = 1;
    private ByteBuf buffer;
    private final int requestId;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(FastCgiRequest.class);
        OBJECT$ = Companion = org.jetbrains.io.fastCgi.FastCgiRequest$Companion.access$init$6();
        PARAMS = 4;
        BEGIN_REQUEST = 1;
        RESPONDER = 1;
        FCGI_KEEP_CONNECTION = 1;
        STDIN = 5;
        VERSION = 1;
    }

    public final void writeFileHeaders(@JetValueParameter(name="file") @NotNull VirtualFile file, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="canonicalRequestPath") @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        PathInfo root = WebServerPathToFileManager.getInstance(project).getRoot(file);
        FastCgiPackage$FastCgiService$9abcc68c.getLOG().assertTrue(root != null);
        PathInfo pathInfo = root;
        if (pathInfo == null) {
            Intrinsics.throwNpe();
        }
        this.addHeader("DOCUMENT_ROOT", pathInfo.getRoot().getPath());
        this.addHeader("SCRIPT_FILENAME", file.getPath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    public final void addHeader(@JetValueParameter(name="key") @NotNull String key, @JetValueParameter(name="value", type="?") @Nullable CharSequence value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (value == null) {
            return;
        }
        int keyLength = key.length();
        int valLength = value.length();
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequest.Companion.getPARAMS(), keyLength + valLength + (keyLength < 128 ? 1 : 4) + (valLength < 128 ? 1 : 4));
        if (keyLength < 128) {
            ByteBuf byteBuf2 = this.buffer;
            if (byteBuf2 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf2.writeByte(keyLength);
        } else {
            ByteBuf byteBuf3 = this.buffer;
            if (byteBuf3 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf3.writeByte(0x80 | keyLength >> 24);
            ByteBuf byteBuf4 = this.buffer;
            if (byteBuf4 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf4.writeByte(keyLength >> 16);
            ByteBuf byteBuf5 = this.buffer;
            if (byteBuf5 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf5.writeByte(keyLength >> 8);
            ByteBuf byteBuf6 = this.buffer;
            if (byteBuf6 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf6.writeByte(keyLength);
        }
        if (valLength < 128) {
            ByteBuf byteBuf7 = this.buffer;
            if (byteBuf7 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf7.writeByte(valLength);
        } else {
            ByteBuf byteBuf8 = this.buffer;
            if (byteBuf8 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf8.writeByte(0x80 | valLength >> 24);
            ByteBuf byteBuf9 = this.buffer;
            if (byteBuf9 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf9.writeByte(valLength >> 16);
            ByteBuf byteBuf10 = this.buffer;
            if (byteBuf10 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf10.writeByte(valLength >> 8);
            ByteBuf byteBuf11 = this.buffer;
            if (byteBuf11 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf11.writeByte(valLength);
        }
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)key);
        ByteBufUtilEx.writeUtf8(this.buffer, value);
    }

    public final void writeHeaders(@JetValueParameter(name="request") @NotNull FullHttpRequest request, @JetValueParameter(name="clientChannel") @NotNull Channel clientChannel) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("java.net.SocketAddress! cannot be cast to java.net.InetSocketAddress");
        }
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("java.net.SocketAddress! cannot be cast to java.net.InetSocketAddress");
        }
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("CONTENT_TYPE", request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = KotlinPackage.indexOf$default((String)request.uri(), (char)'?', (int)0, (boolean)false, (int)6);
        if (queryIndex != -1) {
            queryString = KotlinPackage.substring((String)request.uri(), (int)(queryIndex + 1));
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        for (Map.Entry entry : request.headers()) {
            StringBuilder stringBuilder = new StringBuilder().append("HTTP_");
            String string = KotlinPackage.replace$default((String)((String)entry.getKey()), (char)'-', (char)'_', (boolean)false, (int)4);
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            this.addHeader(stringBuilder.append(KotlinPackage.toUpperCase((String)string, (Locale)locale)).toString(), (CharSequence)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@JetValueParameter(name="content", type="?") @Nullable ByteBuf content, @JetValueParameter(name="fastCgiChannel") @NotNull Channel fastCgiChannel) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)fastCgiChannel, (String)"fastCgiChannel");
            if (fastCgiChannel.pipeline().first() == null) {
                throw (Throwable)new IllegalStateException("No handler in the pipeline");
            }
            boolean releaseContent = content != null;
            try {
                ByteBuf byteBuf = this.buffer;
                if (byteBuf == null) {
                    Intrinsics.throwNpe();
                }
                this.writeHeader(byteBuf, FastCgiRequest.Companion.getPARAMS(), 0);
                if (content != null) {
                    ByteBuf byteBuf2 = this.buffer;
                    if (byteBuf2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.writeHeader(byteBuf2, FastCgiRequest.Companion.getSTDIN(), content.readableBytes());
                }
                fastCgiChannel.write((Object)this.buffer);
                this.buffer = null;
                if (content != null) {
                    ByteBuf headerBuffer;
                    fastCgiChannel.write((Object)content);
                    releaseContent = false;
                    ByteBuf byteBuf3 = headerBuffer = fastCgiChannel.alloc().ioBuffer(FastCgiConstants.HEADER_LENGTH, FastCgiConstants.HEADER_LENGTH);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf3, (String)"headerBuffer");
                    this.writeHeader(byteBuf3, FastCgiRequest.Companion.getSTDIN(), 0);
                    fastCgiChannel.write((Object)headerBuffer);
                }
                if (!releaseContent) break block10;
                KotlinPackage.assert$default((content != null ? 1 : 0) != 0, null, (int)2);
            }
            catch (Throwable throwable) {
                if (releaseContent) {
                    KotlinPackage.assert$default((content != null ? 1 : 0) != 0, null, (int)2);
                    ByteBuf byteBuf = content;
                    if (byteBuf == null) {
                        Intrinsics.throwNpe();
                    }
                    byteBuf.release();
                }
                throw throwable;
            }
            ByteBuf byteBuf = content;
            if (byteBuf == null) {
                Intrinsics.throwNpe();
            }
            byteBuf.release();
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(@JetValueParameter(name="buffer") ByteBuf buffer, @JetValueParameter(name="type") int type, @JetValueParameter(name="length") int length) {
        buffer.writeByte(FastCgiRequest.Companion.getVERSION());
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public FastCgiRequest(@JetValueParameter(name="requestId") int requestId, @JetValueParameter(name="allocator") @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkParameterIsNotNull((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        ByteBuf byteBuf = this.buffer = allocator.ioBuffer(4096);
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequest.Companion.getBEGIN_REQUEST(), FastCgiConstants.HEADER_LENGTH);
        ByteBuf byteBuf2 = this.buffer;
        if (byteBuf2 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf2.writeShort(FastCgiRequest.Companion.getRESPONDER());
        ByteBuf byteBuf3 = this.buffer;
        if (byteBuf3 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf3.writeByte(FastCgiRequest.Companion.getFCGI_KEEP_CONNECTION());
        ByteBuf byteBuf4 = this.buffer;
        if (byteBuf4 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf4.writeZero(5);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"m\u0004)I1i\\7qC:LwN\u001c\u0006\u000f\r\u0006\u001cHoQ4j%\u0016\fX/Z:u\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT!![8\u000b\u000f\u0019\f7\u000f^\"hS*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u00155\u0011UiR%O?J+\u0015+V#T)*\u0019\u0011J\u001c;\u000b!\u001d,GOQ#H\u0013:{&+R)V\u000bN#&\u0002\u0006$D\u000f&{6*R#Q?\u000e{eJT#D)&{eJC\fhKR45iR%`\u0017\u0016+\u0005kX\"P\u001d:+5\tV%P\u001d*1\u0001+\u0011*B\u001bNS\u0011bZ3u!\u0006\u0013\u0016)T*\u000b\u0013I+5\u000bU(O\t\u0016\u0013&\u0002D4fiJ+5\u000bU(O\t\u0016\u0013&\"B*U\t&s%\u0002C4fiN#F)\u0013(\u000b\u000fY+%kU%P\u001d*Qq-\u001a;W\u000bJ\u001b\u0016j\u0014(;\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\b\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)1\u0001B\u0002\t\n1\u0001Aaq\u0001\r\u0006e\u0011Q!\u0001E\u0004[A!\u0011\r\u0006\r\u0005C\t)\u0011\u0001\u0003\u0003V\u0007%)A\u0001\u0002\u0003\n\u0003\u0011\u0015A\u0012A\u0007\u0004\t\u0015I\u0011\u0001\"\u0002.!\u0011\tG\u0003g\u0003\"\u0005\u0015\t\u0001\u0002B+\u0004\u0013\u0015!A1B\u0005\u0002\t\u000ba\t!D\u0002\u0005\r%\tAQA\u0017\u0011\t\u0005$\u0002TB\u0011\u0003\u000b\u0005AA!V\u0002\n\u000b\u0011!i!C\u0001\u0005\u00061\u0005Qb\u0001\u0003\b\u0013\u0005!)!\f\t\u0005CRAz!\t\u0002\u0006\u0003!!QkA\u0005\u0006\t\u0011=\u0011\"\u0001C\u0003\u0019\u0003i1\u0001\u0002\u0005\n\u0003\u0011\u0015Q\u0006\u0005\u0003b)aE\u0011EA\u0003\u0002\u0011\u0011)6!C\u0003\u0005\t#I\u0011\u0001\"\u0002\r\u00025\u0019A!C\u0005\u0002\t\u000bi\u0003\u0003B1\u00151'\t#!B\u0001\t\tU\u001b\u0011\"\u0002\u0003\u0005\u0014%\tAQ\u0001G\u0001\u001b\r!!\"C\u0001\u0005\u0006U\u0002\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final int getPARAMS() {
            return PARAMS;
        }

        private final int getBEGIN_REQUEST() {
            return BEGIN_REQUEST;
        }

        private final int getRESPONDER() {
            return RESPONDER;
        }

        private final int getFCGI_KEEP_CONNECTION() {
            return FCGI_KEEP_CONNECTION;
        }

        private final int getSTDIN() {
            return STDIN;
        }

        private final int getVERSION() {
            return VERSION;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$6() {
            return new Companion();
        }
    }
}

