/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.GfxController;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.StateTreeNode;
import com.android.tools.idea.editors.gfxtrace.renderers.StateTreeRenderer;
import com.android.tools.idea.editors.gfxtrace.rpc.ArrayInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.Binary;
import com.android.tools.idea.editors.gfxtrace.rpc.BinaryId;
import com.android.tools.idea.editors.gfxtrace.rpc.CaptureId;
import com.android.tools.idea.editors.gfxtrace.rpc.Client;
import com.android.tools.idea.editors.gfxtrace.rpc.EnumEntry;
import com.android.tools.idea.editors.gfxtrace.rpc.StructInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.TypeKind;
import com.android.tools.idea.editors.gfxtrace.schema.Array;
import com.android.tools.idea.editors.gfxtrace.schema.Class;
import com.android.tools.idea.editors.gfxtrace.schema.EnumValue;
import com.android.tools.idea.editors.gfxtrace.schema.Field;
import com.android.tools.idea.editors.gfxtrace.schema.Map;
import com.android.tools.idea.editors.gfxtrace.schema.MapEntry;
import com.android.tools.idea.editors.gfxtrace.schema.Struct;
import com.android.tools.idea.editors.gfxtrace.schema.Unpack;
import com.android.tools.rpclib.binary.Decoder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateController
implements GfxController {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StateController.class);
    @NotNull
    private final GfxTraceEditor myEditor;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final SimpleTree myTree;
    @NotNull
    private AtomicLong myAtomicAtomId;
    @Nullable
    private StructInfo myStateHierarchy;

    public StateController(@NotNull GfxTraceEditor editor, @NotNull JBScrollPane scrollPane) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "<init>"));
        }
        if (scrollPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollPane", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "<init>"));
        }
        this.myAtomicAtomId = new AtomicLong(-1L);
        this.myEditor = editor;
        this.myTree = new SimpleTree();
        this.myTree.setRowHeight(19);
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new StateTreeRenderer()));
        this.myTree.getEmptyText().setText("Select a capture");
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)editor.getProject());
        this.myLoadingPanel.add((Component)this.myTree);
        scrollPane.setViewportView((Component)this.myLoadingPanel);
    }

    @Nullable
    private static DefaultMutableTreeNode constructStateNode(@NotNull String name, @NotNull TypeKind typeKind, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "constructStateNode"));
        }
        if (typeKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeKind", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "constructStateNode"));
        }
        StateTreeNode thisNode = null;
        switch (typeKind) {
            case Bool: 
            case S8: 
            case U8: 
            case S16: 
            case U16: 
            case S32: 
            case U32: 
            case S64: 
            case U64: 
            case F32: 
            case F64: 
            case String: 
            case Pointer: {
                thisNode = new StateTreeNode(name, value);
                break;
            }
            case Enum: {
                assert (value instanceof EnumValue);
                EnumValue enumValue = (EnumValue)value;
                for (EnumEntry entry : enumValue.info.getEntries()) {
                    if (enumValue.value != (long)entry.getValue()) continue;
                    thisNode = new StateTreeNode(name, entry.getName());
                    break;
                }
                if (thisNode != null) break;
                LOG.warn("Invalid bitfield value passed in: " + enumValue.value);
                break;
            }
            case Array: {
                assert (value instanceof Array);
                Array array = (Array)value;
                thisNode = new StateTreeNode(name, null);
                ArrayInfo arrayInfo = array.info;
                Object[] elements = array.elements;
                int i = 0;
                for (Object element : elements) {
                    DefaultMutableTreeNode childNode;
                    if ((childNode = StateController.constructStateNode(Integer.toString(i++), arrayInfo.getElementType().getKind(), element)) == null) continue;
                    thisNode.add(childNode);
                }
                break;
            }
            case Struct: {
                assert (value instanceof Struct);
                Struct struct = (Struct)value;
                thisNode = new StateTreeNode(name, null);
                for (Field field : struct.fields) {
                    DefaultMutableTreeNode childNode = StateController.constructStateNode(field.info.getName(), field.info.getType().getKind(), field.value);
                    if (childNode == null) continue;
                    thisNode.add(childNode);
                }
                break;
            }
            case Class: {
                assert (value instanceof Class);
                Class gfxClass = (Class)value;
                thisNode = new StateTreeNode(name, null);
                for (Field field : gfxClass.fields) {
                    DefaultMutableTreeNode childNode = StateController.constructStateNode(field.info.getName(), field.info.getType().getKind(), field.value);
                    if (childNode == null) continue;
                    thisNode.add(childNode);
                }
                break;
            }
            case Map: {
                assert (value instanceof Map);
                Map map = (Map)value;
                thisNode = new StateTreeNode(name, null);
                for (MapEntry mapEntry : map.elements) {
                    DefaultMutableTreeNode childNode = StateController.constructStateNode(mapEntry.key.toString(), map.info.getValueType().getKind(), mapEntry.value);
                    if (childNode == null) continue;
                    thisNode.add(childNode);
                }
                break;
            }
            case Memory: {
                thisNode = null;
                break;
            }
            case Any: {
                thisNode = null;
                break;
            }
            default: {
                throw new RuntimeException("Attempting to decode unsupported types.");
            }
        }
        return thisNode;
    }

    @Override
    public void startLoad() {
        this.myTree.getEmptyText().setText("");
    }

    @Override
    public void commitData(@NotNull GfxController.GfxContextChangeState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "commitData"));
        }
        this.myStateHierarchy = state.myCaptureChangeState.mySchema.getState();
        this.myTree.getEmptyText().setText("Select an atom");
    }

    public void updateTreeModelFromAtomId(final long atomId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myEditor.getCaptureId() != null);
        assert (this.myEditor.getContext() != null);
        assert (this.myStateHierarchy != null);
        final Client client = this.myEditor.getClient();
        final StructInfo stateHierarchy = this.myStateHierarchy;
        final CaptureId captureId = this.myEditor.getCaptureId();
        final int contextId = this.myEditor.getContext();
        this.myAtomicAtomId.set(atomId);
        if (!this.myLoadingPanel.isLoading()) {
            this.myTree.getEmptyText().setText("");
            this.myLoadingPanel.startLoading();
        }
        ListenableFuture nodeFuture = this.myEditor.getService().submit((Callable)new Callable<TreeNode>(){

            @Override
            @Nullable
            public TreeNode call() throws Exception {
                BinaryId binaryId = client.GetState(captureId, contextId, atomId).get();
                Binary stateBinary = client.ResolveBinary(binaryId).get();
                Struct stateStruct = (Struct)Unpack.Type(stateHierarchy, new Decoder((InputStream)new ByteArrayInputStream(stateBinary.getData())));
                return StateController.constructStateNode(stateStruct.info.getName(), TypeKind.Struct, stateStruct);
            }
        });
        Futures.addCallback((ListenableFuture)nodeFuture, (FutureCallback)new FutureCallback<TreeNode>(){

            public void onSuccess(@Nullable TreeNode result) {
                if (StateController.this.myAtomicAtomId.get() != atomId) {
                    return;
                }
                StateController.this.myTree.setModel((TreeModel)new DefaultTreeModel(result));
                StateController.this.myTree.updateUI();
                StateController.this.myLoadingPanel.stopLoading();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/editors/gfxtrace/controllers/StateController$2", "onFailure"));
                }
                StateController.this.myLoadingPanel.stopLoading();
                LOG.error(t);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    @Override
    public void clear() {
        this.myStateHierarchy = null;
        this.clearCache();
    }

    @Override
    public void clearCache() {
        this.myAtomicAtomId.set(-1L);
        this.myTree.setModel(null);
        this.myTree.updateUI();
    }
}

