/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;

public class SyncProjectAction
extends AnAction {
    public SyncProjectAction() {
        super("Sync Project with Gradle Files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            BuildVariantView.getInstance(project).projectImportStarted();
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            try {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
            finally {
                presentation.setEnabled(true);
            }
        }
    }

    public void update(AnActionEvent e) {
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = false;
        Project project = e.getProject();
        if (project != null) {
            enabled = !GradleSyncState.getInstance(project).isSyncInProgress();
        }
        e.getPresentation().setEnabled(enabled);
    }
}

