/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.AbstractCompileOutputModuleCustomizer;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerOutputModuleCustomizer
extends AbstractCompileOutputModuleCustomizer<IdeaAndroidProject>
implements BuildVariantModuleCustomizer<IdeaAndroidProject> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull ModifiableRootModel ideaModuleModel, @Nullable IdeaAndroidProject androidProject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/android/CompilerOutputModuleCustomizer", "customizeModule"));
        }
        if (ideaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModuleModel", "com/android/tools/idea/gradle/customizer/android/CompilerOutputModuleCustomizer", "customizeModule"));
        }
        if (androidProject == null) {
            return;
        }
        String modelVersion = androidProject.getDelegate().getModelVersion();
        if (StringUtil.isEmpty((String)modelVersion)) {
            return;
        }
        Variant selectedVariant = androidProject.getSelectedVariant();
        File mainClassesFolder = selectedVariant.getMainArtifact().getClassesFolder();
        BaseArtifact testArtifact = androidProject.findSelectedTestArtifact(selectedVariant);
        File testClassesFolder = testArtifact == null ? null : testArtifact.getClassesFolder();
        this.setOutputPaths(ideaModuleModel, mainClassesFolder, testClassesFolder);
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/CompilerOutputModuleCustomizer", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public Class<IdeaAndroidProject> getSupportedModelType() {
        if (IdeaAndroidProject.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/CompilerOutputModuleCustomizer", "getSupportedModelType"));
        }
        return IdeaAndroidProject.class;
    }
}

