/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.DomPsiParser;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.android.inspections.lint.LombokPsiParser;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijLintClient
extends LintClient
implements Disposable {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.IntellijLintClient");
    @NonNull
    protected com.intellij.openapi.project.Project myProject;
    @Nullable
    protected Map<Project, Module> myModuleMap;
    @Nullable
    private static volatile String ourSystemPath;

    protected IntellijLintClient(@NonNull com.intellij.openapi.project.Project project) {
        this.myProject = project;
    }

    public static IntellijLintClient forBatch(@NotNull com.intellij.openapi.project.Project project, @NotNull Map<Issue, Map<File, List<ProblemData>>> problemMap, @NotNull AnalysisScope scope, @NotNull List<Issue> issues) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/IntellijLintClient", "forBatch"));
        }
        if (problemMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemMap", "org/jetbrains/android/inspections/lint/IntellijLintClient", "forBatch"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/lint/IntellijLintClient", "forBatch"));
        }
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "org/jetbrains/android/inspections/lint/IntellijLintClient", "forBatch"));
        }
        return new BatchLintClient(project, problemMap, scope, issues);
    }

    @Nullable
    public static ApiLookup getApiLookup(@NotNull com.intellij.openapi.project.Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/IntellijLintClient", "getApiLookup"));
        }
        return ApiLookup.get((LintClient)new IntellijLintClient(project));
    }

    public static IntellijLintClient forEditor(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/android/inspections/lint/IntellijLintClient", "forEditor"));
        }
        return new EditorLintClient(state);
    }

    @Nullable
    protected Module findModuleForLintProject(@NotNull com.intellij.openapi.project.Project project, @NotNull Project lintProject) {
        Module module;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/IntellijLintClient", "findModuleForLintProject"));
        }
        if (lintProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lintProject", "org/jetbrains/android/inspections/lint/IntellijLintClient", "findModuleForLintProject"));
        }
        if (this.myModuleMap != null && (module = this.myModuleMap.get(lintProject)) != null) {
            return module;
        }
        File dir = lintProject.getDir();
        VirtualFile vDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
        return vDir != null ? ModuleUtilCore.findModuleForFile((VirtualFile)vDir, (com.intellij.openapi.project.Project)project) : null;
    }

    void setModuleMap(@Nullable Map<Project, Module> moduleMap) {
        this.myModuleMap = moduleMap;
    }

    public Configuration getConfiguration(@NonNull Project project) {
        AndroidProject model;
        if (project.isGradleProject() && project.isAndroidProject() && !project.isLibrary() && (model = project.getGradleProjectModel()) != null) {
            try {
                LintOptions lintOptions = model.getLintOptions();
                final Map overrides = lintOptions.getSeverityOverrides();
                if (overrides != null && !overrides.isEmpty()) {
                    return new DefaultConfiguration(this, project, null){

                        @NonNull
                        public Severity getSeverity(@NonNull Issue issue) {
                            Integer severity = (Integer)overrides.get(issue.getId());
                            if (severity != null) {
                                switch (severity) {
                                    case 1: {
                                        return Severity.FATAL;
                                    }
                                    case 2: {
                                        return Severity.ERROR;
                                    }
                                    case 3: {
                                        return Severity.WARNING;
                                    }
                                    case 4: {
                                        return Severity.INFORMATIONAL;
                                    }
                                }
                                return Severity.IGNORE;
                            }
                            if (!IntellijLintClient.this.getIssues().contains(issue)) {
                                return Severity.IGNORE;
                            }
                            return super.getSeverity(issue);
                        }
                    };
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return new DefaultConfiguration(this, project, null){

            public boolean isEnabled(@NonNull Issue issue) {
                return IntellijLintClient.this.getIssues().contains(issue) && super.isEnabled(issue);
            }
        };
    }

    public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @Nullable Location location, @NonNull String message, @NonNull TextFormat format) {
        assert (false) : message;
    }

    @NonNull
    protected List<Issue> getIssues() {
        return Collections.emptyList();
    }

    @Nullable
    protected Module getModule() {
        return null;
    }

    protected void reportSecondary(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @NonNull Location location, @NonNull String message, @NonNull TextFormat format) {
        Location secondary = location.getSecondary();
        if (secondary != null) {
            if (secondary.getMessage() != null) {
                message = message + " (" + secondary.getMessage() + ")";
            }
            this.report(context, issue, severity, secondary, message, format);
        }
    }

    public void log(@NonNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            if (format != null) {
                LOG.error(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.error(exception);
            }
        } else if (severity == Severity.WARNING) {
            if (format != null) {
                LOG.warn(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.warn(exception);
            }
        } else if (format != null) {
            LOG.info(String.format(format, args), exception);
        } else if (exception != null) {
            LOG.info(exception);
        }
    }

    public XmlParser getXmlParser() {
        return new DomPsiParser(this);
    }

    @Nullable
    public JavaParser getJavaParser(@Nullable Project project) {
        return new LombokPsiParser(this);
    }

    @NonNull
    public List<File> getJavaClassFolders(@NonNull Project project) {
        return Collections.emptyList();
    }

    @NonNull
    public List<File> getJavaLibraries(@NonNull Project project) {
        return Collections.emptyList();
    }

    @NonNull
    public String readFile(final @NonNull File file) {
        final VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return "";
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)IntellijLintClient.this.myProject).findFile(vFile);
                if (psiFile == null) {
                    LOG.info("Cannot find file " + file.getPath() + " in the PSI");
                    return null;
                }
                return psiFile.getText();
            }
        });
    }

    public void dispose() {
    }

    @Nullable
    public File getSdkHome() {
        File home;
        String path;
        Sdk moduleSdk;
        Module module = this.getModule();
        if (module != null && (moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && (path = moduleSdk.getHomePath()) != null && (home = new File(path)).exists()) {
            return home;
        }
        File sdkHome = super.getSdkHome();
        if (sdkHome != null) {
            return sdkHome;
        }
        for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
            File home2;
            String path2;
            Sdk moduleSdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
            if (moduleSdk2 == null || !(moduleSdk2.getSdkType() instanceof AndroidSdkType) || (path2 = moduleSdk2.getHomePath()) == null || !(home2 = new File(path2)).exists()) continue;
            return home2;
        }
        return IdeSdks.getAndroidSdkPath();
    }

    @Nullable
    public LocalSdk getSdk() {
        if (this.mSdk == null) {
            Module module = this.getModule();
            LocalSdk sdk = IntellijLintClient.getLocalSdk(module);
            if (sdk != null) {
                this.mSdk = sdk;
            } else {
                for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
                    sdk = IntellijLintClient.getLocalSdk(m);
                    if (sdk == null) continue;
                    this.mSdk = sdk;
                    break;
                }
                if (this.mSdk == null) {
                    this.mSdk = super.getSdk();
                }
            }
        }
        return this.mSdk;
    }

    @Nullable
    private static LocalSdk getLocalSdk(@Nullable Module module) {
        AndroidSdkData sdkData;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (sdkData = facet.getSdkData()) != null) {
            return sdkData.getLocalSdk();
        }
        return null;
    }

    public boolean isGradleProject(Project project) {
        Module module = this.getModule();
        if (module != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.isGradleProject();
        }
        return Projects.isGradleProject(this.myProject);
    }

    @Nullable
    public File findResource(@NonNull String relativePath) {
        File file;
        File top = this.getSdkHome();
        if (top != null && (file = new File(top, relativePath)).exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public File getCacheDir(boolean create) {
        String path = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath((String)PathManager.getSystemPath()));
        File lint = new File(path, "lint");
        if (create && !lint.exists()) {
            lint.mkdirs();
        }
        return lint;
    }

    public boolean isProjectDirectory(@NonNull File dir) {
        return new File(dir, ".idea").exists();
    }

    public boolean checkForSuppressComments() {
        return false;
    }

    public boolean supportsProjectResources() {
        return true;
    }

    @Nullable
    public AbstractResourceRepository getProjectResources(Project project, boolean includeDependencies) {
        AndroidFacet facet;
        Module module = this.findModuleForLintProject(this.myProject, project);
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            return includeDependencies ? facet.getProjectResources(true) : facet.getModuleResources(true);
        }
        return null;
    }

    @Nullable
    public URLConnection openConnection(@NonNull URL url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url.toExternalForm());
    }

    @NonNull
    public Location.Handle createResourceItemHandle(@NonNull ResourceItem item) {
        XmlTag tag = LocalResourceRepository.getItemTag(this.myProject, item);
        if (tag != null) {
            ResourceFile source = (ResourceFile)item.getSource();
            assert (source != null) : item;
            return new LocationHandle(source.getFile(), (XmlElement)tag);
        }
        return super.createResourceItemHandle(item);
    }

    @NonNull
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        ResourceVisibilityLookup.Provider provider;
        AppResourceRepository appResources;
        Module module = this.getModule();
        if (module != null && (appResources = AppResourceRepository.getAppResources(module, true)) != null && (provider = appResources.getResourceVisibilityProvider()) != null) {
            return provider;
        }
        return super.getResourceVisibilityProvider();
    }

    private static class LocationHandle
    implements Location.Handle,
    Computable<Location> {
        private final File myFile;
        private final XmlElement myNode;
        private Object myClientData;

        public LocationHandle(File file, XmlElement node) {
            this.myFile = file;
            this.myNode = node;
        }

        @NonNull
        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)this);
            }
            TextRange textRange = this.myNode.getTextRange();
            if (this.myNode instanceof XmlTag) {
                String tag = ((XmlTag)this.myNode).getName();
                int index = this.myNode.getText().indexOf(tag);
                if (index != -1) {
                    int start = textRange.getStartOffset() + index;
                    textRange = new TextRange(start, start + tag.length());
                }
            }
            DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start, (Position)end);
        }

        public Location compute() {
            return this.resolve();
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }

    private static class BatchLintClient
    extends IntellijLintClient {
        private final Map<Issue, Map<File, List<ProblemData>>> myProblemMap;
        private final AnalysisScope myScope;
        private final List<Issue> myIssues;

        public BatchLintClient(@NotNull com.intellij.openapi.project.Project project, @NotNull Map<Issue, Map<File, List<ProblemData>>> problemMap, @NotNull AnalysisScope scope, @NotNull List<Issue> issues) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/IntellijLintClient$BatchLintClient", "<init>"));
            }
            if (problemMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemMap", "org/jetbrains/android/inspections/lint/IntellijLintClient$BatchLintClient", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/lint/IntellijLintClient$BatchLintClient", "<init>"));
            }
            if (issues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "org/jetbrains/android/inspections/lint/IntellijLintClient$BatchLintClient", "<init>"));
            }
            super(project);
            this.myProblemMap = problemMap;
            this.myScope = scope;
            this.myIssues = issues;
        }

        @Override
        @Nullable
        protected Module getModule() {
            return null;
        }

        @Override
        @NonNull
        protected List<Issue> getIssues() {
            return this.myIssues;
        }

        @Override
        public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @Nullable Location location, @NonNull String message, @NonNull TextFormat format) {
            boolean inScope;
            Module module;
            VirtualFile vFile = null;
            File file = null;
            if (location != null) {
                file = location.getFile();
                vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            } else if (context.getProject() != null && (module = this.findModuleForLintProject(this.myProject, context.getProject())) != null) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                VirtualFile virtualFile = vFile = facet != null ? AndroidRootUtil.getPrimaryManifestFile(facet) : null;
                if (vFile != null) {
                    file = new File(vFile.getPath());
                }
            }
            boolean bl = inScope = vFile != null && this.myScope.contains(vFile);
            if (!inScope && vFile != null && vFile.isDirectory()) {
                Module module2;
                if (this.myScope.getScopeType() == 1) {
                    inScope = true;
                } else if ((this.myScope.getScopeType() == 4 || this.myScope.getScopeType() == 7) && (module2 = this.findModuleForLintProject(this.myProject, context.getProject())) != null && this.myScope.containsModule(module2)) {
                    inScope = true;
                }
            }
            if (inScope) {
                List<ProblemData> problemList;
                file = new File(PathUtil.getCanonicalPath((String)file.getPath()));
                HashMap file2ProblemList = this.myProblemMap.get(issue);
                if (file2ProblemList == null) {
                    file2ProblemList = new HashMap();
                    this.myProblemMap.put(issue, (Map<File, List<ProblemData>>)file2ProblemList);
                }
                if ((problemList = file2ProblemList.get(file)) == null) {
                    problemList = new ArrayList<ProblemData>();
                    file2ProblemList.put(file, problemList);
                }
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (location != null) {
                    Position start = location.getStart();
                    Position end = location.getEnd();
                    if (start != null && end != null && start.getOffset() <= end.getOffset()) {
                        textRange = new TextRange(start.getOffset(), end.getOffset());
                    }
                }
                Severity configuredSeverity = severity != issue.getDefaultSeverity() ? severity : null;
                message = format.convertTo(message, TextFormat.RAW);
                problemList.add(new ProblemData(issue, message, textRange, configuredSeverity));
                if (location != null && location.getSecondary() != null) {
                    this.reportSecondary(context, issue, severity, location, message, format);
                }
            }
        }

        @NonNull
        public List<File> getJavaSourceFolders(@NonNull Project project) {
            Module module = this.findModuleForLintProject(this.myProject, project);
            if (module == null) {
                return Collections.emptyList();
            }
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            ArrayList<File> result = new ArrayList<File>(sourceRoots.length);
            for (VirtualFile root : sourceRoots) {
                result.add(new File(root.getPath()));
            }
            return result;
        }

        @NonNull
        public List<File> getResourceFolders(@NonNull Project project) {
            AndroidFacet facet;
            Module module = this.findModuleForLintProject(this.myProject, project);
            if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
                return IntellijLintUtils.getResourceDirectories(facet);
            }
            return super.getResourceFolders(project);
        }
    }

    private static class EditorLintClient
    extends IntellijLintClient {
        private final State myState;

        public EditorLintClient(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/android/inspections/lint/IntellijLintClient$EditorLintClient", "<init>"));
            }
            super(state.getModule().getProject());
            this.myState = state;
        }

        @Override
        @Nullable
        protected Module getModule() {
            return this.myState.getModule();
        }

        @Override
        @NonNull
        protected List<Issue> getIssues() {
            return this.myState.getIssues();
        }

        @Override
        public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @Nullable Location location, @NonNull String message, @NonNull TextFormat format) {
            if (location != null) {
                Location secondary;
                File file = location.getFile();
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (this.myState.getMainFile().equals(vFile)) {
                    Position start = location.getStart();
                    Position end = location.getEnd();
                    TextRange textRange = start != null && end != null && start.getOffset() <= end.getOffset() ? new TextRange(start.getOffset(), end.getOffset()) : TextRange.EMPTY_RANGE;
                    Severity configuredSeverity = severity != issue.getDefaultSeverity() ? severity : null;
                    message = format.convertTo(message, TextFormat.RAW);
                    this.myState.getProblems().add(new ProblemData(issue, message, textRange, configuredSeverity));
                }
                if ((secondary = location.getSecondary()) != null && this.myState.getMainFile().equals(LocalFileSystem.getInstance().findFileByIoFile(secondary.getFile()))) {
                    this.reportSecondary(context, issue, severity, location, message, format);
                }
            }
        }

        @Override
        @NotNull
        public String readFile(@NonNull File file) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) {
                LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/IntellijLintClient$EditorLintClient", "readFile"));
                }
                return "";
            }
            String content = this.getFileContent(vFile);
            if (content == null) {
                LOG.info("Cannot find file " + file.getPath() + " in the PSI");
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/IntellijLintClient$EditorLintClient", "readFile"));
                }
                return "";
            }
            String string = content;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/IntellijLintClient$EditorLintClient", "readFile"));
            }
            return string;
        }

        @Nullable
        private String getFileContent(final VirtualFile vFile) {
            if (Comparing.equal((Object)this.myState.getMainFile(), (Object)vFile)) {
                return this.myState.getMainFileContent();
            }
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    Module module = EditorLintClient.this.myState.getModule();
                    com.intellij.openapi.project.Project project = module.getProject();
                    PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)project).findFile(vFile);
                    if (psiFile == null) {
                        return null;
                    }
                    Document document = PsiDocumentManager.getInstance((com.intellij.openapi.project.Project)project).getDocument(psiFile);
                    if (document != null) {
                        DocumentListener listener = new DocumentListener(){

                            public void beforeDocumentChange(DocumentEvent event) {
                            }

                            public void documentChanged(DocumentEvent event) {
                                EditorLintClient.this.myState.markDirty();
                            }
                        };
                        document.addDocumentListener(listener, (Disposable)EditorLintClient.this);
                    }
                    return psiFile.getText();
                }
            });
        }

        @NonNull
        public List<File> getJavaSourceFolders(@NonNull Project project) {
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myState.getModule()).getSourceRoots(false);
            ArrayList<File> result = new ArrayList<File>(sourceRoots.length);
            for (VirtualFile root : sourceRoots) {
                result.add(new File(root.getPath()));
            }
            return result;
        }

        @NonNull
        public List<File> getResourceFolders(@NonNull Project project) {
            AndroidFacet facet = AndroidFacet.getInstance(this.myState.getModule());
            if (facet != null) {
                return IntellijLintUtils.getResourceDirectories(facet);
            }
            return super.getResourceFolders(project);
        }
    }
}

