/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private boolean myIsProcessing = false;

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.forEach(processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AbstractQuery", "findAll"));
        }
        return collection;
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator<Result>(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach(processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEach(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/AbstractQuery", "forEach"));
        }
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    protected abstract boolean processResults(@NotNull Processor<Result> var1);
}

