/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.suppress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantsPackage$ConstantUtils$b9e2c0da;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$ConstantExpressionEvaluator$2483f20e;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$ConstantExpressionEvaluator$2483f20e$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatorContext;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class EvaluatePackage$ConstantExpressionEvaluator$2483f20e {
    @NotNull
    static final CompileTimeType<Byte> BYTE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Short> SHORT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Integer> INT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Long> LONG = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Double> DOUBLE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Float> FLOAT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Character> CHAR = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Boolean> BOOLEAN = new CompileTimeType();
    @NotNull
    static final CompileTimeType<String> STRING = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Object> ANY = new CompileTimeType();

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstantWithType(@JetValueParameter(name="$receiver") IntegerValueTypeConstant $receiver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return EvaluatePackage$ConstantExpressionEvaluator$2483f20e.createCompileTimeConstant$default($receiver.getValue(expectedType), new EvaluatorContext($receiver.canBeUsedInAnnotations(), true, false, 4, null), null, 4);
    }

    public static final boolean hasLongSuffix(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return KotlinPackage.endsWith$default(text, 'l', false, 2) || KotlinPackage.endsWith$default(text, 'L', false, 2);
    }

    @Nullable
    public static final Long parseLong(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            Function1<String, String> substringLongSuffix$ = new Function1<String, String>(text){
                final /* synthetic */ String $text;

                @NotNull
                public final String invoke(@JetValueParameter(name="s") @NotNull String s) {
                    Intrinsics.checkParameterIsNotNull(s, "s");
                    return EvaluatePackage$ConstantExpressionEvaluator$2483f20e.hasLongSuffix(this.$text) ? KotlinPackage.substring(s, 0, s.length() - 1) : s;
                }
                {
                    this.$text = string;
                    super(1);
                }
            };
            Function2<String, Integer, Long> parseLong$ = new Function2<String, Integer, Long>(substringLongSuffix$){
                final /* synthetic */ parseLong.1 $substringLongSuffix;

                public final long invoke(@JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="radix") int radix) {
                    Intrinsics.checkParameterIsNotNull(text, "text");
                    return Long.parseLong(this.$substringLongSuffix.invoke(text), radix);
                }
                {
                    this.$substringLongSuffix = var1_1;
                    super(2);
                }
            };
            return KotlinPackage.startsWith$default(text, "0x", false, 2) || KotlinPackage.startsWith$default(text, "0X", false, 2) ? parseLong$.invoke(KotlinPackage.substring(text, 2), 16) : (KotlinPackage.startsWith$default(text, "0b", false, 2) || KotlinPackage.startsWith$default(text, "0B", false, 2) ? parseLong$.invoke(KotlinPackage.substring(text, 2), 2) : parseLong$.invoke(text, 10));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Object parseFloatingLiteral(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        if (KotlinPackage.endsWith$default(KotlinPackage.toLowerCase(text), 'f', false, 2)) {
            return EvaluatePackage$ConstantExpressionEvaluator$2483f20e.parseFloat(text);
        }
        return EvaluatePackage$ConstantExpressionEvaluator$2483f20e.parseDouble(text);
    }

    @Nullable
    public static final Double parseDouble(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Float parseFloat(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean parseBoolean(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstantForEquals(@JetValueParameter(name="result", type="?") @Nullable Object result2, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference, @JetValueParameter(name="c") @NotNull EvaluatorContext c) {
        Intrinsics.checkParameterIsNotNull(operationReference, "operationReference");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (result2 instanceof Boolean) {
            BooleanValue booleanValue;
            KotlinPackage.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for equals operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression cannot be cast to org.jetbrains.kotlin.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.EQEQ)) {
                booleanValue = new BooleanValue((Boolean)result2, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual(iElementType, JetTokens.EXCLEQ)) {
                booleanValue = new BooleanValue((Boolean)result2 == false, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else {
                if (Intrinsics.areEqual(iElementType, JetTokens.IDENTIFIER)) {
                    KotlinPackage.assert(Intrinsics.areEqual(((JetSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorConventions.EQUALS), "This method should be called only for equals operations");
                    return new BooleanValue((Boolean)result2, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                }
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + " " + ((JetSimpleNameExpression)operationReference).getText());
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstantForCompareTo(@JetValueParameter(name="result", type="?") @Nullable Object result2, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference, @JetValueParameter(name="c") @NotNull EvaluatorContext c) {
        Intrinsics.checkParameterIsNotNull(operationReference, "operationReference");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (result2 instanceof Integer) {
            BooleanValue booleanValue;
            KotlinPackage.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for compareTo operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression cannot be cast to org.jetbrains.kotlin.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.LT)) {
                booleanValue = new BooleanValue(((Number)result2).intValue() < 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual(iElementType, JetTokens.LTEQ)) {
                booleanValue = new BooleanValue(((Number)result2).intValue() <= 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual(iElementType, JetTokens.GT)) {
                booleanValue = new BooleanValue(((Number)result2).intValue() > 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual(iElementType, JetTokens.GTEQ)) {
                booleanValue = new BooleanValue(((Number)result2).intValue() >= 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else {
                if (Intrinsics.areEqual(iElementType, JetTokens.IDENTIFIER)) {
                    KotlinPackage.assert(Intrinsics.areEqual(((JetSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorConventions.COMPARE_TO), "This method should be called only for compareTo operations");
                    return new IntValue(((Number)result2).intValue(), c.getCanBeUsedInAnnotation(), c.getIsPure(), c.getUsesVariableAsConstant());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final StringValue createStringConstant(@JetValueParameter(name="value", type="?") @Nullable CompileTimeConstant<?> value) {
        CompileTimeConstant<?> compileTimeConstant = value;
        return compileTimeConstant instanceof IntegerValueTypeConstant ? new StringValue(((IntegerValueTypeConstant)value).getValue(TypeUtils.NO_EXPECTED_TYPE).toString(), ((IntegerValueTypeConstant)value).canBeUsedInAnnotations(), ((IntegerValueTypeConstant)value).usesVariableAsConstant()) : (compileTimeConstant instanceof StringValue ? (StringValue)value : (compileTimeConstant instanceof IntValue || compileTimeConstant instanceof ByteValue || compileTimeConstant instanceof ShortValue || compileTimeConstant instanceof LongValue || compileTimeConstant instanceof CharValue || compileTimeConstant instanceof DoubleValue || compileTimeConstant instanceof FloatValue || compileTimeConstant instanceof BooleanValue || compileTimeConstant instanceof NullValue ? new StringValue(String.valueOf(value.getValue()), value.canBeUsedInAnnotations(), value.usesVariableAsConstant()) : (StringValue)null));
    }

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="c") @NotNull EvaluatorContext c, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        return ConstantsPackage$ConstantUtils$b9e2c0da.createCompileTimeConstant(value, c.getCanBeUsedInAnnotation(), c.getIsPure(), c.getUsesVariableAsConstant(), expectedType);
    }

    @Nullable
    public static /* synthetic */ CompileTimeConstant createCompileTimeConstant$default(Object object, EvaluatorContext evaluatorContext, JetType jetType, int n) {
        if ((n & 4) != 0) {
            jetType = null;
        }
        return EvaluatePackage$ConstantExpressionEvaluator$2483f20e.createCompileTimeConstant(object, evaluatorContext, jetType);
    }

    public static final boolean isIntegerType(@JetValueParameter(name="value", type="?") @Nullable Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final JetType getReceiverExpressionType(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<?> resolvedCall) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        ExplicitReceiverKind explicitReceiverKind = resolvedCall.getExplicitReceiverKind();
        if (explicitReceiverKind != null) {
            switch (EvaluatePackage$ConstantExpressionEvaluator$2483f20e$WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()]) {
                case 1: {
                    jetType = resolvedCall.getDispatchReceiver().getType();
                    return jetType;
                }
                case 2: {
                    jetType = resolvedCall.getExtensionReceiver().getType();
                    return jetType;
                }
                case 3: {
                    jetType = null;
                    return jetType;
                }
                case 4: {
                    jetType = null;
                    return jetType;
                }
            }
        }
        jetType = null;
        return jetType;
    }

    @Nullable
    public static final CompileTimeType<? extends Object> getCompileTimeType(@JetValueParameter(name="c") @NotNull JetType c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType jetType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(jetType, builtIns.getIntType()) ? INT : (Intrinsics.areEqual(jetType, builtIns.getByteType()) ? BYTE : (Intrinsics.areEqual(jetType, builtIns.getShortType()) ? SHORT : (Intrinsics.areEqual(jetType, builtIns.getLongType()) ? LONG : (Intrinsics.areEqual(jetType, builtIns.getDoubleType()) ? DOUBLE : (Intrinsics.areEqual(jetType, builtIns.getFloatType()) ? FLOAT : (Intrinsics.areEqual(jetType, builtIns.getCharType()) ? CHAR : (Intrinsics.areEqual(jetType, builtIns.getBooleanType()) ? BOOLEAN : (Intrinsics.areEqual(jetType, builtIns.getStringType()) ? STRING : (Intrinsics.areEqual(jetType, builtIns.getAnyType()) ? ANY : (CompileTimeType)null)))))))));
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> binaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="b") @NotNull CompileTimeType<B> b, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function2<? super A, ? super B, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return KotlinPackage.to(new BinaryOperationKey<A, B>(a, b, functionName), new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker));
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> unaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function1<? super A, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function1<? super Long, ? extends Long> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return KotlinPackage.to(new UnaryOperationKey<A>(a, functionName), new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>>(operation, checker));
    }
}

