/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.doc;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.doc.GroovyDocBundle;
import org.jetbrains.plugins.groovy.doc.GroovyDocConfiguration;
import org.jetbrains.plugins.groovy.doc.actions.GroovyDocAddPackageAction;
import org.jetbrains.plugins.groovy.doc.actions.GroovyDocReducePackageAction;

public final class GroovyDocGenerationPanel
extends JPanel {
    JPanel myPanel;
    TextFieldWithBrowseButton myOutputDir;
    NonFocusableCheckBox myIsUse;
    NonFocusableCheckBox myIsPrivate;
    NonFocusableCheckBox myOpenInBrowserCheckBox;
    TextFieldWithBrowseButton myInputDir;
    private JTextField myWindowTitle;
    JList myPackagesList;
    private JPanel myPackagesPanel;
    private DefaultActionGroup myActionGroup;
    private GroovyDocAddPackageAction myAddPackageAction;
    private GroovyDocReducePackageAction myReducePackageAction;
    private final DefaultListModel myDataModel;

    GroovyDocGenerationPanel() {
        this.$$$setupUI$$$();
        this.myInputDir.addBrowseFolderListener(GroovyDocBundle.message("groovydoc.generate.directory.browse", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myOutputDir.addBrowseFolderListener(GroovyDocBundle.message("groovydoc.generate.directory.browse", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myDataModel = new DefaultListModel();
        this.myPackagesList = new JBList((ListModel)this.myDataModel);
        this.myPackagesList.setMinimumSize((Dimension)JBUI.size((int)100, (int)150));
        JScrollPane packagesScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myPackagesList);
        this.myPackagesPanel.setLayout(new BorderLayout());
        this.myPackagesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Source packages", (boolean)false));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("GroovyDoc", this.getActionGroup(), true);
        this.myPackagesPanel.add((Component)actionToolbar.getComponent(), "North");
        this.myPackagesPanel.add((Component)packagesScrollPane, "South");
        actionToolbar.updateActionsImmediately();
        this.myPanel.setMinimumSize((Dimension)JBUI.size((int)275, (int)350));
    }

    private ActionGroup getActionGroup() {
        if (this.myActionGroup == null) {
            this.initActions();
            this.myActionGroup = new DefaultActionGroup();
            this.myActionGroup.add((AnAction)this.myAddPackageAction);
            this.myActionGroup.add((AnAction)this.myReducePackageAction);
        }
        return this.myActionGroup;
    }

    private void initActions() {
        this.myAddPackageAction = new GroovyDocAddPackageAction(this.myDataModel);
        this.myReducePackageAction = new GroovyDocReducePackageAction(this.myPackagesList, this.myDataModel);
    }

    public void setPackagesList(String packagesName) {
        this.myDataModel.removeAllElements();
        this.myDataModel.add(0, packagesName);
    }

    public DefaultListModel getDataModel() {
        return this.myDataModel;
    }

    public void apply(GroovyDocConfiguration configuration) {
        configuration.OUTPUT_DIRECTORY = GroovyDocGenerationPanel.toSystemIndependentFormat(this.myOutputDir.getText());
        configuration.INPUT_DIRECTORY = GroovyDocGenerationPanel.toSystemIndependentFormat(this.myInputDir.getText());
        configuration.PACKAGES = GroovyDocGenerationPanel.toStringArray(this.getDataModel());
        configuration.OPEN_IN_BROWSER = this.myOpenInBrowserCheckBox.isSelected();
        configuration.OPTION_IS_USE = this.myIsUse.isSelected();
        configuration.OPTION_IS_PRIVATE = this.myIsPrivate.isSelected();
        configuration.WINDOW_TITLE = this.myWindowTitle.getText();
    }

    public void reset(GroovyDocConfiguration configuration) {
        this.myOutputDir.setText(GroovyDocGenerationPanel.toUserSystemFormat(configuration.OUTPUT_DIRECTORY));
        this.myInputDir.setText(GroovyDocGenerationPanel.toUserSystemFormat(configuration.INPUT_DIRECTORY));
        this.setPackagesList(configuration.PACKAGES[0]);
        this.myOpenInBrowserCheckBox.setSelected(configuration.OPEN_IN_BROWSER);
        this.myIsUse.setSelected(configuration.OPTION_IS_USE);
        this.myIsPrivate.setSelected(configuration.OPTION_IS_PRIVATE);
    }

    @Nullable
    private static String toSystemIndependentFormat(String directory) {
        if (directory.isEmpty()) {
            return null;
        }
        return directory.replace(File.separatorChar, '/');
    }

    private static String toUserSystemFormat(String directory) {
        if (directory == null) {
            return "";
        }
        return directory.replace('/', File.separatorChar);
    }

    private static String[] toStringArray(DefaultListModel model) {
        int count = model.getSize();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            Object o = model.getElementAt(i);
            assert (o instanceof String);
            result.add((String)o);
        }
        return ArrayUtil.toStringArray(result);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        NonFocusableCheckBox nonFocusableCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        NonFocusableCheckBox nonFocusableCheckBox2;
        NonFocusableCheckBox nonFocusableCheckBox3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(10, 5, 0, 5), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myIsPrivate = nonFocusableCheckBox3 = new NonFocusableCheckBox();
        nonFocusableCheckBox3.setText("Private");
        nonFocusableCheckBox3.setMnemonic('P');
        nonFocusableCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)nonFocusableCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIsUse = nonFocusableCheckBox2 = new NonFocusableCheckBox();
        nonFocusableCheckBox2.setSelected(true);
        nonFocusableCheckBox2.setText("Use");
        nonFocusableCheckBox2.setMnemonic('U');
        nonFocusableCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)nonFocusableCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Output directory:");
        jLabel.setDisplayedMnemonic('O');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputDir = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myOpenInBrowserCheckBox = nonFocusableCheckBox = new NonFocusableCheckBox();
        nonFocusableCheckBox.setMargin(new Insets(2, 0, 2, 2));
        nonFocusableCheckBox.setSelected(true);
        nonFocusableCheckBox.setBorderPaintedFlat(false);
        nonFocusableCheckBox.setDoubleBuffered(false);
        nonFocusableCheckBox.setText("Open generated documentation in browser");
        nonFocusableCheckBox.setMnemonic('G');
        nonFocusableCheckBox.setDisplayedMnemonicIndex(5);
        nonFocusableCheckBox.setFocusCycleRoot(false);
        jPanel2.add((Component)nonFocusableCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInputDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Input directory:");
        jLabel2.setDisplayedMnemonic('I');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Window title:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWindowTitle = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackagesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 3, 2, 0, 3, 3, 3, null, new Dimension(151, -1), null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

