/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.testme.instrumentation;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jetbrains.testme.instrumentation.URLsUtil;

public class CoveragePremain {
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        File archiveFile = new File(CoveragePremain.getArchivePath());
        File lib = archiveFile.getParentFile();
        URL[] urls = new URL[]{CoveragePremain.fileToURL(archiveFile), CoveragePremain.fileToURL(new File(lib, "asm-all.jar")), CoveragePremain.fileToURL(new File(lib, "trove4j.jar"))};
        Class<?> instrumentator = Class.forName("org.jetbrains.testme.instrumentation.TestDiscoveryInstrumentator", true, new URLClassLoader(urls){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                1 var3_3 = this;
                synchronized (var3_3) {
                    Class<?> result = this.findLoadedClass(name);
                    if (result == null) {
                        try {
                            result = this.findClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (result != null && resolve) {
                        this.resolveClass(result);
                    }
                    if (result != null) {
                        return result;
                    }
                }
                return this.getParent().loadClass(name);
            }
        });
        Method premainMethod = instrumentator.getDeclaredMethod("premain", String.class, Instrumentation.class);
        premainMethod.invoke(null, argsString, instrumentation);
    }

    private static URL fileToURL(File file) throws MalformedURLException {
        return file.getAbsoluteFile().toURI().toURL();
    }

    private static String getArchivePath() {
        String className = CoveragePremain.class.getName().replace('.', '/') + ".class";
        URL resourceURL = CoveragePremain.class.getResource("/" + className);
        if (resourceURL == null) {
            resourceURL = ClassLoader.getSystemResource(className);
        }
        return URLsUtil.extractRoot(resourceURL, "/" + className);
    }
}

