/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.testme.instrumentation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.testme.instrumentation.InstrumentedMethodsFilter;
import org.jetbrains.testme.instrumentation.Instrumenter;

public class TestDiscoveryInstrumentator {
    private static final AtomicInteger myInstrumentedClasses = new AtomicInteger();
    private static final AtomicInteger myInstrumentedMethods = new AtomicInteger();
    private static final AtomicLong myInstrumentedClassesTime = new AtomicLong();

    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        instrumentation.addTransformer(new ClassFileTransformer(){
            private boolean computeFrames = this.computeFrames();

            public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    if (className == null) {
                        return null;
                    }
                    if (loader == null) {
                        return null;
                    }
                    if (className.endsWith(".class")) {
                        className = className.substring(0, className.length() - 6);
                    }
                    if ((className = className.replace('\\', '.').replace('/', '.')).startsWith("com.intellij.rt.") || className.startsWith("com.intellij.util.lang.") || className.startsWith("com.intellij.util.containers.") || className.startsWith("com.intellij.openapi.util.text.") || className.startsWith("com.intellij.openapi.util.io.") || className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("gnu.trove.") || className.startsWith("org.jetbrains.org.objectweb.asm.") || className.startsWith("org.apache.oro.text.regex.") || className.startsWith("org.jetbrains.testme.") || className.startsWith("org.apache.log4j.") || className.startsWith("org.junit.") || className.startsWith("com.sun.") || className.startsWith("junit.") || className.startsWith("jdk.internal.") || className.startsWith("com.intellij.junit3.") || className.startsWith("com.intellij.junit4.")) {
                        return null;
                    }
                    return TestDiscoveryInstrumentator.instrument(classfileBuffer, className, loader, this.computeFrames);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            }

            private boolean computeFrames() {
                return System.getProperty("idea.coverage.no.frames") == null;
            }
        });
    }

    private static byte[] instrument(byte[] classfileBuffer, final String className, ClassLoader loader, boolean computeFrames) {
        long started = System.nanoTime();
        ClassReader cr = new ClassReader(classfileBuffer);
        if (computeFrames) {
            // empty if block
        }
        ClassWriter cw = TestDiscoveryInstrumentator.getClassWriter(1, loader);
        final ArrayList instrumentedMethods = new ArrayList();
        ClassVisitor instrumentedMethodCounter = new ClassVisitor(327680){
            final InstrumentedMethodsFilter methodsFilter;
            {
                super(x0);
                this.methodsFilter = new InstrumentedMethodsFilter(className);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.methodsFilter.visit(version, access, name, signature, superName, interfaces);
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (this.methodsFilter.shouldVisitMethod(access, name, desc, signature, exceptions)) {
                    if ("<init>".equals(name)) {
                        int slashPos = className.lastIndexOf(46);
                        int $Pos = className.lastIndexOf(36);
                        name = className.substring(Math.max(slashPos, $Pos) + 1);
                    }
                    instrumentedMethods.add(name);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        cr.accept(instrumentedMethodCounter, 0);
        Instrumenter cv = new Instrumenter((ClassVisitor)cw, className, instrumentedMethods.toArray(new String[instrumentedMethods.size()]));
        cr.accept((ClassVisitor)cv, 0);
        byte[] bytes = cw.toByteArray();
        long time = myInstrumentedClassesTime.addAndGet(System.nanoTime() - started);
        int classes = myInstrumentedClasses.incrementAndGet();
        int methods = myInstrumentedMethods.addAndGet(instrumentedMethods.size());
        return bytes;
    }

    private static ClassWriter getClassWriter(int flags, ClassLoader classLoader) {
        return new MyClassWriter(flags, classLoader);
    }

    public static int getClassFileVersion(ClassReader reader) {
        final int[] classFileVersion = new int[1];
        reader.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classFileVersion[0] = version;
            }
        }, 0);
        return classFileVersion[0];
    }

    private static class MyClassWriter
    extends ClassWriter {
        public static final String JAVA_LANG_OBJECT = "java/lang/Object";
        private final ClassLoader classLoader;

        public MyClassWriter(int flags, ClassLoader classLoader) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            try {
                String result;
                block5: {
                    ClassReader info1 = this.typeInfo(type1);
                    ClassReader info2 = this.typeInfo(type2);
                    String superType = this.checkImplementInterface(type1, type2, info1, info2);
                    if (superType != null) {
                        return superType;
                    }
                    superType = this.checkImplementInterface(type2, type1, info2, info1);
                    if (superType != null) {
                        return superType;
                    }
                    StringBuilder b1 = this.typeAncestors(type1, info1);
                    StringBuilder b2 = this.typeAncestors(type2, info2);
                    result = JAVA_LANG_OBJECT;
                    int end1 = b1.length();
                    int end2 = b2.length();
                    while (true) {
                        String p2;
                        int start1 = b1.lastIndexOf(";", end1 - 1);
                        int start2 = b2.lastIndexOf(";", end2 - 1);
                        if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block5;
                        String p1 = b1.substring(start1 + 1, end1);
                        if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                        result = p1;
                        end1 = start1;
                        end2 = start2;
                    }
                    return result;
                }
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
        }

        private String checkImplementInterface(String type1, String type2, ClassReader info1, ClassReader info2) throws IOException {
            if ((info1.getAccess() & 0x200) != 0) {
                if (this.typeImplements(type2, info2, type1)) {
                    return type1;
                }
                return JAVA_LANG_OBJECT;
            }
            return null;
        }

        private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
            StringBuilder b = new StringBuilder();
            while (!JAVA_LANG_OBJECT.equals(type)) {
                b.append(';').append(type);
                type = info.getSuperName();
                info = this.typeInfo(type);
            }
            return b;
        }

        private boolean typeImplements(String type, ClassReader classReader, String interfaceName) throws IOException {
            while (!JAVA_LANG_OBJECT.equals(type)) {
                int i;
                String[] itfs = classReader.getInterfaces();
                for (i = 0; i < itfs.length; ++i) {
                    if (!itfs[i].equals(interfaceName)) continue;
                    return true;
                }
                for (i = 0; i < itfs.length; ++i) {
                    if (!this.typeImplements(itfs[i], this.typeInfo(itfs[i]), interfaceName)) continue;
                    return true;
                }
                type = classReader.getSuperName();
                classReader = this.typeInfo(type);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClassReader typeInfo(String type) throws IOException {
            InputStream is = this.classLoader.getResourceAsStream(type + ".class");
            if (is == null) {
                System.out.println(this.classLoader + "," + type + ".class");
            }
            try {
                ClassReader classReader = new ClassReader(is);
                return classReader;
            }
            finally {
                is.close();
            }
        }
    }
}

