/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.InferencePackage$CapturedTypeConstructor$2824ce96;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBounds;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.ConstraintPosition;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.CommonSupertypes;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage$flexibleTypes$60fb3a4d;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage$collections$6f1efbe2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeBoundsImpl
implements TypeBounds {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final LinkedHashSet<TypeBounds.Bound> bounds;
    private Collection<? extends JetType> resultValues;
    @NotNull
    private final TypeParameterDescriptor typeVariable;
    @NotNull
    private final Variance varianceOfPosition;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeBoundsImpl.class);
    }

    @NotNull
    public LinkedHashSet<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final void addBound(@JetValueParameter(name="kind") @NotNull TypeBounds.BoundKind kind, @JetValueParameter(name="constrainingType") @NotNull JetType constrainingType, @JetValueParameter(name="position") @NotNull ConstraintPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(constrainingType, "constrainingType");
        Intrinsics.checkParameterIsNotNull(position, "position");
        this.resultValues = null;
        ((HashSet)this.getBounds()).add(new TypeBounds.Bound(constrainingType, kind, position));
    }

    @Override
    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    private final Set<JetType> filterBounds(@JetValueParameter(name="bounds") Collection<? extends TypeBounds.Bound> bounds, @JetValueParameter(name="kind") TypeBounds.BoundKind kind) {
        return this.filterBounds(bounds, kind, null);
    }

    private final Set<JetType> filterBounds(@JetValueParameter(name="bounds") Collection<? extends TypeBounds.Bound> bounds, @JetValueParameter(name="kind") TypeBounds.BoundKind kind, @JetValueParameter(name="errorValues", type="?") Collection<JetType> errorValues) {
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)bound.getKind(), (Object)kind)) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result.add(bound.getConstrainingType());
                continue;
            }
            Collection<JetType> collection = errorValues;
            Boolean bl = collection != null ? Boolean.valueOf(collection.add(bound.getConstrainingType())) : null;
        }
        return result;
    }

    @NotNull
    public final TypeBoundsImpl copy() {
        TypeBoundsImpl typeBounds = new TypeBoundsImpl(this.getTypeVariable(), this.getVarianceOfPosition());
        ((AbstractCollection)typeBounds.getBounds()).addAll(this.getBounds());
        typeBounds.resultValues = this.resultValues;
        return typeBounds;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@JetValueParameter(name="condition") @NotNull Function1<? super ConstraintPosition, ? extends Boolean> condition) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        TypeBoundsImpl result = new TypeBoundsImpl(this.getTypeVariable(), this.getVarianceOfPosition());
        Iterable iterable = this.getBounds();
        Collection collection = result.getBounds();
        void var5_5 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            TypeBounds.Bound it = (TypeBounds.Bound)element;
            if (!condition.invoke(it.getPosition()).booleanValue()) continue;
            destination.add(element);
        }
        List list = (List)destination;
        ((AbstractCollection)collection).addAll(list);
        return result;
    }

    @Override
    @Nullable
    public JetType getValue() {
        Collection<JetType> values = this.getValues();
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<JetType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<JetType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<JetType> computeValues() {
        JetType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver;
        boolean hasStrongBound;
        Object it;
        Object element2;
        LinkedHashSet values;
        block13: {
            boolean bl;
            values = new LinkedHashSet();
            if (((HashSet)this.getBounds()).isEmpty()) {
                return KotlinPackage.listOf();
            }
            Iterable $receiver2 = this.getBounds();
            for (Object element2 : $receiver2) {
                it = (TypeBounds.Bound)element2;
                if (!((TypeBounds.Bound)it).getPosition().isStrong()) continue;
                bl = true;
                break block13;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return KotlinPackage.listOf();
        }
        Set<JetType> exactBounds = this.filterBounds(this.getBounds(), TypeBounds.BoundKind.EXACT_BOUND, values);
        JetType bestFit = TypesPackage$flexibleTypes$60fb3a4d.singleBestRepresentative((Collection<? extends JetType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bestFit)) {
            return KotlinPackage.listOf(bestFit);
        }
        values.addAll(exactBounds);
        Iterable iterable = this.filterBounds(this.getBounds(), TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        for (Object element3 : $receiver) {
            JetType it2 = (JetType)element3;
            if (it2.getConstructor() instanceof IntegerValueTypeConstructor) {
                first.add(element3);
                continue;
            }
            second.add(element3);
        }
        Pair pair = new Pair(first, second);
        element2 = pair.component1();
        it = pair.component2();
        pair = null;
        JetType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(superTypeOfLowerBounds)) {
            JetType jetType = superTypeOfLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        UtilsPackage$collections$6f1efbe2.addIfNotNull(values, superTypeOfLowerBounds);
        JetType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(superTypeOfNumberLowerBounds)) {
            JetType jetType = superTypeOfNumberLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        UtilsPackage$collections$6f1efbe2.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection<JetType>)KotlinPackage.listOf(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            JetType jetType = superTypeOfAllLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        Set<JetType> upperBounds = this.filterBounds(this.getBounds(), TypeBounds.BoundKind.UPPER_BOUND, values);
        JetType intersectionOfUpperBounds = TypeUtils.intersect(JetTypeChecker.DEFAULT, upperBounds);
        if (!upperBounds.isEmpty() && intersectionOfUpperBounds != null && this.tryPossibleAnswer(intersectionOfUpperBounds)) {
            return KotlinPackage.setOf(intersectionOfUpperBounds);
        }
        values.addAll(this.filterBounds(this.getBounds(), TypeBounds.BoundKind.UPPER_BOUND));
        return values;
    }

    private final boolean tryPossibleAnswer(@JetValueParameter(name="possibleAnswer", type="?") JetType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !InferencePackage$CapturedTypeConstructor$2824ce96.isCaptured(possibleAnswer)) {
            return false;
        }
        for (TypeBounds.Bound bound : this.getBounds()) {
            TypeBounds.BoundKind boundKind = bound.getKind();
            if (!(Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND) ? !JetTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer) : (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND) ? !JetTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType()) : Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND) && !JetTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        return this.varianceOfPosition;
    }

    public TypeBoundsImpl(@JetValueParameter(name="typeVariable") @NotNull TypeParameterDescriptor typeVariable, @JetValueParameter(name="varianceOfPosition") @NotNull Variance varianceOfPosition) {
        Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
        Intrinsics.checkParameterIsNotNull((Object)varianceOfPosition, "varianceOfPosition");
        this.typeVariable = typeVariable;
        this.varianceOfPosition = varianceOfPosition;
        this.bounds = new LinkedHashSet();
    }
}

