/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgBranchPopup;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgStatusWidget
extends DvcsStatusWidget<HgRepository> {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings myProjectSettings;

    public HgStatusWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "<init>"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "<init>"));
        }
        super(project, "Hg");
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
    }

    public StatusBarWidget copy() {
        return new HgStatusWidget(this.myVcs, (Project)ObjectUtils.assertNotNull((Object)this.getProject()), this.myProjectSettings);
    }

    @Nullable
    protected HgRepository guessCurrentRepository(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "guessCurrentRepository"));
        }
        return HgUtil.getCurrentRepository(project);
    }

    @NotNull
    protected String getFullBranchName(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getFullBranchName"));
        }
        String string = HgUtil.getDisplayableBranchOrBookmarkText(repository);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getFullBranchName"));
        }
        return string;
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "isMultiRoot"));
        }
        return HgUtil.getRepositoryManager(project).moreThanOneRoot();
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull HgRepository repository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getPopup"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getPopup"));
        }
        ListPopup listPopup = HgBranchPopup.getInstance(project, repository).asListPopup();
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getPopup"));
        }
        return listPopup;
    }

    protected void subscribeToRepoChangeEvents(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "subscribeToRepoChangeEvents"));
        }
        project.getMessageBus().connect().subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, @Nullable VirtualFile root) {
                HgStatusWidget.this.updateLater();
            }
        });
    }

    protected void rememberRecentRoot(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "rememberRecentRoot"));
        }
        this.myProjectSettings.setRecentRootPath(path);
    }
}

