/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsBlock
extends SourceInfoAwareJsNode
implements JsStatement {
    @NotNull
    private final List<JsStatement> statements;

    public JsBlock() {
        this(new ArrayList<JsStatement>());
    }

    public JsBlock(JsStatement statement) {
        this((List<JsStatement>)new SmartList((Object)statement));
    }

    public JsBlock(JsStatement ... statements) {
        this((List<JsStatement>)new SmartList((Object[])statements));
    }

    public JsBlock(@NotNull List<JsStatement> statements) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/google/dart/compiler/backend/js/ast/JsBlock", "<init>"));
        }
        this.statements = statements;
    }

    @NotNull
    public List<JsStatement> getStatements() {
        List<JsStatement> list = this.statements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsBlock", "getStatements"));
        }
        return list;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public boolean isGlobalBlock() {
        return false;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitBlock(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.statements);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptStatementList(this.statements);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsBlock deepCopy() {
        JsBlock jsBlock = new JsBlock(AstUtil.deepCopy(this.statements)).withMetadataFrom(this);
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsBlock", "deepCopy"));
        }
        return jsBlock;
    }
}

