/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.AnonymousObjectGeneration;
import org.jetbrains.kotlin.codegen.inline.AnonymousObjectTransformer;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineAdapter;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlineLambdaSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InlinedLambdaRemapper;
import org.jetbrains.kotlin.codegen.inline.InliningContext;
import org.jetbrains.kotlin.codegen.inline.InliningInstructionAdapter;
import org.jetbrains.kotlin.codegen.inline.InternalFinallyBlockInliner;
import org.jetbrains.kotlin.codegen.inline.InvokeCall;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.RemapVisitor;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.inline.TypeRemapper;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.commons.Remapper;
import org.jetbrains.org.objectweb.asm.commons.RemappingMethodAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;

public class MethodInliner {
    private final MethodNode node;
    private final Parameters parameters;
    private final InliningContext inliningContext;
    private final FieldRemapper nodeRemapper;
    private final boolean isSameModule;
    private final String errorPrefix;
    private final SourceMapper sourceMapper;
    private final JetTypeMapper typeMapper;
    private final List<InvokeCall> invokeCalls;
    private final List<AnonymousObjectGeneration> anonymousObjectGenerations;
    private final Map<String, String> currentTypeMapping;
    private final InlineResult result;
    private int lambdasFinallyBlocks;

    public MethodInliner(@NotNull MethodNode node2, @NotNull Parameters parameters2, @NotNull InliningContext parent, @NotNull FieldRemapper nodeRemapper, boolean isSameModule, @NotNull String errorPrefix, @NotNull SourceMapper sourceMapper) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (nodeRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeRemapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (errorPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPrefix", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (sourceMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        this.invokeCalls = new ArrayList<InvokeCall>();
        this.anonymousObjectGenerations = new ArrayList<AnonymousObjectGeneration>();
        this.currentTypeMapping = new HashMap<String, String>();
        this.node = node2;
        this.parameters = parameters2;
        this.inliningContext = parent;
        this.nodeRemapper = nodeRemapper;
        this.isSameModule = isSameModule;
        this.errorPrefix = errorPrefix;
        this.sourceMapper = sourceMapper;
        this.typeMapper = parent.state.getTypeMapper();
        this.result = InlineResult.create();
    }

    public InlineResult doInline(@NotNull MethodVisitor adapter, @NotNull LocalVarRemapper remapper, boolean remapReturn, @NotNull LabelOwner labelOwner) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        if (labelOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelOwner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        MethodNode transformedNode = this.markPlacesForInlineAndRemoveInlinable(this.node);
        Label end = new Label();
        transformedNode = this.doInline(transformedNode);
        MethodInliner.removeClosureAssertions(transformedNode);
        InsnList instructions = transformedNode.instructions;
        instructions.resetLabels();
        MethodNode resultNode = new MethodNode(327680, transformedNode.access, transformedNode.name, transformedNode.desc, transformedNode.signature, ArrayUtil.toStringArray((Collection)transformedNode.exceptions));
        RemapVisitor visitor2 = new RemapVisitor((MethodVisitor)resultNode, remapper, this.nodeRemapper);
        try {
            transformedNode.accept((MethodVisitor)visitor2);
        }
        catch (Exception e) {
            throw this.wrapException(e, transformedNode, "couldn't inline method call");
        }
        resultNode.visitLabel(end);
        if (this.inliningContext.isRoot()) {
            InternalFinallyBlockInliner.processInlineFunFinallyBlocks(resultNode, this.lambdasFinallyBlocks, ((StackValue.Local)remapper.remap((int)(this.parameters.totalSize() + 1)).value).index);
        }
        MethodInliner.processReturns(resultNode, labelOwner, remapReturn, end);
        resultNode.accept((MethodVisitor)new InliningInstructionAdapter(adapter));
        this.sourceMapper.endMapping();
        return this.result;
    }

    private MethodNode doInline(MethodNode node2) {
        final LinkedList<InvokeCall> currentInvokes = new LinkedList<InvokeCall>(this.invokeCalls);
        final MethodNode resultNode = new MethodNode(node2.access, node2.name, node2.desc, node2.signature, null);
        final Iterator<AnonymousObjectGeneration> iterator2 = this.anonymousObjectGenerations.iterator();
        RemappingMethodAdapter remappingMethodAdapter = new RemappingMethodAdapter(resultNode.access, resultNode.desc, (MethodVisitor)resultNode, (Remapper)new TypeRemapper(this.currentTypeMapping));
        InlineAdapter lambdaInliner = new InlineAdapter((MethodVisitor)remappingMethodAdapter, this.parameters.totalSize(), this.sourceMapper){
            private AnonymousObjectGeneration anonymousObjectGen;

            private void handleAnonymousObjectGeneration() {
                this.anonymousObjectGen = (AnonymousObjectGeneration)iterator2.next();
                if (this.anonymousObjectGen.shouldRegenerate()) {
                    String oldClassName = this.anonymousObjectGen.getOwnerInternalName();
                    String newClassName = ((MethodInliner)MethodInliner.this).inliningContext.nameGenerator.genLambdaClassName();
                    MethodInliner.this.currentTypeMapping.put(oldClassName, newClassName);
                    AnonymousObjectTransformer transformer = new AnonymousObjectTransformer(oldClassName, MethodInliner.this.inliningContext.subInlineWithClassRegeneration(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator, MethodInliner.this.currentTypeMapping, this.anonymousObjectGen), MethodInliner.this.isSameModule, Type.getObjectType((String)newClassName));
                    InlineResult transformResult = transformer.doTransform(this.anonymousObjectGen, MethodInliner.this.nodeRemapper);
                    MethodInliner.this.result.addAllClassesToRemove(transformResult);
                    MethodInliner.this.result.addChangedType(oldClassName, newClassName);
                    if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda && !this.anonymousObjectGen.isStaticOrigin()) {
                        MethodInliner.this.result.addClassToRemove(oldClassName);
                    }
                    if (transformResult.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
                        ReifiedTypeInliner.putNeedClassReificationMarker(this.mv);
                        MethodInliner.this.result.getReifiedTypeParametersUsages().mergeAll(transformResult.getReifiedTypeParametersUsages());
                    }
                }
            }

            public void anew(@NotNull Type type2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "anew"));
                }
                if (InlineCodegenUtil.isAnonymousConstructorCall(type2.getInternalName(), "<init>")) {
                    this.handleAnonymousObjectGeneration();
                }
                super.anew(type2);
            }

            public void visitMethodInsn(int opcode, String owner, String name2, String desc, boolean itf) {
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name2)) {
                    assert (!currentInvokes.isEmpty());
                    InvokeCall invokeCall = (InvokeCall)currentInvokes.remove();
                    LambdaInfo info = invokeCall.lambdaInfo;
                    if (info == null) {
                        super.visitMethodInsn(opcode, owner, name2, desc, itf);
                        return;
                    }
                    int valueParamShift = this.getNextLocalIndex();
                    MethodInliner.putStackValuesIntoLocals(info.getInvokeParamsWithoutCaptured(), valueParamShift, this, desc);
                    InlineCodegenUtil.addInlineMarker(this, true);
                    Parameters lambdaParameters = info.addAllParameters(MethodInliner.this.nodeRemapper);
                    InlinedLambdaRemapper newCapturedRemapper = new InlinedLambdaRemapper(info.getLambdaClassType().getInternalName(), MethodInliner.this.nodeRemapper, lambdaParameters);
                    this.setLambdaInlining(true);
                    SMAP lambdaSMAP = info.getNode().getClassSMAP();
                    NestedSourceMapper mapper = ((MethodInliner)MethodInliner.this).inliningContext.classRegeneration && !((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda ? new NestedSourceMapper(MethodInliner.this.sourceMapper, lambdaSMAP.getIntervals(), lambdaSMAP.getSourceInfo()) : new InlineLambdaSourceMapper(MethodInliner.this.sourceMapper.getParent(), info.getNode());
                    MethodInliner inliner = new MethodInliner(info.getNode().getNode(), lambdaParameters, MethodInliner.this.inliningContext.subInlineLambda(info), newCapturedRemapper, true, "Lambda inlining " + info.getLambdaClassType().getInternalName(), mapper);
                    LocalVarRemapper remapper = new LocalVarRemapper(lambdaParameters, valueParamShift);
                    InlineResult lambdaResult = inliner.doInline(this.mv, remapper, true, info);
                    MethodInliner.this.result.addAllClassesToRemove(lambdaResult);
                    Method bridge = MethodInliner.this.typeMapper.mapSignature(ClosureCodegen.getErasedInvokeFunction(info.getFunctionDescriptor())).getAsmMethod();
                    Method delegate2 = MethodInliner.this.typeMapper.mapSignature(info.getFunctionDescriptor()).getAsmMethod();
                    StackValue.onStack(delegate2.getReturnType()).put(bridge.getReturnType(), this);
                    this.setLambdaInlining(false);
                    InlineCodegenUtil.addInlineMarker(this, false);
                    mapper.endMapping();
                } else if (InlineCodegenUtil.isAnonymousConstructorCall(owner, name2)) {
                    assert (this.anonymousObjectGen != null) : "<init> call not corresponds to new call" + owner + " " + name2;
                    if (this.anonymousObjectGen.shouldRegenerate()) {
                        for (CapturedParamDesc capturedParamDesc : this.anonymousObjectGen.getAllRecapturedParameters()) {
                            this.visitFieldInsn(178, capturedParamDesc.getContainingLambdaName(), "$$$" + capturedParamDesc.getFieldName(), capturedParamDesc.getType().getDescriptor());
                        }
                        super.visitMethodInsn(opcode, this.anonymousObjectGen.getNewLambdaType().getInternalName(), name2, this.anonymousObjectGen.getNewConstructorDescriptor(), itf);
                        this.anonymousObjectGen = null;
                    } else {
                        super.visitMethodInsn(opcode, MethodInliner.this.changeOwnerForExternalPackage(owner, opcode), name2, desc, itf);
                    }
                } else if (!ReifiedTypeInliner.isNeedClassReificationMarker((AbstractInsnNode)new MethodInsnNode(opcode, owner, name2, desc, false))) {
                    super.visitMethodInsn(opcode, MethodInliner.this.changeOwnerForExternalPackage(owner, opcode), name2, desc, itf);
                }
            }

            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String desc) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "visitFieldInsn"));
                }
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "visitFieldInsn"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "visitFieldInsn"));
                }
                if (opcode == 178 && InlineCodegenUtil.isAnonymousSingletonLoad(owner, name2)) {
                    this.handleAnonymousObjectGeneration();
                }
                super.visitFieldInsn(opcode, owner, name2, desc);
            }

            @Override
            public void visitMaxs(int stack, int locals) {
                MethodInliner.this.lambdasFinallyBlocks = resultNode.tryCatchBlocks.size();
                super.visitMaxs(stack, locals);
            }
        };
        node2.accept((MethodVisitor)lambdaInliner);
        return resultNode;
    }

    @NotNull
    public static CapturedParamInfo findCapturedField(FieldInsnNode node2, FieldRemapper fieldRemapper) {
        assert (node2.name.startsWith("$$$")) : "Captured field template should start with $$$ prefix";
        FieldInsnNode fin = new FieldInsnNode(node2.getOpcode(), node2.owner, node2.name.substring(3), node2.desc);
        CapturedParamInfo field = fieldRemapper.findField(fin);
        if (field == null) {
            throw new IllegalStateException("Couldn't find captured field " + node2.owner + "." + node2.name + " in " + fieldRemapper.getLambdaInternalName());
        }
        CapturedParamInfo capturedParamInfo = field;
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "findCapturedField"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public MethodNode prepareNode(@NotNull MethodNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "prepareNode"));
        }
        final int capturedParamsSize = this.parameters.getCaptured().size();
        final int realParametersSize = this.parameters.getReal().size();
        Object[] types = Type.getArgumentTypes((String)node2.desc);
        Type returnType2 = Type.getReturnType((String)node2.desc);
        ArrayList<Type> capturedTypes = this.parameters.getCapturedTypes();
        Type[] allTypes = (Type[])ArrayUtil.mergeArrays((Object[])types, (Object[])capturedTypes.toArray(new Type[capturedTypes.size()]));
        node2.instructions.resetLabels();
        MethodNode transformedNode = new MethodNode(327680, node2.access, node2.name, Type.getMethodDescriptor((Type)returnType2, (Type[])allTypes), node2.signature, null){
            private final boolean isInliningLambda;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.isInliningLambda = MethodInliner.this.nodeRemapper.isInsideInliningLambda();
            }

            private int getNewIndex(int var) {
                return var + (var < realParametersSize ? 0 : capturedParamsSize);
            }

            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, this.getNewIndex(var));
            }

            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(this.getNewIndex(var), increment);
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, maxLocals + capturedParamsSize);
            }

            public void visitLineNumber(int line, @NotNull Label start) {
                if (start == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLineNumber"));
                }
                if (!this.isInliningLambda) {
                    // empty if block
                }
                super.visitLineNumber(line, start);
            }

            public void visitLocalVariable(@NotNull String name2, @NotNull String desc, String signature, @NotNull Label start, @NotNull Label end, int index2) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (start == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (end == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (!this.isInliningLambda) {
                    // empty if block
                }
                super.visitLocalVariable(name2, desc, signature, start, end, this.getNewIndex(index2));
            }
        };
        node2.accept((MethodVisitor)transformedNode);
        this.transformCaptured(transformedNode);
        MethodNode methodNode = transformedNode;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "prepareNode"));
        }
        return methodNode;
    }

    @NotNull
    protected MethodNode markPlacesForInlineAndRemoveInlinable(@NotNull MethodNode node2) {
        Frame[] sources;
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        node2 = this.prepareNode(node2);
        Analyzer<SourceValue> analyzer = new Analyzer<SourceValue>((Interpreter)new SourceInterpreter()){

            @NotNull
            protected Frame<SourceValue> newFrame(int nLocals, int nStack) {
                Frame<SourceValue> frame = new Frame<SourceValue>(nLocals, nStack){

                    public void execute(@NotNull AbstractInsnNode insn, Interpreter<SourceValue> interpreter) throws AnalyzerException {
                        if (insn == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$3$1", "execute"));
                        }
                        if (insn.getOpcode() == 177) {
                            return;
                        }
                        super.execute(insn, interpreter);
                    }
                };
                if (frame == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner$3", "newFrame"));
                }
                return frame;
            }
        };
        try {
            sources = analyzer.analyze("fake", node2);
        }
        catch (AnalyzerException e) {
            throw this.wrapException((Exception)((Object)e), node2, "couldn't inline method call");
        }
        AbstractInsnNode cur = node2.instructions.getFirst();
        int index2 = 0;
        boolean awaitClassReification = false;
        while (cur != null) {
            Frame frame = sources[index2];
            if (frame != null) {
                String owner;
                if (ReifiedTypeInliner.isNeedClassReificationMarker(cur)) {
                    awaitClassReification = true;
                } else if (cur.getType() == 5) {
                    MethodInsnNode methodInsnNode = (MethodInsnNode)cur;
                    owner = methodInsnNode.owner;
                    String desc = methodInsnNode.desc;
                    String name2 = methodInsnNode.name;
                    int paramLength = Type.getArgumentTypes((String)desc).length + 1;
                    if (InlineCodegenUtil.isInvokeOnLambda(owner, name2)) {
                        AbstractInsnNode insnNode;
                        SourceValue sourceValue = (SourceValue)frame.getStack(frame.getStackSize() - paramLength);
                        LambdaInfo lambdaInfo = null;
                        int varIndex = -1;
                        if (sourceValue.insns.size() == 1 && (lambdaInfo = this.getLambdaIfExists(insnNode = (AbstractInsnNode)sourceValue.insns.iterator().next())) != null) {
                            node2.instructions.remove(insnNode);
                        }
                        this.invokeCalls.add(new InvokeCall(varIndex, lambdaInfo));
                    } else if (InlineCodegenUtil.isAnonymousConstructorCall(owner, name2)) {
                        HashMap<Integer, LambdaInfo> lambdaMapping = new HashMap<Integer, LambdaInfo>();
                        int paramStart = frame.getStackSize() - paramLength;
                        for (int i = 0; i < paramLength; ++i) {
                            AbstractInsnNode insnNode;
                            LambdaInfo lambdaInfo;
                            SourceValue sourceValue = (SourceValue)frame.getStack(paramStart + i);
                            if (sourceValue.insns.size() != 1 || (lambdaInfo = this.getLambdaIfExists(insnNode = (AbstractInsnNode)sourceValue.insns.iterator().next())) == null) continue;
                            lambdaMapping.put(i, lambdaInfo);
                            node2.instructions.remove(insnNode);
                        }
                        this.anonymousObjectGenerations.add(this.buildConstructorInvocation(owner, desc, lambdaMapping, awaitClassReification));
                        awaitClassReification = false;
                    }
                } else if (cur.getOpcode() == 178) {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)cur;
                    owner = fieldInsnNode.owner;
                    if (InlineCodegenUtil.isAnonymousSingletonLoad(owner, fieldInsnNode.name)) {
                        this.anonymousObjectGenerations.add(new AnonymousObjectGeneration(owner, this.isSameModule, awaitClassReification, this.isAlreadyRegenerated(owner), true));
                        awaitClassReification = false;
                    }
                }
            }
            AbstractInsnNode prevNode = cur;
            cur = cur.getNext();
            ++index2;
            if (frame != null || prevNode.getType() == 8) continue;
            node2.instructions.remove(prevNode);
        }
        List blocks2 = node2.tryCatchBlocks;
        Iterator iterator2 = blocks2.iterator();
        while (iterator2.hasNext()) {
            TryCatchBlockNode block = (TryCatchBlockNode)iterator2.next();
            if (!MethodInliner.isEmptyTryInterval(block)) continue;
            iterator2.remove();
        }
        MethodNode methodNode = node2;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        return methodNode;
    }

    private static boolean isEmptyTryInterval(@NotNull TryCatchBlockNode tryCatchBlockNode) {
        LabelNode end;
        if (tryCatchBlockNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlockNode", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "isEmptyTryInterval"));
        }
        LabelNode start = tryCatchBlockNode.start;
        for (end = tryCatchBlockNode.end; end != start && end instanceof LabelNode; end = end.getPrevious()) {
        }
        return start == end;
    }

    @NotNull
    private AnonymousObjectGeneration buildConstructorInvocation(@NotNull String owner, @NotNull String desc, @NotNull Map<Integer, LambdaInfo> lambdaMapping, boolean needReification) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        if (lambdaMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaMapping", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        AnonymousObjectGeneration anonymousObjectGeneration = new AnonymousObjectGeneration(owner, needReification, this.isSameModule, lambdaMapping, this.inliningContext.classRegeneration, this.isAlreadyRegenerated(owner), desc, false);
        if (anonymousObjectGeneration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        return anonymousObjectGeneration;
    }

    private boolean isAlreadyRegenerated(@NotNull String owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "isAlreadyRegenerated"));
        }
        return this.inliningContext.typeMapping.containsKey(owner);
    }

    public LambdaInfo getLambdaIfExists(AbstractInsnNode insnNode) {
        if (insnNode.getOpcode() == 25) {
            int varIndex = ((VarInsnNode)insnNode).var;
            if (varIndex < this.parameters.totalSize()) {
                return this.parameters.get(varIndex).getLambda();
            }
        } else if (insnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
            if (fieldInsnNode.name.startsWith("$$$")) {
                return MethodInliner.findCapturedField(fieldInsnNode, this.nodeRemapper).getLambda();
            }
        }
        return null;
    }

    private static void removeClosureAssertions(MethodNode node2) {
        AbstractInsnNode cur = node2.instructions.getFirst();
        while (cur != null && cur.getNext() != null) {
            AbstractInsnNode next2 = cur.getNext();
            if (next2.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)next2;
                if (methodInsnNode.name.equals("checkParameterIsNotNull") && methodInsnNode.owner.equals("kotlin/jvm/internal/Intrinsics")) {
                    AbstractInsnNode prev2 = cur.getPrevious();
                    assert (cur.getOpcode() == 18) : "checkParameterIsNotNull should go after LDC but " + cur;
                    assert (prev2.getOpcode() == 25) : "checkParameterIsNotNull should be invoked on local var but " + prev2;
                    node2.instructions.remove(prev2);
                    node2.instructions.remove(cur);
                    cur = next2.getNext();
                    node2.instructions.remove(next2);
                    next2 = cur;
                }
            }
            cur = next2;
        }
    }

    private void transformCaptured(@NotNull MethodNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "transformCaptured"));
        }
        if (this.nodeRemapper.isRoot()) {
            return;
        }
        for (AbstractInsnNode cur = node2.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            List<AbstractInsnNode> accessChain;
            AbstractInsnNode insnNode;
            if (!(cur instanceof VarInsnNode) || cur.getOpcode() != 25 || ((VarInsnNode)cur).var != 0 || (insnNode = this.nodeRemapper.foldFieldAccessChainIfNeeded(accessChain = MethodInliner.getCapturedFieldAccessChain((VarInsnNode)cur), node2)) == null) continue;
            cur = insnNode;
        }
    }

    @NotNull
    public static List<AbstractInsnNode> getCapturedFieldAccessChain(@NotNull VarInsnNode aload0) {
        if (aload0 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aload0", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "getCapturedFieldAccessChain"));
        }
        ArrayList<AbstractInsnNode> fieldAccessChain = new ArrayList<AbstractInsnNode>();
        fieldAccessChain.add((AbstractInsnNode)aload0);
        AbstractInsnNode next2 = aload0.getNext();
        while (next2 != null && next2 instanceof FieldInsnNode || next2 instanceof LabelNode) {
            if (next2 instanceof LabelNode) {
                next2 = next2.getNext();
                continue;
            }
            fieldAccessChain.add(next2);
            if (!"this$0".equals(((FieldInsnNode)next2).name)) break;
            next2 = next2.getNext();
        }
        ArrayList<AbstractInsnNode> arrayList = fieldAccessChain;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "getCapturedFieldAccessChain"));
        }
        return arrayList;
    }

    public static void putStackValuesIntoLocals(List<Type> directOrder, int shift, InstructionAdapter iv, String descriptor2) {
        Type[] actualParams = Type.getArgumentTypes((String)descriptor2);
        assert (actualParams.length == directOrder.size()) : "Number of expected and actual params should be equals!";
        int size = 0;
        for (Type next2 : directOrder) {
            size += next2.getSize();
        }
        shift += size;
        int index2 = directOrder.size();
        for (Type next3 : Lists.reverse(directOrder)) {
            Type typeOnStack;
            shift -= next3.getSize();
            if (!(typeOnStack = actualParams[--index2]).equals((Object)next3)) {
                StackValue.onStack(typeOnStack).put(next3, iv);
            }
            iv.store(shift, next3);
        }
    }

    public String changeOwnerForExternalPackage(String type2, int opcode) {
        KotlinJvmBinaryClass klass;
        VirtualFile virtualFile;
        if (this.isSameModule || (opcode & 0xB8) == 0) {
            return type2;
        }
        JvmClassName name2 = JvmClassName.byInternalName(type2);
        String packageClassInternalName = PackageClassUtils.getPackageClassInternalName(name2.getPackageFqName());
        if (type2.startsWith(packageClassInternalName + '$') && (virtualFile = InlineCodegenUtil.findVirtualFile(this.inliningContext.state.getProject(), type2)) != null && (klass = KotlinBinaryClassCache.getKotlinBinaryClass(virtualFile)) != null && klass.getClassHeader().getSyntheticClassKind() == JvmAnnotationNames.KotlinSyntheticClass.Kind.PACKAGE_PART) {
            return packageClassInternalName;
        }
        return type2;
    }

    @NotNull
    public RuntimeException wrapException(@NotNull Exception originalException, @NotNull MethodNode node2, @NotNull String errorSuffix) {
        if (originalException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalException", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        if (errorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorSuffix", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        if (originalException instanceof InlineException) {
            InlineException inlineException = new InlineException(this.errorPrefix + ": " + errorSuffix, originalException);
            if (inlineException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
            }
            return inlineException;
        }
        InlineException inlineException = new InlineException(this.errorPrefix + ": " + errorSuffix + "\ncause: " + InlineCodegenUtil.getNodeText(node2), originalException);
        if (inlineException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        return inlineException;
    }

    @NotNull
    public static List<PointForExternalFinallyBlocks> processReturns(@NotNull MethodNode node2, @NotNull LabelOwner labelOwner, boolean remapReturn, Label endLabel) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
        }
        if (labelOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelOwner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
        }
        if (!remapReturn) {
            List<PointForExternalFinallyBlocks> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
            }
            return list;
        }
        ArrayList<PointForExternalFinallyBlocks> result2 = new ArrayList<PointForExternalFinallyBlocks>();
        InsnList instructions = node2.instructions;
        for (AbstractInsnNode insnNode = instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!InlineCodegenUtil.isReturnOpcode(insnNode.getOpcode())) continue;
            AbstractInsnNode previous = insnNode.getPrevious();
            boolean isLocalReturn = true;
            String labelName = null;
            if (previous != null && previous instanceof MethodInsnNode && "$$$$$NON_LOCAL_RETURN$$$$$".equals(((MethodInsnNode)previous).owner)) {
                MethodInsnNode flagNode = (MethodInsnNode)previous;
                labelName = flagNode.name;
            }
            if (labelName != null && (isLocalReturn = labelOwner.isMyLabel(labelName))) {
                instructions.remove(previous);
            }
            if (isLocalReturn && endLabel != null) {
                LabelNode labelNode = (LabelNode)endLabel.info;
                JumpInsnNode jumpInsnNode = new JumpInsnNode(167, labelNode);
                instructions.insert(insnNode, (AbstractInsnNode)jumpInsnNode);
                instructions.remove(insnNode);
                insnNode = jumpInsnNode;
            }
            result2.add(new PointForExternalFinallyBlocks(isLocalReturn ? insnNode : insnNode.getPrevious(), InlineCodegenUtil.getReturnType(insnNode.getOpcode())));
        }
        ArrayList<PointForExternalFinallyBlocks> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
        }
        return arrayList;
    }

    public static class PointForExternalFinallyBlocks {
        final AbstractInsnNode beforeIns;
        final Type returnType;

        public PointForExternalFinallyBlocks(AbstractInsnNode beforeIns, Type returnType2) {
            this.beforeIns = beforeIns;
            this.returnType = returnType2;
        }
    }
}

