/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.data;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCopyPasteReferenceProcessor;
import org.jetbrains.kotlin.idea.codeInsight.KotlinReferenceData;
import org.jetbrains.kotlin.idea.codeInsight.KotlinReferenceTransferableData;
import org.jetbrains.kotlin.idea.codeInsight.RestoreReferencesDialog;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenPackage;
import org.jetbrains.kotlin.idea.conversion.copy.CopyPackage$RangeUtils$e5cefcfb;
import org.jetbrains.kotlin.idea.imports.ImportsPackage;
import org.jetbrains.kotlin.idea.references.JetMultiReference;
import org.jetbrains.kotlin.idea.references.JetReference;
import org.jetbrains.kotlin.idea.references.JetSimpleNameReference;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportList;
import org.jetbrains.kotlin.psi.JetNameReferenceExpression;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.utils.UtilsPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"8\u0016)\t3j\u001c;mS:\u001cu\u000e]=QCN$XMU3gKJ,gnY3Qe>\u001cWm]:pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'bC2pI\u0016Len]5hQRTacQ8qsB\u000b7\u000f^3Q_N$\bK]8dKN\u001cxN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u001b\u0015$\u0017\u000e^8s\u0003\u000e$\u0018n\u001c8t\u0015}Yu\u000e\u001e7j]J+g-\u001a:f]\u000e,GK]1og\u001a,'/\u00192mK\u0012\u000bG/\u0019\u0006\u0007y%t\u0017\u000e\u001e \u000b1%;ej\u0014*F?J+e)\u0012*F\u001d\u000e+5kX%O'&#UIC\u0003BeJ\f\u0017PC\u0003DY\u0006\u001c8O\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT!BS3u\u000b2,W.\u001a8u\u0015\r\u00018/\u001b\u0006\u0004\u0019>;%B\u0002'pO\u001e,'OC\u0004pa\u0016t\u0017\r]5\u000b\u0015\u0011L\u0017m\u001a8pgRL7MC\u0004O_RtU\u000f\u001c7\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TAcY8mY\u0016\u001cGOU3gKJ,gnY3ECR\f'\u0002\u00024jY\u0016TqAS3u\r&dWM\u0003\u0007ti\u0006\u0014Ho\u00144gg\u0016$8O\u0003\u0005J]R\f%O]1z\u0015))g\u000eZ(gMN,Go\u001d\u0006\u0005\u0019&\u001cHOC\nL_Rd\u0017N\u001c*fM\u0016\u0014XM\\2f\t\u0006$\u0018M\u0003\u0003vi&d'bF2pY2,7\r\u001e+sC:\u001ch-\u001a:bE2,G)\u0019;b\u0015\u001d\u00016/\u001b$jY\u0016Ta!\u001a3ji>\u0014(BB#eSR|'O\u0003\u000fde\u0016\fG/\u001a*fM\u0016\u0014XM\\2f)>\u0014Vm\u001d;pe\u0016$\u0015\r^1\u000b\u000f\u0015dW-\\3oi*9!/\u001a4ECR\f'b\u00054jY\u0016\u0014Vm]8mkRLwN\\*d_B,'\u0002\u0003&fiN\u001bw\u000e]3\u000b\u000fI,7o\u001c7wK*11oY8qKNTaCU3gKJ,gnY3U_J+7\u000f^8sK\u0012\u000bG/\u0019\u00069\u0017>$H.\u001b8D_BL\b+Y:uKJ+g-\u001a:f]\u000e,\u0007K]8dKN\u001cxN\u001d\u0013SK\u001a,'/\u001a8dKR{'+Z:u_J,G)\u0019;b\u0015])\u0007\u0010\u001e:bGR$&/\u00198tM\u0016\u0014\u0018M\u00197f\t\u0006$\u0018MC\u0004d_:$XM\u001c;\u000b\u0019Q\u0013\u0018M\\:gKJ\f'\r\\3\u000b\u0007\u0005<HO\u0003\u0007eCR\fGO]1og\u001a,'O\u0003\u000bgS:$7)\u00197mC\ndW\rV8J[B|'\u000f\u001e\u0006\u0007MFt\u0015-\\3\u000b\r\u0019\u000bh*Y7f\u0015\u0011q\u0017-\\3\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\rgS:$\u0017*\u001c9peR\f'\r\\3EKN\u001c'/\u001b9u_J\u001c(BC\"pY2,7\r^5p]*)B)Z2mCJ\fG/[8o\t\u0016\u001c8M]5qi>\u0014(\"\u00044j]\u0012\u0014VMZ3sK:\u001cWM\u0003\u0003eCR\f'B\u00032m_\u000e\\7\u000b^1si*\u0019\u0011J\u001c;\u000b/\u0019Lg\u000e\u001a*fM\u0016\u0014XM\\2fgR{'+Z:u_J,'\"\u0004:fM\u0016\u0014XM\\2f\t\u0006$\u0018M\u0003\u000bqe>\u001cWm]:SK\u001a,'/\u001a8dK\u0012\u000bG/\u0019\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRTA!\u00168ji*9\u0002O]8dKN\u001cHK]1og\u001a,'/\u00192mK\u0012\u000bG/\u0019\u0006\u0007E>,h\u000eZ:\u000b\u0017I\u000bgnZ3NCJ\\WM\u001d\u0006\fG\u0006\u0014X\r^(gMN,GO\u0003\u0005j]\u0012,g\u000e^3e\u0015\r\u0011VM\u001a\u0006\b\u0005>|G.Z1o\u0015\u00191\u0018\r\\;fg*\t\"/Z:u_J,'+\u001a4fe\u0016t7-Z:\u000b'I,g-\u001a:f]\u000e,7\u000fV8SKN$xN]3\u000b7MDwn\u001e*fgR|'/\u001a*fM\u0016\u0014XM\\2fg\u0012K\u0017\r\\8h\u00151!x\u000eV3yiJ\u000bgnZ3t\u0015%!V\r\u001f;SC:<WMC\tNkR\f'\r\\3D_2dWm\u0019;j_:TQ$\u00193e%\u00164WM]3oG\u0016$\u0015\r^1J]NLG-Z#mK6,g\u000e\u001e\u0006\u000b!NLW\t\\3nK:$(bC:uCJ$xJ\u001a4tKRTAaS5oI*Y\u0011n]#yi\u0016t7/[8o\u0015aYu\u000e\u001e7j]J+g-\u001a:f]\u000e,G)\u0019;bI-Kg\u000e\u001a\u0006\u000fSNLenQ8qS\u0016$\u0017I]3b\u001591\u0017\u000e\\3D_BLW\r\u001a$s_6T\u0011bQ8na\u0006t\u0017n\u001c8\u0005\n)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\t!1\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001RA\u0003\u0003\t\u0011AI!B\u0002\u0005\n!\u0019A\u0002A\u0003\u0004\t\tAQ\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0007\u0011\u001ba\u0001!B\u0001\t\u0010\u0015\u0011Aa\u0002\u0005\t\u000b\r!y\u0001C\u0004\r\u0001\u0015\u0011A!\u0001\u0005\n\u000b\r!\t\u0002#\u0005\r\u0001\u0015\u0011Aq\u0002\u0005\b\u000b\t!9\u0001#\u0006\u0006\u0005\u0011Q\u0001bC\u0003\u0004\t+A!\u0002\u0004\u0001\u0006\u0005\u0011\u0005\u0001\u0002D\u0003\u0004\t/A9\u0002\u0004\u0001\u0006\u0005\u0011U\u0001BC\u0003\u0004\t#Aa\u0002\u0004\u0001\u0006\u0007\u00111\u0001b\u0004\u0007\u0001\u000b\r!a\u0001\u0003\t\r\u0001\u0015\u0019AA\u0001E\u0011\u0019\u0001)!\u0001B\u0004\t#\u0015\u0011Aa\u0004\u0005\u0011\u000b\t!\t\u0002\u0003\b\u0006\u0005\u0011\u001d\u0001\"C\u0003\u0004\tCA!\u0003\u0004\u0001\u0006\u0005\u0011Q\u0001RE\u0003\u0004\tGA1\u0003\u0004\u0001\u0006\u0005\u0011\u0005\u0002BE\u0003\u0003\tGA1#\u0002\u0002\u0005\u0003!1RA\u0001C\u0014\u0011[)1\u0001\u0002\u000b\t,1\u0001Qa\u0001C\u0003\u0011]a\u0001!\u0002\u0002\u0005\u0005!=RA\u0001C\t\u0011#)!\u0001\u0002\u0002\t\"\u0015\u0011A\u0001\u0006E\u0016\u000b\t!q\u0001c\r\u0006\u0005\u0011=\u0002BG\u0003\u0004\taA\u0011\u0004\u0004\u0001\u0006\u0005\u0011A\u0002\"G\u0003\u0003\t\u0005AA$B\u0002\u00054!]B\u0002A\u0003\u0003\t\u0005AQ$B\u0002\u00056!eB\u0002A\u0003\u0003\tkAI$\u0002\u0002\u00054!]Ra\u0001\u0003\u0007\u0011ya\u0001!B\u0002\u00056!uB\u0002A\u0003\u0003\t=Aa$B\u0002\u0005\r!\u0005C\u0002A\u0003\u0003\t)A)%B\u0002\u0005>!\u0019C\u0002A\u0003\u0004\t\u0019A9\u0005\u0004\u0001\u0006\u0005\u0011u\u0002bI\u0003\u0004\tGAQ\u0005\u0004\u0001\u0006\u0005\u0011Q\u0001\"E\u0003\u0004\t\u0005Bi\u0005\u0004\u0001\u0006\u0007\u00111\u0001b\n\u0007\u0001\u000b\t!\u0019\u0003C\u0013\u0006\u0005\u0011\t\u0003RJ\u0003\u0004\t\u0005B!\u0006\u0004\u0001\u0006\u0007\u00111\u0001R\u000b\u0007\u0001\u000b\r!\t\u0003c\u0016\r\u0001\u0015\u0011A\u0011\u0005E,\u000b\r!i\u0002#\u0017\r\u0001\u0015\u0011AA\u0001E.\t\ra)\u0001E\u0018\u001a\r\u0015\t\u0001\"B\u0005\u0004\u0013\t)\u0011\u0001c\u0003\u001d_q9R&\u0006\u0003b\ta1\u0011eC\u0003\u0002\u0011\u001bI\u0001\"C\u0004\u0006\u0003!A\u0011\u0002\u0002C\u0001\u0013\t)\u0011\u0001C\u0005V\u0007\u0015)A\u0001\u0002\u0004\n\u0005!MA\u0012A\u0017\u0016\t\u0005$\u00014C\u0011\r\u000b\u0005A1\u0002%\u0007\u0016\f\u0015\t\u0001b\u0003G\u0001#\u000e\tA\u0001D)\u0004\u0003\u0011aQk\u0001\u0003\u0006\u0007\u0011M\u0011\"\u0001E\r[1\"1\u0001G\u0007\u001e\u000e\u0011\u0001\u00012D\u0007\u0003\u000b\u0005AQ\u0002U\u0002\u0001;\u001b!\u0001\u0001#\b\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0002u5A\u0001\u0001E\u0010\u001b\t)\u0011\u0001c\u0007Q\u0007\u0005\tc!B\u0001\t\u001d%\u0019\u0011BA\u0003\u0002\u0011;\t6a\u0003\u0003\u000e\u0013\u0005Ay\"D\u0001\t!5\u0011AQ\u0001G\u0001\u001b\t!)\u0001$\u0001.l\u0011Y\u00014EO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!\t\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RE\u0007\u0003\u000b\u0005A!\u0003UB\u0001;\u001b!\u0001\u0001#\b\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0003u5A\u0001\u0001E\u0010\u001b\t)\u0011\u0001c\u0007Q\u0007\u0007\tc!B\u0001\t\u001d%\u0019\u0011BA\u0003\u0002\u0011\u0017\t6!\u0004C\u0012\u0013\u0005Ay\"D\u0001\t&5\t\u0001bE\u0007\u0003\t\u000ba\t!\u0004\u0002\u0005\u00061\u0005Q\u0016\r\u0003\u00021Oij\u0001\u0002\u0001\t)5\u0011Q!\u0001\u0005\n!\u000e\u0001QT\u0002\u0003\u0001\u0011Si!!B\u0001\t\u001eA\u001b\t!(\u0004\u0005\u0001!mQBA\u0003\u0002\u00115\u00016!AO\u0007\t\u0001AQ#\u0004\u0002\u0006\u0003!%\u0002ka\u0001\"\u0007\u0015\t\u0001\"\u0006G\u0001#\u000eYAqE\u0005\u0002\u0011Wi\u0011\u0001\u0003\f\u000e\u0003!5R\"\u0001\u0005\u0011\u001b\u0005Aq#L\f\u0005\u0017aART\u0002\u0003\u0001\u0011ci!!B\u0001\t2A\u001b\u0001!\t\u0004\u0006\u0003!q\u0011bA\u0005\u0003\u000b\u0005AY!U\u0002\u0006\taI\u0011\u0001c\b\u000e\u0003!IR6\b\u0003\u00021kij\u0001\u0002\u0001\t75\u0011Q!\u0001\u0005\u001b!\u000e\u0001QT\u0002\u0003\u0001\u00117i!!B\u0001\t\u001bA\u001b\t!I\u0002\u0006\u0003!YB\u0012A)\u0004\u000f\u0011U\u0012\"\u0001E\u001c\u001b\u0005AA$D\u0001\t!5\u0006C!\u0001M\u001e;\u001b!\u0001\u0001C\u000e\u000e\u0005\u0015\t\u0001B\u0007)\u0004\u0001u5A\u0001\u0001E\u000e\u001b\t)\u0011\u0001C\u0007Q\u0007\u0003\tc!B\u0001\t:%\u0019\u0011BA\u0003\u0002\u0011u\t6a\u0002C\u001e\u0013\u0005AY$D\u0001\t95\t\u0001\u0002E\u0017(\t\u0005Ar$(\u0004\u0005\u0001!}RBA\u0003\u0002\u0011;\u00016\u0001AO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!i\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001\u0002I\u0007\u0003\u000b\u0005Aa\u0004U\u0002\u0002C\r)\u0011\u0001C\u0005\r\u0002E\u001b\u0011\u0002B\u0010\n\u0003!1R\"\u0001E\u0017\u001b\u0005A\u0001#D\u0001\u0005\u00065\u0002D!\u0001\r\";\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001\"\u0005)\u0004\u0001u5A\u0001\u0001\u0005!\u001b\t)\u0011\u0001\u0003\u0010Q\u0007\u0003i:\u0002\u0002\u0001\tD59Q!\u0001E\u0007\u0013\u0011!\t!\u0003\u0002\u0006\u0003!u\u0001kA\u0001\"\r\u0015\t\u0001BD\u0005\u0004\u0013\t)\u0011\u0001C\u000bR\u0007)!\u0011%C\u0001\t 5\t\u0001RE\u0007\u0002\t\u000bi!\u0001#\f\r\u00025&Da\u0001\r#;\u001b!\u0001\u0001#\u0012\u000e\u0005\u0015\t\u0001b\b)\u0004\u0001u5A\u0001\u0001E\u000e\u001b\t)\u0011\u0001C\u0007Q\u0007\u0003ij\u0001\u0002\u0001\tA5\u0011Q!\u0001\u0005\u001f!\u000e\tQT\u0003\u0003\u0001\u0011\u0007ja!B\u0001\t\u000e%\u0019\u0011BA\u0003\u0002\u0011;\u000161A\u0011\u0003\u000b\u0005Ay$U\u0002\r\t\tJ\u0011\u0001\u0002\u0001\u000e\u0003!\u0001S\"\u0001\u0005\u0011\u001b\u0005!)!\u0004\u0002\t.1\u0005QV3\u0001\u0005\u0017a!ST\u0002\u0003\u0001\u0011\u000bj!!B\u0001\t?A\u001b\u0001!(\u0004\u0005\u0001!\u0015RBA\u0003\u0002\u0011I\u00016\u0011AO\u0007\t\u0001AI%\u0004\u0002\u0006\u0003!\u0005\u0003kA\u0001\u001e\u000e\u0011\u0001\u00012J\u0007\u0003\u000b\u0005Aa\u0004UB\u0002;+!\u0001\u0001\u0003\u0014\u000e\r\u0015\t\u00012I\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0012Q\u0007\ti*\u0002\u0002\u0001\tP51Q!\u0001\u0005\u000f\u0013\rI!!B\u0001\t\fA\u001b)!\t\u0002\u0006\u0003!}\u0012kA\b\u0005I%\tA\u0001A\u0007\u0002\u0011\u0001j\u0011\u0001C\n\u000e\u0003!\u0015S\"\u0001C\u0003\u001b\u0005A1%D\u0001\t 5\u0006C!\u0001\r);+!\u0001\u0001#\u0015\u000e\r\u0015\t\u0001\u0012H\u0005\u0004\u0013\t)\u0011\u0001C\u000bQ\u0007\u0001ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001\u0005\u000e!\u000e\u0005\u0011EA\u0003\u0002\u0011\u007f\t6a\u0002\u0003)\u0013\u0005!\u0001!D\u0001\t<5\t\u0001\u0002EW%\t\u0005A\u0012&(\u0004\u0005\u0001!\u0015SBA\u0003\u0002\u0011}\u00016\u0001AO\u000b\t\u0001A\t&\u0004\u0004\u0006\u0003!q\u0011bA\u0005\u0003\u000b\u0005AQ\u0003UB\u0001C\u0019)\u0011\u0001#\u000f\n\u0007%\u0011Q!\u0001\u0005\u0016#\u000e9A!K\u0005\u0002\u0011wi\u0011\u0001\u0003\u0011\u000e\u0003!}QV\t\u0003\u00021'jj\u0001\u0002\u0001\t\u001e5\u0011Q!\u0001E\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011?i!!B\u0001\t\u001cA\u001b\t!\t\u0004\u0006\u0003!q\u0011bA\u0005\u0003\u000b\u0005A9%U\u0002\n\t'J\u0011\u0001c\b\u000e\u0005\u0011\u0015A\u0012A\u0007\u0003\t\u000ba\t!\fc\u0001\t\u0005)b!B\u0001\tI%\u0019\u0011BA\u0003\u0002\u0011;A2&(\u0004\u0005\u0001!!RBA\u0003\u0002\u0011\u0013\u00026\u0011AO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!i\u0001kA\u0001\u001e\u000e\u0011\u0001\u0001\u0002L\u0007\u0003\u000b\u0005Aa\u0004UB\u0002;\u001b!\u0001\u0001#\b\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0005u5A\u0001\u0001E\u0010\u001b\t)\u0011\u0001c\u0007Q\u0007\u000b\t#!B\u0001\t@E\u001b\u0011\u0003B\u0016\n\u0003\u0011\u0001Q\"\u0001E\u001e\u001b\u0005AQ%D\u0001\t!5\tAQA\u0007\u0003\t\u000ba\t!\u0004\u0002\u0005\u00061\u0005QV\u0004\u0003\u0002+\t)\u0011\u0001c\u0013\u0019[\u0005\u0012Q!\u0001\u0005##\u000e)A!L\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0014.[\u0011\tQCA\u0003\u0002\u0011\u0013Bb&(\u0004\u0005\u0001!uSBA\u0003\u0002\u00115\u00016\u0011AO\u0007\t\u0001Ai\"\u0004\u0002\u0006\u0003!m\u0001kA\u0001\u001e\u000e\u0011\u0001\u0001rD\u0007\u0003\u000b\u0005AY\u0002UB\u0002C\t)\u0011\u0001\u0003\u0012R\u00075!a&C\u0001\u0005\u00025\t\u0001\"J\u0007\u0002\u0011Ai!\u0001\"\u0002\r\u00025\u0011AQ\u0001G\u0001k-)!\u0002Br\u00011\u0017\t#!B\u0001\t\u0006E\u001b1\u0001b\u0003\n\u0003\u0011\u0001\u0001"})
public final class KotlinCopyPasteReferenceProcessor
extends CopyPastePostProcessor<KotlinReferenceTransferableData> {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static Collection<? extends String> declarationsToImportSuggested;
    private final Logger LOG = Logger.getInstance(KotlinCopyPasteReferenceProcessor.class);
    private final Class<? extends JetElement>[] IGNORE_REFERENCES_INSIDE;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinCopyPasteReferenceProcessor.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.idea.codeInsight.KotlinCopyPasteReferenceProcessor$Companion.access$init$0();
        declarationsToImportSuggested = KotlinPackage.emptyList();
    }

    @NotNull
    public List<KotlinReferenceTransferableData> extractTransferableData(@JetValueParameter(name="content") @NotNull Transferable content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE != CodeInsightSettings.NO) {
            try {
                DataFlavor dataFlavor2 = KotlinReferenceData.Companion.getDataFlavor();
                if (dataFlavor2 == null) {
                    return KotlinPackage.listOf();
                }
                DataFlavor flavor = dataFlavor2;
                Object object = content2.getTransferData(flavor);
                if (!(object instanceof KotlinReferenceTransferableData)) {
                    object = null;
                }
                KotlinReferenceTransferableData kotlinReferenceTransferableData = (KotlinReferenceTransferableData)object;
                if (kotlinReferenceTransferableData == null) {
                    return KotlinPackage.listOf();
                }
                KotlinReferenceTransferableData data2 = kotlinReferenceTransferableData;
                return KotlinPackage.listOf((Object)data2.clone());
            }
            catch (UnsupportedFlavorException ignored) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return KotlinPackage.listOf();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<KotlinReferenceTransferableData> collectTransferableData(@JetValueParameter(name="file") @NotNull PsiFile file, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="startOffsets") @NotNull int[] startOffsets, @JetValueParameter(name="endOffsets") @NotNull int[] endOffsets) {
        void $receiver;
        void $receiver2;
        KotlinReferenceTransferableData kotlinReferenceTransferableData;
        Collection<KotlinReferenceData> collection;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
        if (!(file instanceof JetFile) || DumbService.getInstance((Project)((JetFile)file).getProject()).isDumb()) {
            return KotlinPackage.listOf();
        }
        try {
            collection = this.collectReferenceData((JetFile)file, startOffsets, endOffsets);
        }
        catch (ProcessCanceledException e) {
            this.LOG.error("ProcessCanceledException while analyzing references in " + ((JetFile)file).getName() + ". References can't be processed.");
            return KotlinPackage.listOf();
        }
        catch (Throwable e) {
            this.LOG.error("Exception in processing references for copy paste in file " + ((JetFile)file).getName() + "}", e);
            return KotlinPackage.listOf();
        }
        List<KotlinReferenceData> collectedData = collection;
        if (collectedData.isEmpty()) {
            return KotlinPackage.listOf();
        }
        collection = collectedData;
        KotlinReferenceTransferableData kotlinReferenceTransferableData2 = kotlinReferenceTransferableData;
        KotlinReferenceTransferableData kotlinReferenceTransferableData3 = kotlinReferenceTransferableData;
        void e = $receiver2;
        void v1 = $receiver;
        if (v1 == null) {
            throw new TypeCastException("kotlin.Collection<T> cannot be cast to java.util.Collection<T>");
        }
        Collection thisCollection = (Collection)v1;
        KotlinReferenceData[] kotlinReferenceDataArray = thisCollection.toArray(new KotlinReferenceData[thisCollection.size()]);
        if (kotlinReferenceDataArray == null) {
            throw new TypeCastException("kotlin.Array<(out) T?>! cannot be cast to kotlin.Array<T>");
        }
        Object[] objectArray = kotlinReferenceDataArray;
        kotlinReferenceTransferableData2((KotlinReferenceData[])objectArray);
        return KotlinPackage.listOf((Object)kotlinReferenceTransferableData3);
    }

    @NotNull
    public final List<KotlinReferenceData> collectReferenceData(@JetValueParameter(name="file") @NotNull JetFile file, @JetValueParameter(name="startOffsets") @NotNull int[] startOffsets, @JetValueParameter(name="endOffsets") @NotNull int[] endOffsets) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
        ArrayList result2 = new ArrayList();
        for (TextRange range : this.toTextRanges(startOffsets, endOffsets)) {
            for (PsiElement element : PsiUtilPackage.elementsInRange((PsiFile)file, range)) {
                this.addReferenceDataInsideElement(result2, element, file, CopyPackage$RangeUtils$e5cefcfb.getStart(range), startOffsets, endOffsets);
            }
        }
        return result2;
    }

    private final void addReferenceDataInsideElement(@JetValueParameter(name="$receiver") Collection<KotlinReferenceData> $receiver, @JetValueParameter(name="element") PsiElement element, @JetValueParameter(name="file") JetFile file, @JetValueParameter(name="startOffset") int startOffset, @JetValueParameter(name="startOffsets") int[] startOffsets, @JetValueParameter(name="endOffsets") int[] endOffsets) {
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])this.IGNORE_REFERENCES_INSIDE) != null) {
            return;
        }
        element.accept(new PsiElementVisitor(this, $receiver, file, startOffsets, endOffsets, startOffset){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ KotlinCopyPasteReferenceProcessor this$0;
            final /* synthetic */ Collection receiver$0;
            final /* synthetic */ JetFile $file;
            final /* synthetic */ int[] $startOffsets;
            final /* synthetic */ int[] $endOffsets;
            final /* synthetic */ int $startOffset;

            static {
                $kotlinClass = Reflection.createKotlinClass(addReferenceDataInsideElement.1.class);
            }

            public void visitElement(@JetValueParameter(name="element") @NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (KotlinPackage.contains((Object[])KotlinCopyPasteReferenceProcessor.access$getIGNORE_REFERENCES_INSIDE$0(this.this$0), element.getClass())) {
                    return;
                }
                element.acceptChildren((PsiElementVisitor)this);
                PsiReference psiReference = element.getReference();
                if (!(psiReference instanceof JetReference)) {
                    psiReference = null;
                }
                JetReference jetReference = (JetReference)psiReference;
                if (jetReference == null) {
                    return;
                }
                JetReference reference = jetReference;
                PsiElement psiElement = element;
                if (psiElement == null) {
                    throw new TypeCastException("com.intellij.psi.PsiElement cannot be cast to org.jetbrains.kotlin.psi.JetElement");
                }
                Collection<DeclarationDescriptor> descriptors = reference.resolveToDescriptors(ResolvePackage.analyze$default((JetElement)psiElement, null, 1));
                if (!(reference instanceof JetMultiReference) && descriptors.size() > 1) {
                    return;
                }
                for (DeclarationDescriptor descriptor2 : descriptors) {
                    KotlinReferenceData.Kind kind2;
                    FqName fqName2;
                    Project project = this.$file.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                    Collection<PsiElement> declarations2 = DescriptorToSourceUtilsIde.INSTANCE$.getAllDeclarations(project, descriptor2);
                    PsiElement declaration = (PsiElement)KotlinPackage.singleOrNull((Iterable)declarations2);
                    if (declaration != null && KotlinCopyPasteReferenceProcessor.access$isInCopiedArea$1(this.this$0, declaration, this.$file, this.$startOffsets, this.$endOffsets) || !DescriptorUtilPackage.getIsExtension(descriptor2) && (!(element instanceof JetNameReferenceExpression) || ((JetNameReferenceExpression)element).getIdentifier() == null || PsiUtilPackage.getReceiverExpression((JetSimpleNameExpression)element) != null)) continue;
                    if (ImportsPackage.getImportableFqName(descriptor2) == null) {
                        continue;
                    }
                    if (!ImportsPackage.canBeReferencedViaImport(descriptor2)) continue;
                    if (KotlinReferenceData.Kind.Companion.fromDescriptor(descriptor2) == null) {
                        continue;
                    }
                    int n = CopyPackage$RangeUtils$e5cefcfb.getStart(CopyPackage$RangeUtils$e5cefcfb.getRange(element)) - this.$startOffset;
                    int n2 = CopyPackage$RangeUtils$e5cefcfb.getEnd(CopyPackage$RangeUtils$e5cefcfb.getRange(element)) - this.$startOffset;
                    String string = fqName2.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.asString()");
                    this.receiver$0.add(new KotlinReferenceData(n, n2, string, kind2));
                }
            }
            {
                this.this$0 = $outer;
                this.receiver$0 = $receiver;
                this.$file = $captured_local_variable$2;
                this.$startOffsets = $captured_local_variable$3;
                this.$endOffsets = $captured_local_variable$4;
                this.$startOffset = $captured_local_variable$5;
            }
        });
    }

    public void processTransferableData(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="bounds") @NotNull RangeMarker bounds, @JetValueParameter(name="caretOffset") int caretOffset, @JetValueParameter(name="indented") @NotNull Ref<Boolean> indented, @JetValueParameter(name="values") @NotNull List<? extends KotlinReferenceTransferableData> values2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Intrinsics.checkParameterIsNotNull(indented, (String)"indented");
        Intrinsics.checkParameterIsNotNull(values2, (String)"values");
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!(file instanceof JetFile)) {
            return;
        }
        KotlinReferenceData[] referenceData = ((KotlinReferenceTransferableData)KotlinPackage.single(values2)).getData();
        JetFile jetFile = (JetFile)file;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetFile, (String)"file");
        this.processReferenceData(project, jetFile, bounds.getStartOffset(), referenceData);
    }

    public final void processReferenceData(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="file") @NotNull JetFile file, @JetValueParameter(name="blockStart") int blockStart, @JetValueParameter(name="referenceData") @NotNull KotlinReferenceData[] referenceData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)referenceData, (String)"referenceData");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        List<ReferenceToRestoreData> referencesPossibleToRestore = this.findReferencesToRestore((PsiFile)file, blockStart, referenceData);
        Collection<ReferenceToRestoreData> selectedReferencesToRestore = this.showRestoreReferencesDialog(project, referencesPossibleToRestore);
        if (selectedReferencesToRestore.isEmpty()) {
            return;
        }
        ApplicationPackage.runWriteAction((Function0)new Function0<Unit>(this, selectedReferencesToRestore, file){
            final /* synthetic */ KotlinCopyPasteReferenceProcessor this$0;
            final /* synthetic */ Collection $selectedReferencesToRestore;
            final /* synthetic */ JetFile $file;

            public final void invoke() {
                KotlinCopyPasteReferenceProcessor.access$restoreReferences$2(this.this$0, this.$selectedReferencesToRestore, this.$file);
            }
            {
                this.this$0 = kotlinCopyPasteReferenceProcessor;
                this.$selectedReferencesToRestore = collection;
                this.$file = jetFile;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReferenceToRestoreData> findReferencesToRestore(@JetValueParameter(name="file") PsiFile file, @JetValueParameter(name="blockStart") int blockStart, @JetValueParameter(name="referenceData") KotlinReferenceData[] referenceData) {
        void destination;
        void $receiver;
        void $receiver2;
        if (!(file instanceof JetFile)) {
            return KotlinPackage.listOf();
        }
        JetScope fileResolutionScope = ResolvePackage.getResolutionFacade((JetElement)file).getFileTopLevelScope((JetFile)file);
        Object[] objectArray = referenceData;
        void var6_6 = $receiver2;
        Collection collection = new ArrayList(((void)$receiver2).length);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it;
            void item = $receiver[i];
            KotlinReferenceData kotlinReferenceData = (KotlinReferenceData)item;
            void var12_12 = destination;
            JetElement referenceElement = this.findReference((KotlinReferenceData)it, (JetFile)file, blockStart);
            ReferenceToRestoreData referenceToRestoreData = referenceElement != null ? this.createReferenceToRestoreData(referenceElement, (KotlinReferenceData)it, (JetFile)file, fileResolutionScope) : (ReferenceToRestoreData)null;
            var12_12.add(referenceToRestoreData);
        }
        return KotlinPackage.filterNotNull((Iterable)((List)destination));
    }

    private final JetElement findReference(@JetValueParameter(name="data") KotlinReferenceData data2, @JetValueParameter(name="file") JetFile file, @JetValueParameter(name="blockStart") int blockStart) {
        int startOffset = data2.getStartOffset() + blockStart;
        int endOffset = data2.getEndOffset() + blockStart;
        PsiElement element = file.findElementAt(startOffset);
        TextRange desiredRange = new TextRange(startOffset, endOffset);
        PsiElement expression2 = element;
        while (expression2 != null) {
            TextRange range;
            PsiElement psiElement = expression2;
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)(range = CopyPackage$RangeUtils$e5cefcfb.getRange(psiElement)), (Object)desiredRange)) {
                PsiElement psiElement2 = expression2;
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                if (psiElement2.getReference() != null) {
                    PsiElement psiElement3 = expression2;
                    if (!(psiElement3 instanceof JetElement)) {
                        psiElement3 = null;
                    }
                    return (JetElement)psiElement3;
                }
            }
            if (desiredRange.contains(range)) {
                PsiElement psiElement4 = expression2;
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                expression2 = psiElement4.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    private final ReferenceToRestoreData createReferenceToRestoreData(@JetValueParameter(name="element") JetElement element, @JetValueParameter(name="refData") KotlinReferenceData refData, @JetValueParameter(name="file") JetFile file, @JetValueParameter(name="fileResolutionScope") JetScope fileResolutionScope) {
        boolean bl;
        JetReference reference;
        block18: {
            Collection destination;
            DeclarationDescriptor it;
            Iterable $receiver;
            Iterable $receiver2;
            PsiReference psiReference;
            CallableDescriptor it2;
            Object element22;
            Iterable $receiver3;
            FqName originalFqName = new FqName(refData.getFqName());
            if (Intrinsics.areEqual((Object)((Object)refData.getKind()), (Object)((Object)KotlinReferenceData.Kind.EXTENSION_FUNCTION))) {
                boolean bl2;
                block16: {
                    Name name2 = originalFqName.shortName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"originalFqName.shortName()");
                    Iterable iterable = fileResolutionScope.getFunctions(name2);
                    for (Object element22 : $receiver3) {
                        it2 = (FunctionDescriptor)element22;
                        if (!Intrinsics.areEqual((Object)ImportsPackage.getImportableFqName(it2), (Object)originalFqName)) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return null;
                }
            } else if (Intrinsics.areEqual((Object)((Object)refData.getKind()), (Object)((Object)KotlinReferenceData.Kind.EXTENSION_PROPERTY))) {
                boolean bl3;
                block17: {
                    Name name3 = originalFqName.shortName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"originalFqName.shortName()");
                    $receiver3 = fileResolutionScope.getProperties(name3);
                    for (Object element22 : $receiver3) {
                        it2 = (VariableDescriptor)element22;
                        if (!Intrinsics.areEqual((Object)ImportsPackage.getImportableFqName(it2), (Object)originalFqName)) continue;
                        bl3 = true;
                        break block17;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    return null;
                }
            }
            if (!((psiReference = element.getReference()) instanceof JetReference)) {
                psiReference = null;
            }
            JetReference jetReference = (JetReference)psiReference;
            if (jetReference == null) {
                return null;
            }
            reference = jetReference;
            try {
                element22 = reference.resolveToDescriptors(ResolvePackage.analyze$default(element, null, 1));
            }
            catch (Throwable e) {
                this.LOG.error("Failed to analyze reference (" + element.getText() + ") after copy paste", e);
                return null;
            }
            Object referencedDescriptors = element22;
            Iterable e = (Iterable)referencedDescriptors;
            Iterator iterator2 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element3 : $receiver) {
                it = (DeclarationDescriptor)element3;
                if (ErrorUtils.isError(it)) continue;
                destination.add(element3);
            }
            $receiver2 = (List)destination;
            $receiver = $receiver2;
            destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                it = (DeclarationDescriptor)item;
                Collection collection2 = destination;
                FqName fqName2 = ImportsPackage.getImportableFqName(it);
                collection2.add(fqName2);
            }
            Set referencedFqNames = KotlinPackage.toSet((Iterable)KotlinPackage.filterNotNull((Iterable)((List)destination)));
            if (Intrinsics.areEqual((Object)((FqName)KotlinPackage.singleOrNull((Iterable)referencedFqNames)), (Object)originalFqName)) {
                return null;
            }
            $receiver2 = this.findImportableDescriptors(originalFqName, file);
            for (Object element4 : $receiver2) {
                DeclarationDescriptor it3 = (DeclarationDescriptor)element4;
                if (!Intrinsics.areEqual((Object)((Object)KotlinReferenceData.Kind.Companion.fromDescriptor(it3)), (Object)((Object)refData.getKind()))) continue;
                bl = false;
                break block18;
            }
            bl = true;
        }
        if (bl) {
            return null;
        }
        return new ReferenceToRestoreData(reference, refData);
    }

    private final void restoreReferences(@JetValueParameter(name="referencesToRestore") Collection<? extends ReferenceToRestoreData> referencesToRestore, @JetValueParameter(name="file") JetFile file) {
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
        ImportInsertHelper importHelper = ImportInsertHelper.Companion.getInstance(project);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)file.getProject());
        @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.LOCAL_CLASS, data={"\u0016\u0006)\u00115j\u001c;mS:\u001cu\u000e]=QCN$XMU3gKJ,gnY3Qe>\u001cWm]:pe\u0012\u0012Xm\u001d;pe\u0016\u0014VMZ3sK:\u001cWm\u001d\u0013CS:$\u0017N\\4SKF,Xm\u001d;\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000fA|\u0017N\u001c;fe*12+\\1siB\u001b\u0018.\u00127f[\u0016tG\u000fU8j]R,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0004aNL'b\u0006&fiNKW\u000e\u001d7f\u001d\u0006lW-\u0012=qe\u0016\u001c8/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaAZ9OC6,'B\u0002$r\u001d\u0006lWM\u0003\u0003oC6,'\"C4fi\u001a\u000bh*Y7f\u0015)9W\r\u001e)pS:$XM\u001d\u0006\u000bG>l\u0007o\u001c8f]R\f$BC2p[B|g.\u001a8ue)!1m\u001c9z\u0015\u0011IG-Z1\u000b\u0017\r|G-Z%og&<\u0007\u000e\u001e;\u000b\tA\u0001\u0001D\u0001\u0006\u0003!\tQa\u0001C\u0001\u0011\u0003a\u0001!B\u0001\t\u0007\u0015\u0011A1\u0001E\u0004\u000b\t!!\u0001\u0003\u0003\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\b!-QA\u0001\u0003\u0005\u0011\u0005)!\u0001\"\u0003\t\t\u0015\u0019A!\u0002E\u0005\u0019\u0001)!\u0001\"\u0003\t\u000f\u0015\u0019AA\u0002E\u0007\u0019\u0001)!\u0001\"\u0002\t\u0006\u0015\u0011AA\u0002E\u0007\u000b\t!I\u0001\u0003\u0006\u0006\u0005\u0011A\u0001RC\u0003\u0003\t#A\u0001\u0001b\u0003\r\u0001e\u0011Q!\u0001\u0005\u0002[=!\u0001\r\u0002\r\u0007C\t)\u0011\u0001#\u0004V\u0007!)1\u0001\u0002\u0004\n\u0003!=Qb\u0001C\b\u0013\u0005Ay!L\n\u0005A\u0012A\"!\t\u0004\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005AY!V\u0002\t\u000b\r!!!C\u0001\t\u000f5\u0019A\u0001C\u0005\u0002\u0011\u001dic\u0002\u0002!\u00041#\tc!B\u0001\t\u0007%\u0019\u0011BA\u0003\u0002\u0011\u0017\t6a\u0001C\t\u0013\u0005Aq!\f\u0006\u0005\u0001\u000eA\u0012\"\t\u0002\u0006\u0003!5\u0011kA\u0002\u0005\u0013%\t\u0001rB\u0017\"\t\r\u001b\u00014CO\u000b\t\u0005A!!\u0004\u0004\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005AY\u0001U\u0002\u0001;\u001b!\u0011\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0001#\u000e9A1C\u0005\u0002\u0011%i\u0011\u0001C\u0004\u000e\u0003!=QGI\u0003\"\t\r\b\u00014AO\u000b\t\u0001A!!\u0004\u0004\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005AY\u0001U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0001#\u000e9A1A\u0005\u0002\t\u0001i\u0011\u0001C\u0004\u000e\u0003!=\u0001"})
        @data
        public final class BindingRequest {
            public static final /* synthetic */ KClass $kotlinClass;
            @NotNull
            private final SmartPsiElementPointer<JetSimpleNameExpression> pointer;
            @NotNull
            private final FqName fqName;

            static {
                $kotlinClass = Reflection.createKotlinClass(BindingRequest.class);
            }

            @NotNull
            public final SmartPsiElementPointer<JetSimpleNameExpression> getPointer() {
                return this.pointer;
            }

            @NotNull
            public final FqName getFqName() {
                return this.fqName;
            }

            public BindingRequest(@JetValueParameter(name="pointer") @NotNull SmartPsiElementPointer<JetSimpleNameExpression> pointer, @JetValueParameter(name="fqName") @NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull(pointer, (String)"pointer");
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                this.pointer = pointer;
                this.fqName = fqName2;
            }

            @NotNull
            public final SmartPsiElementPointer<JetSimpleNameExpression> component1() {
                return this.pointer;
            }

            @NotNull
            public final FqName component2() {
                return this.fqName;
            }

            @NotNull
            public final BindingRequest copy(@JetValueParameter(name="pointer") @NotNull SmartPsiElementPointer<JetSimpleNameExpression> pointer, @JetValueParameter(name="fqName") @NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull(pointer, (String)"pointer");
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                return new BindingRequest(pointer, fqName2);
            }

            @NotNull
            public static /* synthetic */ BindingRequest copy$default(BindingRequest bindingRequest, SmartPsiElementPointer smartPsiElementPointer, FqName fqName2, int n) {
                if ((n & 1) != 0) {
                    smartPsiElementPointer = bindingRequest.pointer;
                }
                if ((n & 2) != 0) {
                    fqName2 = bindingRequest.fqName;
                }
                return bindingRequest.copy(smartPsiElementPointer, fqName2);
            }

            public String toString() {
                return "BindingRequest(pointer=" + this.pointer + ", fqName=" + this.fqName + ")";
            }

            public int hashCode() {
                SmartPsiElementPointer<JetSimpleNameExpression> smartPsiElementPointer = this.pointer;
                FqName fqName2 = this.fqName;
                return (smartPsiElementPointer != null ? smartPsiElementPointer.hashCode() : 0) * 31 + (fqName2 != null ? ((Object)fqName2).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof BindingRequest)) break block3;
                        BindingRequest bindingRequest = (BindingRequest)object;
                        if (!Intrinsics.areEqual(this.pointer, bindingRequest.pointer) || !Intrinsics.areEqual((Object)this.fqName, (Object)bindingRequest.fqName)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        ArrayList<BindingRequest> bindingRequests = new ArrayList<BindingRequest>();
        ArrayList extensionsToImport = new ArrayList();
        for (ReferenceToRestoreData object : referencesToRestore) {
            JetReference reference = object.component1();
            KotlinReferenceData refData = object.component2();
            FqName fqName2 = new FqName(refData.getFqName());
            if (!this.isExtension(refData.getKind()) && reference instanceof JetSimpleNameReference) {
                SmartPsiElementPointer pointer;
                SmartPsiElementPointer smartPsiElementPointer = pointer = smartPointerManager.createSmartPsiElementPointer(((JetSimpleNameReference)reference).getElement(), (PsiFile)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"pointer");
                bindingRequests.add(new BindingRequest((SmartPsiElementPointer<JetSimpleNameExpression>)smartPsiElementPointer, fqName2));
            }
            if (!this.isExtension(refData.getKind())) continue;
            UtilsPackage.addIfNotNull(extensionsToImport, this.findCallableToImport(fqName2, file));
        }
        for (CallableDescriptor callableDescriptor : extensionsToImport) {
            DeclarationDescriptor declarationDescriptor = callableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
            importHelper.importDescriptor(file, declarationDescriptor);
        }
        for (BindingRequest bindingRequest : bindingRequests) {
            SmartPsiElementPointer<JetSimpleNameExpression> pointer = bindingRequest.component1();
            FqName fqName3 = bindingRequest.component2();
            PsiReference psiReference = ((JetSimpleNameExpression)pointer.getElement()).getReference();
            if (psiReference == null) {
                throw new TypeCastException("com.intellij.psi.PsiReference! cannot be cast to org.jetbrains.kotlin.idea.references.JetSimpleNameReference");
            }
            JetSimpleNameReference reference = (JetSimpleNameReference)psiReference;
            reference.bindToFqName(fqName3, JetSimpleNameReference.ShorteningMode.DELAYED_SHORTENING);
        }
        Project project2 = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.getProject()");
        ShortenPackage.performDelayedShortening(project2);
    }

    private final boolean isExtension(@JetValueParameter(name="$receiver") KotlinReferenceData.Kind $receiver) {
        return Intrinsics.areEqual((Object)((Object)$receiver), (Object)((Object)KotlinReferenceData.Kind.EXTENSION_FUNCTION)) || Intrinsics.areEqual((Object)((Object)$receiver), (Object)((Object)KotlinReferenceData.Kind.EXTENSION_PROPERTY));
    }

    private final Collection<DeclarationDescriptor> findImportableDescriptors(@JetValueParameter(name="fqName") FqName fqName2, @JetValueParameter(name="file") JetFile file) {
        return ResolvePackage.getResolutionFacade(file).resolveImportReference(file, fqName2, true);
    }

    private final CallableDescriptor findCallableToImport(@JetValueParameter(name="fqName") FqName fqName2, @JetValueParameter(name="file") JetFile file) {
        Object v0;
        block1: {
            Iterable $receiver = this.findImportableDescriptors(fqName2, file);
            for (Object element : $receiver) {
                if (!(element instanceof CallableDescriptor)) continue;
                v0 = element;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ReferenceToRestoreData> showRestoreReferencesDialog(@JetValueParameter(name="project") Project project, @JetValueParameter(name="referencesToRestore") List<? extends ReferenceToRestoreData> referencesToRestore) {
        void destination;
        void $receiver;
        Iterable $receiver2;
        void $receiver3;
        RestoreReferencesDialog restoreReferencesDialog;
        boolean shouldShowDialog;
        Object object;
        Collection it;
        Project project2;
        Collection destination2;
        void $receiver4;
        void $receiver5;
        Iterable iterable = referencesToRestore;
        void var5_5 = $receiver5;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver5, (int)10));
        for (Object item : $receiver4) {
            ReferenceToRestoreData referenceToRestoreData = (ReferenceToRestoreData)item;
            project2 = destination2;
            object = ((ReferenceToRestoreData)((Object)it)).getRefData().getFqName();
            project2.add(object);
        }
        SortedSet fqNames = KotlinPackage.toSortedSet((Iterable)((List)destination2));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Companion.setDeclarationsToImportSuggested(fqNames);
        }
        boolean bl = shouldShowDialog = CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == CodeInsightSettings.ASK;
        if (!shouldShowDialog || referencesToRestore.isEmpty()) {
            return referencesToRestore;
        }
        destination2 = fqNames;
        project2 = project;
        object = restoreReferencesDialog;
        RestoreReferencesDialog restoreReferencesDialog2 = restoreReferencesDialog;
        Iterator iterator2 = $receiver3;
        void v2 = $receiver2;
        if (v2 == null) {
            throw new TypeCastException("kotlin.Collection<T> cannot be cast to java.util.Collection<T>");
        }
        Iterable thisCollection = (Collection)v2;
        String[] stringArray = thisCollection.toArray(new String[thisCollection.size()]);
        if (stringArray == null) {
            throw new TypeCastException("kotlin.Array<(out) T?>! cannot be cast to kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        ((RestoreReferencesDialog)((Object)object))(project2, objectArray);
        RestoreReferencesDialog dialog2 = restoreReferencesDialog2;
        dialog2.show();
        Object[] objectArray2 = dialog2.getSelectedElements();
        if (objectArray2 == null) {
            Intrinsics.throwNpe();
        }
        Set selectedFqNames = KotlinPackage.toSet((Object[])objectArray2);
        $receiver2 = referencesToRestore;
        thisCollection = $receiver2;
        it = new ArrayList();
        for (Object element : $receiver) {
            ReferenceToRestoreData it2 = (ReferenceToRestoreData)element;
            if (!selectedFqNames.contains(it2.getRefData().getFqName())) continue;
            destination.add(element);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> toTextRanges(@JetValueParameter(name="startOffsets") int[] startOffsets, @JetValueParameter(name="endOffsets") int[] endOffsets) {
        void destination;
        void $receiver;
        KotlinPackage.assert$default((startOffsets.length == endOffsets.length ? 1 : 0) != 0, null, (int)2);
        Iterable $receiver2 = (Iterable)KotlinPackage.getIndices((int[])startOffsets);
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            int n = ((Number)item).intValue();
            void var9_9 = destination;
            TextRange textRange = new TextRange(startOffsets[it], endOffsets[it]);
            var9_9.add(textRange);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInCopiedArea(@JetValueParameter(name="$receiver") PsiElement $receiver, @JetValueParameter(name="fileCopiedFrom") JetFile fileCopiedFrom, @JetValueParameter(name="startOffsets") int[] startOffsets, @JetValueParameter(name="endOffsets") int[] endOffsets) {
        boolean bl;
        block2: {
            void $receiver2;
            if (Intrinsics.areEqual((Object)$receiver.getContainingFile(), (Object)fileCopiedFrom) ^ true) {
                return false;
            }
            Iterable iterable = this.toTextRanges(startOffsets, endOffsets);
            for (Object element : $receiver2) {
                TextRange it = (TextRange)element;
                if (!it.contains(CopyPackage$RangeUtils$e5cefcfb.getRange($receiver))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public KotlinCopyPasteReferenceProcessor() {
        Class[] classArray = new Class[]{JetImportList.class, JetPackageDirective.class};
        KotlinCopyPasteReferenceProcessor kotlinCopyPasteReferenceProcessor = this;
        Class[] classArray2 = classArray;
        kotlinCopyPasteReferenceProcessor.IGNORE_REFERENCES_INSIDE = classArray2;
    }

    @NotNull
    public static final /* synthetic */ Class<? extends JetElement>[] access$getIGNORE_REFERENCES_INSIDE$0(@JetValueParameter(name="$this", type="?") KotlinCopyPasteReferenceProcessor $this) {
        return $this.IGNORE_REFERENCES_INSIDE;
    }

    public static final /* synthetic */ boolean access$isInCopiedArea$1(@JetValueParameter(name="$this", type="?") KotlinCopyPasteReferenceProcessor $this, @JetValueParameter(name="$receiver") PsiElement $receiver, @JetValueParameter(name="fileCopiedFrom") @NotNull JetFile fileCopiedFrom, @JetValueParameter(name="startOffsets") @NotNull int[] startOffsets, @JetValueParameter(name="endOffsets") @NotNull int[] endOffsets) {
        return $this.isInCopiedArea($receiver, fileCopiedFrom, startOffsets, endOffsets);
    }

    public static final /* synthetic */ void access$restoreReferences$2(@JetValueParameter(name="$this", type="?") KotlinCopyPasteReferenceProcessor $this, @JetValueParameter(name="referencesToRestore") @NotNull Collection<? extends ReferenceToRestoreData> referencesToRestore, @JetValueParameter(name="file") @NotNull JetFile file) {
        $this.restoreReferences(referencesToRestore, file);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={")\u0006)1\"+\u001a4fe\u0016t7-\u001a+p%\u0016\u001cHo\u001c:f\t\u0006$\u0018MC\u0011L_Rd\u0017N\\\"paf\u0004\u0016m\u001d;f%\u00164WM]3oG\u0016\u0004&o\\2fgN|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0017\r|G-Z%og&<\u0007\u000e\u001e\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0005sK\u001a,'/\u001a8dK*a!*\u001a;SK\u001a,'/\u001a8dK*Q!/\u001a4fe\u0016t7-Z:\u000b\u000fI,g\rR1uC*\u00192j\u001c;mS:\u0014VMZ3sK:\u001cW\rR1uC*Qq-\u001a;SK\u001a$\u0015\r^1\u000b\u0019\u001d,GOU3gKJ,gnY3\u000b\u0015\r|W\u000e]8oK:$\u0018G\u0003\u0006d_6\u0004xN\\3oiJRAaY8qs*A4j\u001c;mS:\u001cu\u000e]=QCN$XMU3gKJ,gnY3Qe>\u001cWm]:pe\u0012\u0012VMZ3sK:\u001cW\rV8SKN$xN]3ECR\f\u0007M\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0003\t\u0007AY!B\u0002\u0005\n!)A\u0002A\u0003\u0004\t\tAi\u0001\u0004\u0001\u0006\u0005\u0011%\u0001\"B\u0003\u0003\t\tAi!\u0002\u0002\u0005\u0005!MA1\u0001\u0007\u00043\t)\u0011\u0001\u0003\u0003.\u001f\u0011\u0001G\u0001\u0007\u0004\"\u0005\u0015\t\u00012B+\u0004\u0011\u0015\u0019AAB\u0005\u0002\u0011\u001bi1\u0001B\u0004\n\u0003!5Qf\u0004\u0003a\ta%\u0011EA\u0003\u0002\u0011\u0015)6\u0001C\u0003\u0004\t\u0013I\u0011\u0001\u0003\u0004\u000e\u0007\u0011=\u0011\"\u0001\u0005\u0007[)!\u0001i\u0001\r\tC\t)\u0011\u0001C\u0003R\u0007\r!\u0001\"C\u0001\t\r5RA\u0001Q\u0002\u0019\u0012\u0005\u0012Q!\u0001E\u0006#\u000e\u0019A\u0011C\u0005\u0002\u0011\u001biS\u0004B\"\u00041%ij\u0001B\u0001\t\n5\u0011Q!\u0001\u0005\u0006!\u000e\u0001QT\u0002\u0003\u0002\u0011\u0019i!!B\u0001\t\fA\u001b\t!\t\u0002\u0006\u0003!\u0019\u0011kA\u0004\u0005\u0013%\t\u0001bB\u0007\u0002\u0011\u0019i\u0011\u0001#\u00046=\u0015iBa9\u0001\u0019\tu5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001C\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\r5\u0011Q!\u0001E\u0006!\u000e\u0005\u0011EA\u0003\u0002\u0011\r\t6a\u0002\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\r5\t\u0001R\u0002"})
    @data
    private static final class ReferenceToRestoreData {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final JetReference reference;
        @NotNull
        private final KotlinReferenceData refData;

        static {
            $kotlinClass = Reflection.createKotlinClass(ReferenceToRestoreData.class);
        }

        @NotNull
        public final JetReference getReference() {
            return this.reference;
        }

        @NotNull
        public final KotlinReferenceData getRefData() {
            return this.refData;
        }

        public ReferenceToRestoreData(@JetValueParameter(name="reference") @NotNull JetReference reference, @JetValueParameter(name="refData") @NotNull KotlinReferenceData refData) {
            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            Intrinsics.checkParameterIsNotNull((Object)refData, (String)"refData");
            this.reference = reference;
            this.refData = refData;
        }

        @NotNull
        public final JetReference component1() {
            return this.reference;
        }

        @NotNull
        public final KotlinReferenceData component2() {
            return this.refData;
        }

        @NotNull
        public final ReferenceToRestoreData copy(@JetValueParameter(name="reference") @NotNull JetReference reference, @JetValueParameter(name="refData") @NotNull KotlinReferenceData refData) {
            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            Intrinsics.checkParameterIsNotNull((Object)refData, (String)"refData");
            return new ReferenceToRestoreData(reference, refData);
        }

        @NotNull
        public static /* synthetic */ ReferenceToRestoreData copy$default(ReferenceToRestoreData referenceToRestoreData, JetReference jetReference, KotlinReferenceData kotlinReferenceData, int n) {
            if ((n & 1) != 0) {
                jetReference = referenceToRestoreData.reference;
            }
            if ((n & 2) != 0) {
                kotlinReferenceData = referenceToRestoreData.refData;
            }
            return referenceToRestoreData.copy(jetReference, kotlinReferenceData);
        }

        public String toString() {
            return "ReferenceToRestoreData(reference=" + this.reference + ", refData=" + this.refData + ")";
        }

        public int hashCode() {
            JetReference jetReference = this.reference;
            KotlinReferenceData kotlinReferenceData = this.refData;
            return (jetReference != null ? jetReference.hashCode() : 0) * 31 + (kotlinReferenceData != null ? kotlinReferenceData.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReferenceToRestoreData)) break block3;
                    ReferenceToRestoreData referenceToRestoreData = (ReferenceToRestoreData)object;
                    if (!Intrinsics.areEqual((Object)this.reference, (Object)referenceToRestoreData.reference) || !Intrinsics.areEqual((Object)this.refData, (Object)referenceToRestoreData.refData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"b\u0004)I1i\\7qC:LwN\u001c\u0006\"\u0017>$H.\u001b8D_BL\b+Y:uKJ+g-\u001a:f]\u000e,\u0007K]8dKN\u001cxN\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015-\u0019w\u000eZ3J]NLw\r\u001b;\u000b\u0007\u0005s\u0017PC\u000feK\u000ed\u0017M]1uS>t7\u000fV8J[B|'\u000f^*vO\u001e,7\u000f^3e\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0011hKR$Um\u00197be\u0006$\u0018n\u001c8t)>LU\u000e]8siN+xmZ3ti\u0016$'\u0002I:fi\u0012+7\r\\1sCRLwN\\:U_&k\u0007o\u001c:u'V<w-Z:uK\u0012D&B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\b!%A\u0002A\u0003\u0004\t\u000fAQ\u0001\u0004\u0001\u0006\u0003!-QA\u0001C\u0006\u0011\u0019)!\u0001\u0002\u0004\t\n\u0011\u0019\u001d\u0001D\u0002\u001a\u0005\u0015\t\u0001\u0002B\u0017\u001d\t\u000fg\u0001\u0004B\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001\"\u0002\u0013\u0004Q\r)6aD\u0003\u0005\t\u0011I\u0011\u0001#\u0004\r\u00025\u0019AQB\u0005\u0002\u0011\u001b\tR\u0001B\u0004\n\u0003\u0011\u0001Q\"\u0001E\u0007k\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final Collection<String> getDeclarationsToImportSuggested() {
            return declarationsToImportSuggested;
        }

        public final void setDeclarationsToImportSuggested(@JetValueParameter(name="<set-?>") @NotNull Collection<? extends String> collection) {
            Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
            declarationsToImportSuggested = collection;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }
}

