/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.JetType;

public class KotlinWhenSurrounder
extends KotlinExpressionSurrounder {
    public String getTemplateDescription() {
        return JetBundle.message("surround.with.when.template", new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder", "isApplicable"));
        }
        return true;
    }

    @Override
    @Nullable
    public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull JetExpression expression2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder", "surroundExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder", "surroundExpression"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder", "surroundExpression"));
        }
        JetWhenExpression whenExpression2 = (JetWhenExpression)PsiPackage.JetPsiFactory((PsiElement)expression2).createExpression(this.getCodeTemplate(expression2));
        JetExpression subjectExpression = whenExpression2.getSubjectExpression();
        assert (subjectExpression != null) : "JetExpression should exists for " + whenExpression2.getText() + " expression";
        subjectExpression.replace((PsiElement)expression2);
        expression2 = (JetExpression)expression2.replace((PsiElement)whenExpression2);
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)expression2);
        JetWhenEntry whenEntry = ((JetWhenExpression)expression2).getEntries().get(0);
        JetWhenCondition whenEntryCondition = whenEntry.getConditions()[0];
        assert (whenEntryCondition != null) : "JetExpression for first entry should exists: " + expression2.getText();
        TextRange whenRange = whenEntryCondition.getTextRange();
        editor.getDocument().deleteString(whenRange.getStartOffset(), whenRange.getEndOffset());
        int offset = whenRange.getStartOffset();
        return new TextRange(offset, offset);
    }

    private String getCodeTemplate(JetExpression expression2) {
        ClassifierDescriptor descriptor2;
        JetType type2 = ResolvePackage.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (type2 != null && (descriptor2 = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
            return "when(a) { \nb -> {}\n}";
        }
        return "when(a) { \nb -> {}\n else -> {}\n}";
    }
}

