/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelper;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public abstract class KotlinIfSurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatements(Project project, Editor editor, PsiElement container2, PsiElement[] statements) {
        if ((statements = MoveDeclarationsOutHelper.move(container2, statements, this.isGenerateDefaultInitializers())).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor, KotlinSurrounderUtils.SURROUND_WITH_ERROR);
            return null;
        }
        JetIfExpression ifExpression2 = (JetIfExpression)PsiPackage.JetPsiFactory(project).createExpression(this.getCodeTemplate());
        ifExpression2 = (JetIfExpression)container2.addAfter((PsiElement)ifExpression2, statements[statements.length - 1]);
        JetBlockExpression thenBranch = (JetBlockExpression)ifExpression2.getThen();
        assert (thenBranch != null) : "Then branch should exist for created if expression: " + ifExpression2.getText();
        KotlinSurrounderUtils.addStatementsInBlock(thenBranch, statements);
        container2.deleteChildRange(statements[0], statements[statements.length - 1]);
        ifExpression2 = (JetIfExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)ifExpression2);
        JetExpression condition2 = ifExpression2.getCondition();
        assert (condition2 != null) : "Condition should exists for created if expression: " + ifExpression2.getText();
        TextRange range = condition2.getTextRange();
        TextRange textRange = new TextRange(range.getStartOffset(), range.getStartOffset());
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return textRange;
    }

    @NotNull
    protected abstract String getCodeTemplate();

    protected abstract boolean isGenerateDefaultInitializers();
}

