/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.google.common.collect.Sets;
import com.intellij.ProjectTopics;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.AbsentSdkAnnotationsNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.NotificationsPackage;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtil;

public class AbsentJdkAnnotationsComponent
extends AbstractProjectComponent {
    public static final String EXTERNAL_ANNOTATIONS_GROUP_ID = "Kotlin External annotations";
    private volatile Alarm notificationAlarm;

    protected AbsentJdkAnnotationsComponent(Project project) {
        super(project);
        NotificationsConfiguration.getNotificationsConfiguration().register(EXTERNAL_ANNOTATIONS_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
    }

    public void projectOpened() {
        super.projectOpened();
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        this.notificationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                AbsentJdkAnnotationsComponent.this.scheduleNotificationCheck();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                AbsentJdkAnnotationsComponent.this.scheduleNotificationCheck();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/idea/configuration/ui/AbsentJdkAnnotationsComponent$3", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent)) continue;
                    AbsentJdkAnnotationsComponent.this.scheduleNotificationCheck();
                    break;
                }
            }
        });
    }

    private void scheduleNotificationCheck() {
        if (this.notificationAlarm.isDisposed()) {
            return;
        }
        this.notificationAlarm.cancelAllRequests();
        this.notificationAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)AbsentJdkAnnotationsComponent.this.myProject).smartInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Collection sdks = AbsentJdkAnnotationsComponent.this.collectSdksWithoutAnnotations();
                        if (!sdks.isEmpty()) {
                            AbsentSdkAnnotationsNotificationManager.INSTANCE$.notify(AbsentJdkAnnotationsComponent.this.myProject, sdks);
                        }
                    }
                });
            }
        }, TimeUnit.SECONDS.toMillis(1L));
    }

    @NotNull
    private Collection<Sdk> collectSdksWithoutAnnotations() {
        HashSet sdks = Sets.newHashSet();
        for (Module module : ConfigureKotlinInProjectUtils.getModulesWithKotlinFiles(this.myProject)) {
            Sdk sdk;
            if (!ProjectStructureUtil.isJavaKotlinModule(module) || (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null || AbsentJdkAnnotationsComponent.areAnnotationsCorrect(sdk)) continue;
            sdks.add(sdk);
        }
        HashSet hashSet = sdks;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/ui/AbsentJdkAnnotationsComponent", "collectSdksWithoutAnnotations"));
        }
        return hashSet;
    }

    private static boolean areAnnotationsCorrect(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/configuration/ui/AbsentJdkAnnotationsComponent", "areAnnotationsCorrect"));
        }
        if (NotificationsPackage.isAndroidSdk(sdk)) {
            return KotlinRuntimeLibraryUtil.androidSdkAnnotationsArePresent(sdk) && !KotlinRuntimeLibraryUtil.jdkAnnotationsArePresent(sdk);
        }
        if (!AbsentJdkAnnotationsComponent.isAndroidStudio()) {
            return KotlinRuntimeLibraryUtil.jdkAnnotationsArePresent(sdk);
        }
        return true;
    }

    private static boolean isAndroidStudio() {
        return "AndroidStudio".equals(PlatformUtils.getPlatformPrefix());
    }
}

