/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;

public class NonConfiguredKotlinProjectComponent
extends AbstractProjectComponent {
    public static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";

    protected NonConfiguredKotlinProjectComponent(Project project) {
        super(project);
        NotificationsConfiguration.getNotificationsConfiguration().register(CONFIGURE_NOTIFICATION_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
    }

    public void projectOpened() {
        super.projectOpened();
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)NonConfiguredKotlinProjectComponent.this.myProject).smartInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConfigureKotlinInProjectUtils.showConfigureKotlinNotificationIfNeeded(NonConfiguredKotlinProjectComponent.this.myProject);
                    }
                });
            }
        });
    }
}

