/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.di.InjectorForMacros;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"Y\b))\u0012\n^3sC\ndW\rV=qKN$U\r^3di>\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\u0005G>\u0014XMC\u0002B]fTa\u0001P5oSRt$b\u00029s_*,7\r\u001e\u0006\b!J|'.Z2u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'\u0002E7pIVdW\rR3tGJL\u0007\u000f^8s\u0015Aiu\u000eZ;mK\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(\"B:d_B,'\u0002\u0003&fiN\u001bw\u000e]3\u000b\u000fI,7o\u001c7wK*11oY8qKNT1\u0002\\8paZ\u000b'\u000fV=qK*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(\"B2bG\",'b\u0002%bg\"l\u0015\r\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\"\u0003$vujLH+\u001f9f\u0015\u001d\u0011un\u001c7fC:T\u0001\"\u001b8kK\u000e$xN\u001d\u0006\u0012\u0013:TWm\u0019;pe\u001a{'/T1de>\u001c(B\u00013j\u00151IG/\u001a:bi>\u0014h*Y7f\u0015\u0011q\u0015-\\3\u000b\t9\fW.\u001a\u0006\b\u001d>$h*\u001e7m\u0015-\tgN\\8uCRLwN\\:\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'B\u0007;za\u0016\u001cx+\u001b;i\u000bb$XM\\:j_:LE/\u001a:bi>\u0014(BC\"pY2,7\r^5p]*i1-\u00198CK&#XM]1cY\u0016TA\u0001^=qK*Q\u0011n]%uKJ\f'\r\\3\u000b#%\u001c\u0018\n^3sC\ndWMT8DC\u000eDWM$\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u00012A\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0003!)QA\u0001\u0003\u0005\u0011\u0017)!\u0001\"\u0003\t\r\u0015\u0011A!\u0002\u0005\u0005\u000b\r!Y\u0001#\u0003\r\u0001\u0015\u0011A!\u0001E\b\u000b\r!i\u0001C\u0004\r\u0001\u0015\u0011A!\u0001\u0005\n\u000b\t!y\u0001c\u0005\u0006\u0007\u0011A\u0001\u0012\u0003\u0007\u0001\u000b\t!\u0011\u0001C\u0006\u0006\u0007\u0011I\u0001R\u0003\u0007\u0001\u000b\t!Y\u0001#\u0003\u0006\u0005\u00115\u0001bB\u0003\u0003\t!A\t\"\u0002\u0002\u0005\u0013!UQ!\u0001E\r\u000b\t!A\u0002C\u0007\u0006\u0007\u0011e\u0001\u0002\u0004\u0007\u0001\u000b\t!\u0019\u0001C\u0007\u0006\u0007\u0011m\u00012\u0004\u0007\u0001\u000b\r!1\u0001\u0003\b\r\u0001\u0015\u0011A\u0011\u0004\u0005\r\u000b\t!\u0011\u0001c\b\u0006\u0007\u0011}\u0001b\u0004\u0007\u0001\u000b\t!y\u0002C\b\u0006\u0005\u0011\t\u0001\"E\u0003\u0004\tEA\t\u0003\u0004\u0001\u0006\u0005\u0011\u0005\u0001BE\u0003\u0004\tIA\u0019\u0003\u0004\u0001\u0006\u0005\u0011\t\u0002\u0012E\u0003\u0004\t\rA9\u0003\u0004\u0001\u0006\u0005\u0011e\u0001rE\u0003\u0003\t7AY\u0002B\u0002\r\u0006e\u0011Q!\u0001E\u0004[M!\u0011\r\u0002M\fC))\u0011\u0001C\u0007\n\u0007%\u0011Q!\u0001\u0005\u000f\u0013\rI!!B\u0001\t\u001eU\u001bA!B\u0002\u0005\u0018%\t\u0001bD\u0017\f\t\u0005$\u0001TD\u0011\u0003\u000b\u0005A\u0001#V\u0002\u0005\u000b\r!i\"C\u0001\t\"5*B!\u0019\u0003\u0019!\u0005bQ!\u0001E\u0012!K)Z!B\u0001\t$1\u0005\u0011kA\u0001\u0005&E\u001b\u0011\u0001\"\nV\u0007\u0011)1\u0001\u0002\t\n\u0003!\u0019R\u0006\u0004\u0003b\taQ\u0011eA\u0003\u0002\u0011'a\t!V\u0002\u0005\u000b\r!!\"C\u0001\t\u00185ZA!\u0019\u0003\u0019\u000e\u0005\u0012Q!\u0001\u0005\b+\u000e!Qa\u0001C\u0007\u0013\u0005A)\"L\u0006\u0005C\u0012AB!\t\u0002\u0006\u0003!1Qk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001\u0005\u000b[-!\u0011\r\u0002\r\tC\t)\u0011\u0001#\u0005V\u0007\u0011)1\u0001\u0002\u0005\n\u0003!YQf\u0004\u0003b\ta\u0019\u0012EB\u0003\u0002\u0011OI1!\u0003\u0002\u0006\u0003!MQk\u0001\u0003\u0006\u0007\u0011\u0019\u0012\"\u0001\u0005\u0015[M!\u0011\u0001\u0007\u000b\u001e\u000e\u0011\u0001\u0001\u0012F\u0007\u0003\u000b\u0005Aa\u0002U\u0002\u0001C\t)\u0011\u0001#\bR\u0007\u0015!A#C\u0001\u0005\u00025\t\u0001\u0012F\u0017\u0014\t\rAR#(\u0004\u0005\u0001!%RBA\u0003\u0002\u00119\u00016\u0001A\u0011\u0003\u000b\u0005Ai\"U\u0002\u0006\tUI\u0011\u0001\"\u0001\u000e\u0003!%Rf\u0005\u0003\u00021Wij\u0001\u0002\u0001\t*5\u0011Q!\u0001\u0005\u000f!\u000e\u0001\u0011EA\u0003\u0002\u0011;\t6!\u0002C\u0016\u0013\u0005!\t!D\u0001\t*U\u0012T!\r\u0003d\u0002a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\rA\u001b\u0001!(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u001d\u00016\u0011AO\u0007\t\u0001A\u0001\"\u0004\u0002\u0006\u0003!E\u0001kA\u0001\u001e\u0010\u0011\t\u0001BC\u0007\u0004\u000b\u0005A\u0019\u0002$\u0001Q\u0007\u0007\t#!B\u0001\t\u0006E\u001b1\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005A)\"D\u0001\t\u00175\t\u0001r\u0003"})
public final class IterableTypesDetector {
    public static final /* synthetic */ KClass $kotlinClass;
    private final InjectorForMacros injector;
    private final HashMap<FuzzyType, Boolean> cache;
    private final Name iteratorName;
    private final Collection<? extends JetType> typesWithExtensionIterator;
    private final Project project;
    private final ModuleDescriptor moduleDescriptor;
    private final JetScope scope;
    private final JetType loopVarType;

    static {
        $kotlinClass = Reflection.createKotlinClass(IterableTypesDetector.class);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isIterable(@JetValueParameter(name="type") @NotNull FuzzyType type2) {
        Object v;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Map $receiver = this.cache;
        if ($receiver.containsKey(type2)) {
            v = $receiver.get(type2);
        } else {
            void var3_3;
            Boolean answer = this.isIterableNoCache(type2);
            $receiver.put(type2, answer);
            v = var3_3;
        }
        return (Boolean)v;
    }

    private final boolean isIterableNoCache(@JetValueParameter(name="type") FuzzyType type2) {
        if (!this.canBeIterable(type2)) {
            return false;
        }
        JetExpression expression2 = new JetPsiFactory(this.project).createExpression("fake");
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression2, type2.getType());
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(this.injector.getExpressionTypingComponents().getAdditionalCheckerProvider(), new BindingTraceContext(), this.scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        JetType elementType = this.injector.getExpressionTypingComponents().getForLoopConventionsChecker().checkIterableConvention(expressionReceiver, context2);
        if (elementType == null) {
            return false;
        }
        return this.loopVarType == null || new FuzzyType(elementType, (Collection<? extends TypeParameterDescriptor>)type2.getFreeParameters()).checkIsSubtypeOf(this.loopVarType) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeIterable(@JetValueParameter(name="type") FuzzyType type2) {
        boolean bl;
        JetScope jetScope = type2.getType().getMemberScope();
        Name name2 = this.iteratorName;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"iteratorName");
        if (KotlinPackage.isNotEmpty(jetScope.getFunctions(name2))) return true;
        Iterable $receiver = this.typesWithExtensionIterator;
        Iterator iterator2 = $receiver.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element = iterator2.next();
            JetType it = (JetType)element;
            if (type2.checkIsSubtypeOf(it) != null) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public IterableTypesDetector(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="moduleDescriptor") @NotNull ModuleDescriptor moduleDescriptor, @JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="loopVarType", type="?") @Nullable JetType loopVarType) {
        Annotated annotated;
        ReceiverParameterDescriptor it;
        Collection<ReceiverParameterDescriptor> collection;
        Collection destination;
        Iterable $receiver;
        Iterable $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        this.project = project;
        this.moduleDescriptor = moduleDescriptor;
        this.scope = scope2;
        this.loopVarType = loopVarType;
        this.injector = new InjectorForMacros(this.project, this.moduleDescriptor);
        this.cache = new HashMap();
        Name name2 = this.iteratorName = Name.identifier("iterator");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"iteratorName");
        Iterable iterable = this.scope.getFunctions(name2);
        IterableTypesDetector iterableTypesDetector = this;
        void var6_7 = $receiver2;
        Collection collection2 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)item;
            collection = destination;
            annotated = it.getExtensionReceiverParameter();
            collection.add((ReceiverParameterDescriptor)annotated);
        }
        collection = (List)destination;
        $receiver2 = KotlinPackage.filterNotNull((Iterable)collection);
        $receiver = $receiver2;
        destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            it = (ReceiverParameterDescriptor)item;
            collection = destination;
            annotated = it.getType();
            collection.add((ReceiverParameterDescriptor)annotated);
        }
        collection = (List)destination;
        iterableTypesDetector.typesWithExtensionIterator = collection;
    }

    public /* synthetic */ IterableTypesDetector(Project project, ModuleDescriptor moduleDescriptor, JetScope jetScope, JetType jetType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            jetType = null;
        }
        this(project, moduleDescriptor, jetScope, jetType);
    }
}

