/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"C\b))2j\u001c;mS:4\u0015.\u001a7e\u0005J,\u0017m\u001b9pS:$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\tI\u0016\u0014WoZ4fe*Y!M]3bWB|\u0017N\u001c;t\u0015=1\u0015.\u001a7e\u0005J,\u0017m\u001b9pS:$(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0002vS*1A(\u001b8jizRq\u0001\u001d:pU\u0016\u001cGOC\u0004Qe>TWm\u0019;\u000b\u000f=\u0004XM\\1qS*Q!M]3bWB|\u0017N\u001c;\u000b\u0017a\u0013%/Z1la>Lg\u000e\u001e\u0006\nq\u0012,'-^4hKJTQDS1wC\u001aKW\r\u001c3Ce\u0016\f7\u000e]8j]R\u0004&o\u001c9feRLWm\u001d\u0006\u0005U\u00064\u0018M\u0003\u0006qe>\u0004XM\u001d;jKNT\u0001bZ3u\r&,G\u000e\u001a\u0006\u0017\u0015\u0016$8)\u00197mC\ndW\rR3dY\u0006\u0014\u0018\r^5p]*\u0019\u0001o]5\u000b\u0017\u001d,G\u000f\u0015:pa\u0016\u0014H/\u001f\u0006\u000fg>,(oY3Q_NLG/[8o\u00159\u0019v.\u001e:dKB{7/\u001b;j_:Tq![:WC2LGMC\u0004C_>dW-\u00198\u000b\rI,Gn\\1e\u0015\u001d\u00018/\u001b$jY\u0016Tq\u0001U:j\r&dWM\u0003\u0003V]&$(\u0002D:fi\u001aKW\r\u001c3OC6,'\"\u00034jK2$g*Y7f\u0015\u0019\u0019FO]5oO*!A.\u00198h\u00159\u0019X\r^,bi\u000eD\u0017iY2fgNTQA^1mk\u0016TAc]3u/\u0006$8\r['pI&4\u0017nY1uS>tGQ\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!!QA\u0001C\u0004\u0011\u0013)!\u0001\u0002\u0003\t\u0006\u0015\u0011A\u0011\u0002\u0005\u0006\u000b\t!Q\u0001C\u0002\u0006\u0007\u0011-\u0001r\u0001\u0007\u0001\u000b\t!A\u0001C\u0004\u0006\u0005\u00115\u0001BB\u0003\u0004\t\u001dAi\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0012C\u0003\u0003\t!A1!B\u0002\u0005\u0012!AA\u0002A\u0003\u0003\t\u0003A\u0019\"\u0002\u0002\u0005\u0014!\u0015QA\u0001\u0003\u000b\u0011\r)!\u0001\"\u0006\t\u0015\u0015\u0019Aa\u0003\u0005\n\u0019\u0001)!\u0001B\u0004\t\u000e\u0015\u0011A\u0011\u0003\u0005\t\u000b\t!\u0011\u0001c\u0006\u0006\u0007\u0011i\u0001b\u0003\u0007\u0001\u000b\t!Q\u0002C\u0006\u0006\u0007\u0011%\u0001\"\u0004\u0007\u0001\u000b\t!I\u0001C\u0007\u0006\u0003!\rQa\u0001C\u0010\u00119a\u0001!\u0002\u0002\u0005\t!]Qa\u0001C\u0011\u0011?a\u0001!B\u0002\u0005 !\u0001B\u0002A\u0003\u0003\tCAy\"B\u0002\u0005 !\rB\u0002A\u0003\u0002\u0011')!\u0001B\n\t%\u0015\u0011Aq\u0005E\u0012\t\u0001a1!\u0007\u0002\u0006\u0003!1QV\u0003\u0003\u00041+\t3!B\u0001\t\u001c1\u0005\u0011kA\u0002\u0005\u0016%\t\u0001BD\u0017\u0016\t\u0005AB\"h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011;a\t\u0001U\u0002\u0001C\r)\u0011\u0001c\u0007\r\u0002E\u001bQ\u0001\u0002\u0007\n\u0003!qQ\"\u0001\u0005\u0010['!1\u0002g\u0007\"\u0005\u0015\t\u0001\u0002E)\u0004\u0007\u0011m\u0011\"\u0001C\u0001[Q!!\u0002'\b\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005A\u0011\u0003$\u0001Q\u0007\u0001\t#!B\u0001\t$E\u001bQ\u0001\"\b\n\u0003\u0011\u0001Q\"\u0001\u0005\u0013[M!\u0001\u0001'\t\u001e\u000e\u0011\u0001\u0001\"E\u0007\u0003\u000b\u0005A)\u0003U\u0002\u0001C\t)\u0011\u0001c\tR\u0007\u0015!\t#C\u0001\u0005\u00015\t\u0001\u0002F\u0017\u0014\t\u0003A*#(\u0004\u0005\u0001!\u0019RBA\u0003\u0002\u0011A\u00016\u0001A\u0011\u0003\u000b\u0005A\u0019#U\u0002\u0006\tKI\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0005Qf\u0005C\u00011Oij\u0001\u0002\u0001\t'5\u0011Q!\u0001\u0005\u0011!\u000e\u0001\u0011EA\u0003\u0002\u0011G\t6!\u0002C\u0014\u0013\u0005!\u0001!D\u0001\u0005\u0002U\u0012S!\t\u0003d\u0002a-QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u0010A\u001b\u0001!(\u0006\u0005\u0001!=QBB\u0003\u0002\u0011%I1!\u0003\u0002\u0006\u0003!]\u0001k!\u0001\"\u0005\u0015\t\u0001bA)\u0004\u000f\u0011-\u0011\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t\u001a\u0001"})
public final class KotlinFieldBreakpoint
extends FieldBreakpoint {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinFieldBreakpoint.class);
    }

    public boolean isValid() {
        if (!BreakpointWithHighlighter.isPositionValid((XSourcePosition)this.getXBreakpoint().getSourcePosition())) {
            return false;
        }
        return (Boolean)ApplicationPackage.runReadAction((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinFieldBreakpoint this$0;

            public final boolean invoke() {
                JetCallableDeclaration field = this.this$0.getField();
                return field != null && field.isValid();
            }
            {
                this.this$0 = kotlinFieldBreakpoint;
                super(0);
            }
        });
    }

    @Nullable
    public final JetCallableDeclaration getField() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return this.getProperty(sourcePosition);
    }

    private final JetCallableDeclaration getProperty(@JetValueParameter(name="sourcePosition", type="?") SourcePosition sourcePosition) {
        JetProperty property = (JetProperty)PositionUtil.getPsiElementAt((Project)this.getProject(), JetProperty.class, (SourcePosition)sourcePosition);
        if (property != null) {
            return property;
        }
        JetParameter parameter = (JetParameter)PositionUtil.getPsiElementAt((Project)this.getProject(), JetParameter.class, (SourcePosition)sourcePosition);
        if (parameter != null) {
            return parameter;
        }
        return null;
    }

    protected void reload(@JetValueParameter(name="psiFile", type="?") @Nullable PsiFile psiFile) {
        JetCallableDeclaration property = this.getProperty(this.getSourcePosition());
        if (property != null) {
            String string = property.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.getName()");
            this.setFieldName(string);
            if (property instanceof JetProperty && ((JetProperty)property).isTopLevel()) {
                ((JavaFieldBreakpointProperties)this.getProperties()).myClassName = PackageClassUtils.getPackageClassFqName(((JetProperty)property).getContainingJetFile().getPackageFqName()).asString();
            } else {
                FqName fqName2;
                JetClassOrObject jetClass = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)property, JetClassOrObject.class);
                if (jetClass instanceof JetClassOrObject && (fqName2 = jetClass.getFqName()) != null) {
                    ((JavaFieldBreakpointProperties)this.getProperties()).myClassName = fqName2.asString();
                }
            }
            this.setInstanceFiltersEnabled(false);
        }
    }

    public final void setFieldName(@JetValueParameter(name="fieldName") @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        ((JavaFieldBreakpointProperties)this.getProperties()).myFieldName = fieldName;
    }

    public final void setWatchAccess(@JetValueParameter(name="value") boolean value2) {
        ((JavaFieldBreakpointProperties)this.getProperties()).WATCH_ACCESS = value2;
    }

    public final void setWatchModification(@JetValueParameter(name="value") boolean value2) {
        ((JavaFieldBreakpointProperties)this.getProperties()).WATCH_MODIFICATION = value2;
    }

    public KotlinFieldBreakpoint(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super(project, breakpoint);
    }
}

