/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.render.DelegatedPropertyFieldDescriptor;
import org.jetbrains.kotlin.load.java.JvmAbi;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"(\u0006)A3j\u001c;mS:\u001cE.Y:t/&$\b\u000eR3mK\u001e\fG/\u001a3Qe>\u0004XM\u001d;z%\u0016tG-\u001a:fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b\rI,g\u000eZ3s\u00155\u0019E.Y:t%\u0016tG-\u001a:fe*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T!!^5\u000b\tQ\u0014X-\u001a\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001b\t,\u0018\u000e\u001c3DQ&dGM]3o\u0015\u00151\u0018\r\\;f\u0015\u00151\u0016\r\\;f\u0015\r\u0019XO\u001c\u0006\u0004U\u0012L'b\u00022vS2$WM\u001d\u0006\u0010\u0007\"LG\u000e\u001a:f]\n+\u0018\u000e\u001c3fe*91m\u001c8uKb$(\"E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi*1QM\\4j]\u0016T!\"\u001a<bYV\fG/[8o\u0015\u0011)f.\u001b;\u000b\u0019%\u001c\u0018\t\u001d9mS\u000e\f'\r\\3\u000b\u000f)$\u0017\u000eV=qK*!A+\u001f9f\u0015\u001d\u0011un\u001c7fC:D\u001cA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002E\u0003\u000b\t!I\u0001C\u0003\u0006\u0005\u0011)\u00012B\u0003\u0003\t\u0017A1!B\u0002\u0005\r!\u001dA\u0002A\u0003\u0003\t\u000fA\u0001\"\u0002\u0002\u0005\u000f!EQa\u0001C\b\u0011\u001fa\u0001!B\u0002\u0005\r!MA\u0002A\u0003\u0003\t\u0013A1\"\u0002\u0002\u0005\u0013!]Qa\u0001C\n\u0011+a\u0001!B\u0001\t\u0004\u0015\u0019AQ\u0003\u0005\r\u0019\u0001)!\u0001b\u0004\t\u0010\u0015\u0011AA\u0002E\n\u000b\t!\u0019\u0002#\u0006\u0006\u0007\u0011=\u00012\u0004\u0007\u0001\u000b\r!)\u0002\u0003\b\r\u0001\u0015\u0011Aq\u0002E\u000e\t\ra1!\u0007\u0002\u0006\u0003!5Qf\n\u0003\f1\u001biz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001\u0005\t\u0019\u0003\u00016\u0001AO\u0007\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!E\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A!\u0002U\u0002\u0002C\t)\u0011\u0001C\u0006R\u0007%!i!C\u0001\u0005\u00015\t\u0001rC\u0007\u0002\u00111i\u0011\u0001#\u0007.)\u0011Y\u0001\u0014DO\b\t\u0001AQ\"D\u0002\u0006\u0003!iA\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001E\u000e#\u000e)A\u0011D\u0005\u0002\t\u0003i\u0011\u0001\u0003\b6\u0017\u0015QAa9\u0001\u0019\r\u0005\u0012Q!\u0001\u0005\u0004#\u000e\u0019AAB\u0005\u0002\t\u0001\u0001"})
public final class KotlinClassWithDelegatedPropertyRenderer
extends ClassRenderer {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinClassWithDelegatedPropertyRenderer.class);
    }

    public boolean isApplicable(@JetValueParameter(name="jdiType", type="?") @Nullable Type jdiType) {
        boolean bl;
        block3: {
            if (!super.isApplicable(jdiType)) {
                return false;
            }
            if (!(jdiType instanceof ReferenceType)) {
                return false;
            }
            Iterable $receiver = ((ReferenceType)jdiType).allFields();
            for (Object element : $receiver) {
                Field it = (Field)element;
                if (!KotlinPackage.endsWith$default((String)it.name(), (String)JvmAbi.DELEGATED_PROPERTY_NAME_SUFFIX, (boolean)false, (int)2)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public void buildChildren(@JetValueParameter(name="value", type="?") @Nullable Value value2, @JetValueParameter(name="builder") @NotNull ChildrenBuilder builder, @JetValueParameter(name="context") @NotNull EvaluationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!(value2 instanceof ObjectReference)) {
            return;
        }
        NodeManager nodeManager = builder.getNodeManager();
        if (nodeManager == null) {
            Intrinsics.throwNpe();
        }
        NodeManager nodeManager2 = nodeManager;
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        if (nodeDescriptorFactory == null) {
            Intrinsics.throwNpe();
        }
        NodeDescriptorFactory nodeDescriptorFactory2 = nodeDescriptorFactory;
        List<Field> fields2 = ((ObjectReference)value2).referenceType().allFields();
        if (fields2.isEmpty()) {
            builder.setChildren(KotlinPackage.listOf((Object)nodeManager2.createMessageNode(MessageDescriptor.CLASS_HAS_NO_FIELDS.getLabel())));
            return;
        }
        ArrayList<DebuggerTreeNode> children2 = new ArrayList<DebuggerTreeNode>();
        for (Field field : fields2) {
            if (!this.shouldDisplay(context2, (ObjectReference)value2, field)) continue;
            FieldDescriptor fieldDescriptor = nodeDescriptorFactory2.getFieldDescriptor((NodeDescriptor)builder.getParentDescriptor(), (ObjectReference)value2, field);
            if (KotlinPackage.endsWith$default((String)field.name(), (String)JvmAbi.DELEGATED_PROPERTY_NAME_SUFFIX, (boolean)false, (int)2)) {
                boolean shouldRenderDelegatedProperty = KotlinDebuggerSettings.Companion.getInstance().getDEBUG_RENDER_DELEGATED_PROPERTIES();
                if (shouldRenderDelegatedProperty) {
                    children2.add(nodeManager2.createNode((NodeDescriptor)fieldDescriptor, context2));
                }
                Project project = context2.getDebugProcess().getProject();
                if (project == null) {
                    Intrinsics.throwNpe();
                }
                ObjectReference objectReference = (ObjectReference)value2;
                Field field2 = field;
                Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
                DelegatedPropertyFieldDescriptor delegatedPropertyDescriptor = new DelegatedPropertyFieldDescriptor(project, objectReference, field2, shouldRenderDelegatedProperty);
                children2.add(nodeManager2.createNode((NodeDescriptor)delegatedPropertyDescriptor, context2));
                continue;
            }
            children2.add(nodeManager2.createNode((NodeDescriptor)fieldDescriptor, context2));
        }
        XDebuggerSettingsManager xDebuggerSettingsManager = XDebuggerSettingsManager.getInstance();
        if (xDebuggerSettingsManager == null) {
            Intrinsics.throwNpe();
        }
        if (xDebuggerSettingsManager.getDataViewSettings().isSortValues()) {
            Iterable iterable = children2;
            Comparator comparator2 = NodeManagerImpl.getNodeComparator();
            Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"NodeManagerImpl.getNodeComparator()");
            KotlinPackage.sortBy((Iterable)iterable, (Comparator)comparator2);
        }
        builder.setChildren((List)children2);
    }
}

