/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.DecompilerPackage;
import org.jetbrains.kotlin.idea.decompiler.KotlinJavascriptMetaFileViewProvider;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.KotlinJavaScriptStubBuilder;

public class KotlinJavaScriptMetaFileDecompiler
extends ClassFileDecompilers.Full {
    private final ClsStubBuilder stubBuilder = new KotlinJavaScriptStubBuilder();

    public boolean accepts(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/decompiler/KotlinJavaScriptMetaFileDecompiler", "accepts"));
        }
        return file.getName().endsWith(".kjsm");
    }

    @NotNull
    public ClsStubBuilder getStubBuilder() {
        ClsStubBuilder clsStubBuilder = this.stubBuilder;
        if (clsStubBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/KotlinJavaScriptMetaFileDecompiler", "getStubBuilder"));
        }
        return clsStubBuilder;
    }

    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/decompiler/KotlinJavaScriptMetaFileDecompiler", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/idea/decompiler/KotlinJavaScriptMetaFileDecompiler", "createFileViewProvider"));
        }
        KotlinJavascriptMetaFileViewProvider kotlinJavascriptMetaFileViewProvider = new KotlinJavascriptMetaFileViewProvider(manager, file, physical, DecompilerPackage.isKotlinJavaScriptInternalCompiledFile(file));
        if (kotlinJavascriptMetaFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/KotlinJavaScriptMetaFileDecompiler", "createFileViewProvider"));
        }
        return kotlinJavascriptMetaFileViewProvider;
    }
}

