/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.diagnostic.Logger;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={".\u0006)AB)\u001b:fGR|'/\u001f\"bg\u0016$G)\u0019;b\r&tG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*QA-Z2p[BLG.\u001a:\u000b\u0017Q,\u0007\u0010\u001e\"vS2$WM\u001d\u0006\u0010\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*i1/\u001a:jC2L'0\u0019;j_:Tq\u0002Z3tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0017\rd\u0017m]:GS:$WM\u001d\u0006\u001a\t&\u0014Xm\u0019;pef\u0014\u0015m]3e\u00072\f7o\u001d$j]\u0012,'OC\u0002m_\u001eTa\u0001T8hO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0015\u0011L\u0017m\u001a8pgRL7M\u0003\bhKR\u001cE.Y:t\r&tG-\u001a:\u000b\r\u001d,G\u000fT8h\u001551\u0017N\u001c3DY\u0006\u001c8\u000fR1uC*91\r\\1tg&#'bB\"mCN\u001c\u0018\n\u001a\u0006\u0005]\u0006lWMC\u0005DY\u0006\u001c8\u000fR1uCJ\r!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0003!!QA\u0001C\u0004\u0011\u0013)1\u0001\u0002\u0003\t\b1\u0001Qa\u0001C\u0003\u0011\u0019a\u0001!B\u0001\t\u0010\u0015\u0011A1\u0002\u0005\t\u000b\t!a\u0001#\u0005\u0006\u0005\u00115\u0001\"C\u0003\u0004\t\u001dAq\u0001\u0004\u0001\u0006\u0005\u0011\u0015\u0001BB\u0003\u0003\t\u001dAq!\u0002\u0002\u0005\u0003!aQa\u0001\u0003\n\u0011/a\u0001!B\u0002\u0005\b!eA\u0002A\u0003\u0003\t\u000fAI\"\u0002\u0002\u0005\u0013!]A\u0001\u0001\u0007\u00043\t)\u0011\u0001#\u0003.\u001f\u0011\u0001G\u0001g\u0003\"\u0005\u0015\t\u0001\"B+\u0004\u0011\u0015\u0019A1B\u0005\u0002\u0011!i1\u0001b\u0005\n\u0003!AQf\u0004\u0003a\ta5\u0011EA\u0003\u0002\u0011\u001f)6\u0001C\u0003\u0004\t\u001bI\u0011\u0001#\u0005\u000e\u0007\u0011Q\u0011\"\u0001E\t[Q!1\u0002'\u0006\u001e\u000e\u0011\u0001\u0001bC\u0007\u0003\u000b\u0005A\u0019\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\u0006\r\u0002E\u001bQ\u0001\"\u0006\n\u0003!UQ\"\u0001\u0005\fky)Q\u0004Br\u00011\u0015ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0006!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\u0010A\u001b\t!\t\u0002\u0006\u0003!\u0019\u0011kA\u0004\u0005\u000b%\tA\u0001A\u0007\u0002\u0011!i\u0011\u0001#\u0005"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;

    static {
        $kotlinClass = Reflection.createKotlinClass(DirectoryBasedDataFinder.class);
    }

    @Override
    @Nullable
    public ClassData findClassData(@JetValueParameter(name="classId") @NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.classFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass;
        String[] data2 = binaryClass.getClassHeader().getAnnotationData();
        if (data2 == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        return JvmProtoBufUtil.readClassDataFrom(data2);
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public DirectoryBasedDataFinder(@JetValueParameter(name="classFinder") @NotNull DirectoryBasedClassFinder classFinder, @JetValueParameter(name="log") @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)classFinder, (String)"classFinder");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.classFinder = classFinder;
        this.log = log;
    }
}

