/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersPackage$fixersUtil$f9a2ce21;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetExpression;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"e\u0004)\u00112j\u001c;mS:$un\u00165jY\u00164\u0015\u000e_3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006Ta!\u001a3ji>\u0014(B\u00024jq\u0016\u00148OC\u0003GSb,'OC\u000fT[\u0006\u0014H/\u00128uKJ\u0004&o\\2fgN|'oV5uQ\u001aK\u00070\u001a:t\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!A.\u00198h\u0015]Yu\u000e\u001e7j]Nk\u0017M\u001d;F]R,'\u000fS1oI2,'O\u0003\u0004=S:LGO\u0010\u0006\u0006CB\u0004H.\u001f\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u000f=\u0004XM\\1qS*I\u0001O]8dKN\u001cxN\u001d\u0006\u000baNLW\t\\3nK:$(B\u0003)tS\u0016cW-\\3oi*\u0019\u0001o]5\u000b\tUs\u0017\u000e\u001eJ\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\u000fAQ!\u0002\u0002\u0005\t!-Qa\u0001C\u0005\u0011\u0011a\u0001!B\u0002\u0005\u000b!\u001dA\u0002A\u0003\u0004\t\tAa\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0002C\u0003\u0003\t\u001bA)!B\u0002\u0005\u000f!=A\u0002A\u0003\u0003\t\u0011A!\"B\u0002\u0005\u0011!MA\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0005\t\u00161\u0001QA\u0001\u0003\b\u0011\u001f)!\u0001\u0002\u0002\t\r\u0015\u0011A\u0001\u0003E\n\t\ra1!\u0007\u0004\u0006\u0003!-\u0011bA\u0005\u0003\u000b\u0005Aa!\f\u0014\u0005\u0017a9QT\u0002\u0003\u0001\u0011\u000bi!!B\u0001\t\u0010A\u001b\u0001!(\u0004\u0005\u0001!EQBA\u0003\u0002\u0011\u0019\u00016\u0011AO\u0007\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!E\u0001kA\u0001\"\u0005\u0015\t\u00012C)\u0004\u0013\u00119\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"D\u0001\t\u00165\t\u0001bC\u001b\f\u000b)!1\u001d\u0001M\u0007C\t)\u0011\u0001C\u0002R\u0007\r!i!C\u0001\u0005\u0001\u0001"})
public final class KotlinDoWhileFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinDoWhileFixer.class);
    }

    public void apply(@JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="processor") @NotNull KotlinSmartEnterHandler processor, @JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof JetDoWhileExpression)) {
            return;
        }
        Document doc = editor.getDocument();
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement cannot be cast to org.jetbrains.kotlin.psi.JetDoWhileExpression");
        }
        JetDoWhileExpression stmt = (JetDoWhileExpression)psiElement2;
        int start = FixersPackage$fixersUtil$f9a2ce21.getStart(FixersPackage$fixersUtil$f9a2ce21.getRange((PsiElement)stmt));
        JetExpression body2 = stmt.getBody();
        PsiElement whileKeyword = stmt.getWhileKeyword();
        if (body2 == null) {
            if (whileKeyword == null) {
                doc.replaceString(start, start + "do".length(), (CharSequence)"do {} while()");
            } else {
                doc.insertString(start + "do".length(), (CharSequence)"{}");
            }
            return;
        }
        if (whileKeyword != null && !(body2 instanceof JetBlockExpression)) {
            PsiElement psiElement3 = (PsiElement)body2;
            Document document = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
            int n = FixersPackage$fixersUtil$f9a2ce21.startLine(psiElement3, document);
            PsiElement psiElement4 = (PsiElement)stmt;
            Document document2 = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"doc");
            if (n > FixersPackage$fixersUtil$f9a2ce21.startLine(psiElement4, document2)) {
                doc.insertString(FixersPackage$fixersUtil$f9a2ce21.getStart(FixersPackage$fixersUtil$f9a2ce21.getRange(whileKeyword)), (CharSequence)"}");
                doc.insertString(start + "do".length(), (CharSequence)"{");
                return;
            }
        }
        if (stmt.getCondition() == null) {
            PsiElement lParen = stmt.getLeftParenthesis();
            PsiElement rParen = stmt.getRightParenthesis();
            if (whileKeyword == null) {
                doc.insertString(FixersPackage$fixersUtil$f9a2ce21.getEnd(FixersPackage$fixersUtil$f9a2ce21.getRange((PsiElement)stmt)), (CharSequence)"while()");
            } else if (lParen == null && rParen == null) {
                doc.replaceString(FixersPackage$fixersUtil$f9a2ce21.getStart(FixersPackage$fixersUtil$f9a2ce21.getRange(whileKeyword)), FixersPackage$fixersUtil$f9a2ce21.getEnd(FixersPackage$fixersUtil$f9a2ce21.getRange(whileKeyword)), (CharSequence)"while()");
            } else if (lParen != null) {
                processor.registerUnresolvedError(FixersPackage$fixersUtil$f9a2ce21.getEnd(FixersPackage$fixersUtil$f9a2ce21.getRange(lParen)));
            }
        }
    }
}

