/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.KotlinJavaScriptLibraryDetectionUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class JsLibraryStdDetectionUtil {
    public static String getJsLibraryStdVersion(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JsLibraryStdDetectionUtil", "getJsLibraryStdVersion"));
        }
        return JsLibraryStdDetectionUtil.getJsLibraryStdVersion(classesRoots, true);
    }

    public static boolean hasJsStdlibJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JsLibraryStdDetectionUtil", "hasJsStdlibJar"));
        }
        List<VirtualFile> classes2 = Arrays.asList(library.getFiles(OrderRootType.CLASSES));
        return JsLibraryStdDetectionUtil.getJsLibraryStdVersion(classes2, false) != null;
    }

    private static String getJsLibraryStdVersion(@NotNull List<VirtualFile> classesRoots, boolean fixedJarName) {
        VirtualFile jar;
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JsLibraryStdDetectionUtil", "getJsLibraryStdVersion"));
        }
        if (JavaRuntimeDetectionUtil.getJavaRuntimeVersion(classesRoots) != null) {
            return null;
        }
        VirtualFile virtualFile = jar = fixedJarName ? LibraryUtils.getJarFile(classesRoots, "kotlin-jslib.jar") : JsLibraryStdDetectionUtil.getJsStdLibJar(classesRoots);
        if (jar == null) {
            return null;
        }
        assert (KotlinJavaScriptLibraryDetectionUtil.isKotlinJavaScriptLibrary(classesRoots)) : "StdLib should also be detected as Kotlin/Javascript library";
        return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)jar), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Nullable
    private static VirtualFile getJsStdLibJar(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JsLibraryStdDetectionUtil", "getJsStdLibJar"));
        }
        for (VirtualFile root : classesRoots) {
            VirtualFile jar;
            if (root.getFileSystem().getProtocol() != "jar" || (jar = VfsUtilCore.getVirtualFileForJar((VirtualFile)root)) == null || !LibraryUtils.isKotlinJavascriptStdLibrary(new File(jar.getPath()))) continue;
            return jar;
        }
        return null;
    }
}

