/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.CustomLibraryDescriptorWithDeferredConfig;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.project.TargetPlatform;

public class KotlinModuleSettingStep
extends ModuleWizardStep {
    private final TargetPlatform targetPlatform;
    @Nullable
    private final ModuleWizardStep myJavaStep;
    private final CustomLibraryDescription customLibraryDescription;
    private final LibrariesContainer librariesContainer;
    private LibraryOptionsPanel libraryOptionsPanel;
    private LibraryCompositionSettings libraryCompositionSettings;
    private final String basePath;

    public KotlinModuleSettingStep(TargetPlatform targetPlatform, ModuleBuilder moduleBuilder, @NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep", "<init>"));
        }
        this.targetPlatform = targetPlatform;
        this.myJavaStep = JavaModuleType.getModuleType().modifyProjectTypeStep(settingsStep, moduleBuilder);
        this.basePath = moduleBuilder.getContentEntryPath();
        this.librariesContainer = LibrariesContainerFactory.createContainer((Project)settingsStep.getContext().getProject());
        this.customLibraryDescription = this.getCustomLibraryDescription(settingsStep.getContext().getProject());
        moduleBuilder.addModuleConfigurationUpdater(this.createModuleConfigurationUpdater());
        settingsStep.addSettingsField(this.getLibraryLabelText(), (JComponent)this.getLibraryPanel().getSimplePanel());
    }

    protected ModuleBuilder.ModuleConfigurationUpdater createModuleConfigurationUpdater() {
        return new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep$1", "update"));
                }
                if (rootModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep$1", "update"));
                }
                if (KotlinModuleSettingStep.this.libraryCompositionSettings != null) {
                    KotlinModuleSettingStep.this.libraryCompositionSettings.addLibraries(rootModel, new ArrayList(), KotlinModuleSettingStep.this.librariesContainer);
                    if (KotlinModuleSettingStep.this.customLibraryDescription instanceof CustomLibraryDescriptorWithDeferredConfig) {
                        ((CustomLibraryDescriptorWithDeferredConfig)KotlinModuleSettingStep.this.customLibraryDescription).finishLibConfiguration(module, rootModel);
                    }
                }
            }
        };
    }

    public void disposeUIResources() {
        if (this.libraryOptionsPanel != null) {
            Disposer.dispose((Disposable)this.libraryOptionsPanel);
        }
    }

    public JComponent getComponent() {
        return this.getLibraryPanel().getMainPanel();
    }

    @NotNull
    protected String getLibraryLabelText() {
        if (this.targetPlatform == TargetPlatform.JVM) {
            if ("\u001bKotlin runtime:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep", "getLibraryLabelText"));
            }
            return "\u001bKotlin runtime:";
        }
        if (this.targetPlatform == TargetPlatform.JS) {
            if ("\u001bKotlin JS library:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep", "getLibraryLabelText"));
            }
            return "\u001bKotlin JS library:";
        }
        throw new IllegalStateException("Only JS and JVM target are supported");
    }

    @NotNull
    protected CustomLibraryDescription getCustomLibraryDescription(@Nullable Project project) {
        if (this.targetPlatform == TargetPlatform.JVM) {
            JavaRuntimeLibraryDescription javaRuntimeLibraryDescription = new JavaRuntimeLibraryDescription(project);
            if (javaRuntimeLibraryDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep", "getCustomLibraryDescription"));
            }
            return javaRuntimeLibraryDescription;
        }
        if (this.targetPlatform == TargetPlatform.JS) {
            JSLibraryStdDescription jSLibraryStdDescription = new JSLibraryStdDescription(project);
            if (jSLibraryStdDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep", "getCustomLibraryDescription"));
            }
            return jSLibraryStdDescription;
        }
        throw new IllegalStateException("Only JS and JVM target are supported");
    }

    public void updateDataModel() {
        this.libraryCompositionSettings = this.getLibraryPanel().apply();
        if (this.myJavaStep != null) {
            this.myJavaStep.updateDataModel();
        }
    }

    public boolean validate() throws ConfigurationException {
        return super.validate() && (this.myJavaStep == null || this.myJavaStep.validate());
    }

    protected LibraryOptionsPanel getLibraryPanel() {
        if (this.libraryOptionsPanel == null) {
            String baseDirPath = this.basePath != null ? FileUtil.toSystemIndependentName((String)this.basePath) : "";
            this.libraryOptionsPanel = new LibraryOptionsPanel(this.customLibraryDescription, baseDirPath, FrameworkLibraryVersionFilter.ALL, this.librariesContainer, false);
        }
        return this.libraryOptionsPanel;
    }
}

