/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

public class DebugInfoAnnotator
implements Annotator {
    public static boolean isDebugInfoEnabled() {
        return KotlinInternalMode.Instance.getEnabled();
    }

    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator", "annotate"));
        }
        if (!DebugInfoAnnotator.isDebugInfoEnabled() || !ProjectRootsUtil.isInProjectOrLibSource(element)) {
            return;
        }
        if (element instanceof JetFile && !(element instanceof JetCodeFragment)) {
            JetFile file = (JetFile)element;
            try {
                BindingContext bindingContext2 = ResolvePackage.analyzeFully(file);
                DebugInfoUtil.markDebugAnnotations((PsiElement)file, bindingContext2, new DebugInfoUtil.DebugInfoReporter(){

                    @Override
                    public void reportElementWithErrorType(@NotNull JetReferenceExpression expression2) {
                        if (expression2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportElementWithErrorType"));
                        }
                        holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Resolved to error element").setTextAttributes(JetHighlightingColors.RESOLVED_TO_ERROR);
                    }

                    @Override
                    public void reportMissingUnresolved(@NotNull JetReferenceExpression expression2) {
                        if (expression2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportMissingUnresolved"));
                        }
                        holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Reference is not resolved to anything, but is not marked unresolved").setTextAttributes(JetHighlightingColors.DEBUG_INFO);
                    }

                    @Override
                    public void reportUnresolvedWithTarget(@NotNull JetReferenceExpression expression2, @NotNull String target) {
                        if (expression2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportUnresolvedWithTarget"));
                        }
                        if (target == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportUnresolvedWithTarget"));
                        }
                        holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Reference marked as unresolved is actually resolved to " + target).setTextAttributes(JetHighlightingColors.DEBUG_INFO);
                    }
                });
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                holder.createErrorAnnotation(element, e.getClass().getCanonicalName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

