/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.CommonClassNames;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class MarkersPackage$JavaPsiUtils$980c607f {
    @NotNull
    public static final Set<PsiClass> collectContainingClasses(@JetValueParameter(name="methods") @NotNull Collection<? extends PsiMethod> methods) {
        Intrinsics.checkParameterIsNotNull(methods, (String)"methods");
        HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
        for (PsiMethod psiMethod : methods) {
            ProgressManager.checkCanceled();
            PsiClass parentClass = psiMethod.getContainingClass();
            if (parentClass == null || !(Intrinsics.areEqual((Object)CommonClassNames.JAVA_LANG_OBJECT, (Object)parentClass.getQualifiedName()) ^ true)) continue;
            classes2.add(parentClass);
        }
        return classes2;
    }

    @Nullable
    public static final PsiClass getPsiClass(@JetValueParameter(name="element", type="?") @Nullable PsiElement element) {
        PsiClass psiClass;
        if (element == null) {
            psiClass = null;
        } else if (element instanceof PsiClass) {
            psiClass = (PsiClass)element;
        } else if (element instanceof JetClass) {
            psiClass = LightClassUtil.getPsiClass((JetClassOrObject)element);
        } else if (element.getParent() instanceof JetClass) {
            PsiElement psiElement = element.getParent();
            if (psiElement == null) {
                throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetClass");
            }
            psiClass = LightClassUtil.getPsiClass((JetClass)psiElement);
        } else {
            psiClass = null;
        }
        return psiClass;
    }

    @Nullable
    public static final PsiMethod getPsiMethod(@JetValueParameter(name="element", type="?") @Nullable PsiElement element) {
        PsiMethod psiMethod;
        PsiElement parent;
        PsiElement psiElement = element;
        Object object = parent = psiElement != null ? psiElement.getParent() : null;
        if (element == null) {
            psiMethod = null;
        } else if (element instanceof PsiMethod) {
            psiMethod = (PsiMethod)element;
        } else if (parent instanceof JetNamedFunction || parent instanceof JetSecondaryConstructor) {
            PsiElement psiElement2 = parent;
            if (psiElement2 == null) {
                throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetFunction");
            }
            psiMethod = LightClassUtil.getLightClassMethod((JetFunction)psiElement2);
        } else {
            psiMethod = null;
        }
        return psiMethod;
    }
}

