/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.IntentionsPackage$Utils$d82a7ea7;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"]\u0006)\t4i\u001c8wKJ$h*Z4bi\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8XSRDG)Z7pe\u001e\fgn\u001d'bo&sG/\u001a8uS>t'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\u000bS:$XM\u001c;j_:\u001c(B\u000b&fiN+GN\u001a+be\u001e,G/\u001b8h\u001f\u001a47/\u001a;J]\u0012,\u0007/\u001a8eK:$\u0018J\u001c;f]RLwN\u001c\u0006\u0014\u0015\u0016$\bK]3gSb,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004aNL'B\u0002\u001fj]&$hHC\u0004baBd\u0017\u0010V8\u000b\u000f\u0015dW-\\3oi*1Q\rZ5u_JTa!\u00123ji>\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\tUs\u0017\u000e\u001e\u0006\u000fSN\f\u0005\u000f\u001d7jG\u0006\u0014G.\u001a+p\u0015\u001d\u0011un\u001c7fC:TAc\u001d9mSR\u0014un\u001c7fC:\u001cV-];f]\u000e,'BC3yaJ,7o]5p]*\u0019\"*\u001a;CS:\f'/_#yaJ,7o]5p]*!A*[:u\u00155QU\r^#yaJ,7o]5p]*!!.\u0019<b\u0015\u0011)H/\u001b7'\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Qa\u0001\u0003\u0003\u0011\ra\u0001!\u0002\u0002\u0005\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0001\t\u000f\u0015\u0011A\u0011\u0002E\b\u000b\t!Q\u0001\u0003\u0005\u0006\u0005\u0011-\u0001BB\u0003\u0004\t\u0019Ai\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\b\u0011#a\u0001!\u0002\u0002\u0005\b!\u001dQA\u0001\u0003\u0007\u0011\u001b)1\u0001B\u0004\t\u00141\u0001Qa\u0001C\u0004\u0011-a\u0001!B\u0002\u0005\u000f!]A\u0002A\u0003\u0004\t\u000fAA\u0002\u0004\u0001\u0006\u0003!eQA\u0001\u0003\f\u00115)!\u0001b\u0006\t\u0018\u0015\u0011Aq\u0001\u0005\f\t\ra)!\u0007\u0004\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005AA!,\u000f\u0005\u0017a)QT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\tA\u001b\u0001!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005Ay!U\u0002\b\t\u0015I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\"\u0001E\t[M!1\u0002G\u0005\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001C\t)\u0011\u0001C\u0005R\u0007\u0015!\u0011\"C\u0001\u0005\u00025\t\u0001\u0002C\u0017\u0019\t\u0005A\"\"(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011'\u00016\u0001A\u0011\b\u000b\u0005A!\"C\u0002\n\u0005\u0015\t\u0001R\u0003G\u0001#\u000e)AAC\u0005\u0002\u00111i\u0011\u0001#\u00076\u0017\u0015QAa9\u0001\u0019\n\u0005\u0012Q!\u0001E\u0003#\u000e\u0019A\u0011B\u0005\u0002\t\u0001\u0001"})
public final class ConvertNegatedExpressionWithDemorgansLawIntention
extends JetSelfTargetingOffsetIndependentIntention<JetPrefixExpression> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConvertNegatedExpressionWithDemorgansLawIntention.class);
    }

    @Override
    public boolean isApplicableTo(@JetValueParameter(name="element") @NotNull JetPrefixExpression element) {
        JetParenthesizedExpression parenthesizedExpression;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IElementType prefixOperator = element.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)prefixOperator, (Object)((Object)JetTokens.EXCL)) ^ true) {
            return false;
        }
        JetExpression jetExpression = element.getBaseExpression();
        if (!(jetExpression instanceof JetParenthesizedExpression)) {
            jetExpression = null;
        }
        JetParenthesizedExpression jetParenthesizedExpression = parenthesizedExpression = (JetParenthesizedExpression)jetExpression;
        JetExpression jetExpression2 = jetParenthesizedExpression != null ? jetParenthesizedExpression.getExpression() : null;
        if (!(jetExpression2 instanceof JetBinaryExpression)) {
            jetExpression2 = null;
        }
        JetBinaryExpression jetBinaryExpression = (JetBinaryExpression)jetExpression2;
        if (jetBinaryExpression == null) {
            return false;
        }
        JetBinaryExpression baseExpression = jetBinaryExpression;
        IElementType iElementType = baseExpression.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.ANDAND))) {
            this.setText("Replace '&&' with '||'");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.OROR))) {
            this.setText("Replace '||' with '&&'");
        } else {
            return false;
        }
        return this.splitBooleanSequence(baseExpression) != null;
    }

    @Override
    public void applyTo(@JetValueParameter(name="element") @NotNull JetPrefixExpression element, @JetValueParameter(name="editor") @NotNull Editor editor) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetExpression jetExpression = element.getBaseExpression();
        if (jetExpression == null) {
            throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression! cannot be cast to org.jetbrains.kotlin.psi.JetParenthesizedExpression");
        }
        JetParenthesizedExpression parenthesizedExpression = (JetParenthesizedExpression)jetExpression;
        JetExpression jetExpression2 = parenthesizedExpression.getExpression();
        if (jetExpression2 == null) {
            throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression! cannot be cast to org.jetbrains.kotlin.psi.JetBinaryExpression");
        }
        JetBinaryExpression baseExpression = (JetBinaryExpression)jetExpression2;
        IElementType iElementType = baseExpression.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.ANDAND))) {
            string = JetTokens.OROR.getValue();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.OROR))) {
            string = JetTokens.ANDAND.getValue();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        String operatorText = string;
        List<JetExpression> list = this.splitBooleanSequence(baseExpression);
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List operands = KotlinPackage.reverse((Iterable)list);
        JetExpression newExpression2 = PsiPackage.buildExpression(PsiPackage.JetPsiFactory((PsiElement)element), (Function1<? super BuilderByPattern<JetExpression>, ? extends Unit>)((Function1)new Function1<BuilderByPattern<JetExpression>, Unit>(operands, operatorText){
            final /* synthetic */ List $operands;
            final /* synthetic */ String $operatorText;

            public final void invoke(@JetValueParameter(name="$receiver") BuilderByPattern<JetExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                for (IndexedValue indexedValue : KotlinPackage.withIndex((Iterable)this.$operands)) {
                    int i = indexedValue.component1();
                    JetExpression operand = (JetExpression)indexedValue.component2();
                    if (i > 0) {
                        String string = this.$operatorText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"operatorText");
                        $receiver.appendFixedText(string);
                    }
                    $receiver.appendExpression(IntentionsPackage$Utils$d82a7ea7.negate(operand));
                }
            }
            {
                this.$operands = list;
                this.$operatorText = string;
                super(1);
            }
        }));
        element.replace((PsiElement)newExpression2);
    }

    private final List<JetExpression> splitBooleanSequence(@JetValueParameter(name="expression") JetBinaryExpression expression2) {
        IElementType operation;
        ArrayList<JetExpression> result2 = new ArrayList<JetExpression>();
        IElementType firstOperator = expression2.getOperationToken();
        JetExpression remainingExpression = expression2;
        while (!(!(remainingExpression instanceof JetBinaryExpression) || Intrinsics.areEqual((Object)(operation = ((JetBinaryExpression)remainingExpression).getOperationToken()), (Object)((Object)JetTokens.ANDAND)) ^ true && Intrinsics.areEqual((Object)operation, (Object)((Object)JetTokens.OROR)) ^ true)) {
            if (Intrinsics.areEqual((Object)operation, (Object)firstOperator) ^ true) {
                return null;
            }
            JetExpression jetExpression = ((JetBinaryExpression)remainingExpression).getRight();
            if (jetExpression == null) {
                return null;
            }
            result2.add(jetExpression);
            if (((JetBinaryExpression)remainingExpression).getLeft() != null) continue;
            return null;
        }
        result2.add(remainingExpression);
        return result2;
    }

    public ConvertNegatedExpressionWithDemorgansLawIntention() {
        super(JetPrefixExpression.class, "DeMorgan Law", null, false, 12, null);
    }
}

