/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalyzerPackage;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.CommentSaver;
import org.jetbrains.kotlin.idea.intentions.IntentionsPackage$Utils$d82a7ea7;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"3\b)\u00013i\u001c8wKJ$Hk\\#yaJ,7o]5p]\n{G-_%oi\u0016tG/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!\"\u001b8uK:$\u0018n\u001c8t\u0015)RU\r^*fY\u001a$\u0016M]4fi&twm\u00144gg\u0016$\u0018J\u001c3fa\u0016tG-\u001a8u\u0013:$XM\u001c;j_:TaCS3u\t\u0016\u001cG.\u0019:bi&|gnV5uQ\n{G-\u001f\u0006\u0004aNL'B\u0002\u001fj]&$hHC\u0004baBd\u0017\u0010V8\u000b\u000f\u0015dW-\\3oi*1Q\rZ5u_JTa!\u00123ji>\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\tUs\u0017\u000e\u001e\u0006\fI\u0016\u001cG.\u0019:bi&|gN\u0003\tdC:$U\r\\3uKRK\b/\u001a*fM*9!i\\8mK\u0006t'bD1qa2LHk\\%oi\u0016\u0014h.\u00197\u000b\u0011=tg)\u001b8jg\"T\u0011BR;oGRLwN\\\u0019\u000b-)+GoQ1mY\u0006\u0014G.\u001a#fG2\f'/\u0019;j_:T1A\u001b<n\u0015%1WO\\2uS>t7OC\u0005dC2\u001cg+\u00197vK*i!*\u001a;FqB\u0014Xm]:j_:T1bY1o\u001f6LG\u000fV=qK*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b\u001d\r|g\u000e^1j]N\u0014V\r^;s]*Q\u0001k]5FY\u0016lWM\u001c;\u000b\u001d%\u001c\u0018\t\u001d9mS\u000e\f'\r\\3U_\n\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0004\t\tA1\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002B\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0003!9QA\u0001C\u0005\u0011\u001f)!\u0001B\u0003\t\u0011\u0015\u0011A1\u0002\u0005\u0007\u000b\r!a\u0001#\u0004\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001dA\t\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001rA\u0003\u0003\t\u0019Ai!B\u0002\u0005\u000f!QA\u0002A\u0003\u0004\t\u001dA9\u0002\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0002\u0004\u0007\u0001\u000b\t!q\u0001#\u0007\u0006\u0005\u0011U\u0001\"D\u0003\u0003\t-A9\"B\u0002\u0005\b!qA\u0002A\u0003\u0003\t\u000fAa\"\u0002\u0002\u0005\b!aQA\u0001\u0003\u0006\u0011\u0011)1\u0001b\u0007\t!1\u0001QA\u0001C\u000e\u0011A!1\u0001$\u0002\u001a\r\u0015\t\u0001bA\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0003.:\u0011Y\u0001$BO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!!\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BB\u0007\u0003\u000b\u0005Ai\u0001UB\u0001C\t)\u0011\u0001c\u0004R\u0007\u001d!Q!C\u0001\u0005\u00015\t\u0001\u0002C\u0007\u0002\u0011#iK\u0004B\u0002\u0019\u000bu5A\u0001\u0001\u0005\n\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\n!\u000e\u0005\u0011EA\u0003\u0002\u0011\u001f\t6a\u0002\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\u00115\tA\u0011AW%\t\u0005A*\"(\u0004\u0005\u0001!IQBA\u0003\u0002\u0011\u0011\u00016\u0001AO\u000f\t\u0001A1\"\u0004\u0006\u0006\u0003!M\u0011bA\u0005\u0003\u000b\u0005A!\"C\u0002\n\u0005\u0015\t\u0001r\u0002)\u0004\u0002\u0005\u0012Q!\u0001E\b#\u000e9AQC\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!]Q\u0006\u0006\u0003\u000217ij\u0001\u0002\u0001\t\u00135\u0011Q!\u0001\u0005\u0005!\u000e\u0001\u0011eA\u0003\u0002\u00111a\t!U\u0002\u0006\t7I\u0011\u0001#\u0007\u000e\u0003!AQ\u0016\b\u0003\u00021;ij\u0001\u0002\u0001\t\u00135\u0011Q!\u0001\u0005\u000b!\u000e\u0001QT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0019A\u001b\t!\t\u0002\u0006\u0003!I\u0011kA\u0004\u0005\u001e%\tA\u0011A\u0007\u0002\u00115i\u0011\u0001#\u0007.'\u0011\t\u0001tDO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!q\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\"C)\u0004\u000b\u0011}\u0011\"\u0001C\u0001\u001b\u0005Ai\"L\n\u0005\u0017a\u0005RT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\tA\u001b\u0001!\t\u0002\u0006\u0003!I\u0011kA\u0003\u0005\"%\tA\u0011A\u0007\u0002\u0011!)4\"\u0002\u0006\u0005G\u0004AJ!\t\u0002\u0006\u0003!\u0015\u0011kA\u0002\u0005\n%\tA\u0001\u0001"})
public final class ConvertToExpressionBodyIntention
extends JetSelfTargetingOffsetIndependentIntention<JetDeclarationWithBody> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConvertToExpressionBodyIntention.class);
    }

    @Override
    public boolean isApplicableTo(@JetValueParameter(name="element") @NotNull JetDeclarationWithBody element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        JetExpression value2 = this.calcValue(element);
        return value2 != null && !this.containsReturn((PsiElement)value2);
    }

    @Override
    public void applyTo(@JetValueParameter(name="element") @NotNull JetDeclarationWithBody element, @JetValueParameter(name="editor") @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.applyToInternal(element, (Function1<? super JetCallableDeclaration, ? extends Unit>)((Function1)new Function1<JetCallableDeclaration, Unit>(editor){
            final /* synthetic */ Editor $editor;

            public final void invoke(@JetValueParameter(name="it") @NotNull JetCallableDeclaration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                JetTypeReference jetTypeReference = it.getTypeReference();
                if (jetTypeReference == null) {
                    Intrinsics.throwNpe();
                }
                JetTypeReference typeRef = jetTypeReference;
                PsiElement psiElement = it.getColon();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement colon = psiElement;
                TextRange range = new TextRange(PsiUtilPackage.getStartOffset(colon), PsiUtilPackage.getEndOffset((PsiElement)typeRef));
                this.$editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                this.$editor.getCaretModel().moveToOffset(range.getEndOffset());
            }
            {
                this.$editor = editor;
                super(1);
            }
        }));
    }

    public final void applyTo(@JetValueParameter(name="declaration") @NotNull JetDeclarationWithBody declaration, @JetValueParameter(name="canDeleteTypeRef") boolean canDeleteTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        this.applyToInternal(declaration, (Function1<? super JetCallableDeclaration, ? extends Unit>)((Function1)new Function1<JetCallableDeclaration, Unit>(canDeleteTypeRef){
            final /* synthetic */ boolean $canDeleteTypeRef;

            public final void invoke(@JetValueParameter(name="it") @NotNull JetCallableDeclaration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$canDeleteTypeRef) {
                    PsiElement psiElement = it.getColon();
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    JetTypeReference jetTypeReference = it.getTypeReference();
                    if (jetTypeReference == null) {
                        Intrinsics.throwNpe();
                    }
                    it.deleteChildRange(psiElement, (PsiElement)jetTypeReference);
                }
            }
            {
                this.$canDeleteTypeRef = bl;
                super(1);
            }
        }));
    }

    private final void applyToInternal(@JetValueParameter(name="declaration") JetDeclarationWithBody declaration, @JetValueParameter(name="onFinish") Function1<? super JetCallableDeclaration, ? extends Unit> onFinish) {
        PsiElement newBody;
        JetType valueType;
        JetExpression jetExpression = this.calcValue(declaration);
        if (jetExpression == null) {
            Intrinsics.throwNpe();
        }
        JetExpression value2 = jetExpression;
        if (!(declaration.hasDeclaredReturnType() || !(declaration instanceof JetNamedFunction) || (valueType = ResolvePackage.analyze$default(value2, null, 1).getType(value2)) != null && KotlinBuiltIns.isUnit(valueType))) {
            JetCallableDeclaration jetCallableDeclaration = (JetCallableDeclaration)((Object)declaration);
            JetType jetType = KotlinBuiltIns.getInstance().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"KotlinBuiltIns.getInstance().getUnitType()");
            IntentionsPackage$Utils$d82a7ea7.setType(jetCallableDeclaration, jetType);
        }
        boolean omitType = declaration.hasDeclaredReturnType() && declaration instanceof JetCallableDeclaration && this.canOmitType((JetCallableDeclaration)((Object)declaration), value2);
        JetExpression jetExpression2 = declaration.getBodyExpression();
        if (jetExpression2 == null) {
            Intrinsics.throwNpe();
        }
        JetExpression body2 = jetExpression2;
        CommentSaver commentSaver = new CommentSaver((PsiElement)body2, false, 2, null);
        declaration.addBefore(PsiPackage.JetPsiFactory(declaration).createEQ(), (PsiElement)body2);
        PsiElement psiElement = newBody = body2.replace((PsiElement)value2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"newBody");
        commentSaver.restore(psiElement);
        if (omitType) {
            JetDeclarationWithBody jetDeclarationWithBody = declaration;
            if (jetDeclarationWithBody == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetDeclarationWithBody cannot be cast to org.jetbrains.kotlin.psi.JetCallableDeclaration");
            }
            onFinish.invoke((Object)((JetCallableDeclaration)((Object)jetDeclarationWithBody)));
        }
    }

    private final boolean canOmitType(@JetValueParameter(name="declaration") JetCallableDeclaration declaration, @JetValueParameter(name="expression") JetExpression expression2) {
        Annotated annotated;
        JetElement jetElement;
        Object object;
        if (!IntentionsPackage$Utils$d82a7ea7.canRemoveTypeSpecificationByVisibility(declaration)) {
            return false;
        }
        JetCallableDeclaration jetCallableDeclaration = declaration;
        if (!(jetCallableDeclaration instanceof JetDeclarationWithBody)) {
            jetCallableDeclaration = null;
        }
        JetDeclarationWithBody jetDeclarationWithBody = (JetDeclarationWithBody)((Object)jetCallableDeclaration);
        JetExpression jetExpression = jetDeclarationWithBody != null ? jetDeclarationWithBody.getBodyExpression() : null;
        if (!(jetExpression instanceof JetBlockExpression)) {
            jetExpression = null;
        }
        if (!(((object = (JetBlockExpression)jetExpression) != null && (object = ((JetBlockExpression)object).getStatements()) != null ? (JetElement)KotlinPackage.singleOrNull((List)object) : (jetElement = null)) instanceof JetExpression)) {
            jetElement = null;
        }
        JetExpression jetExpression2 = (JetExpression)jetElement;
        if (jetExpression2 == null) {
            return false;
        }
        JetExpression scopeExpression = jetExpression2;
        DeclarationDescriptor declarationDescriptor = ResolvePackage.resolveToDescriptor(declaration);
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        if ((annotated = (CallableDescriptor)declarationDescriptor) == null || (annotated = annotated.getReturnType()) == null) {
            return false;
        }
        Annotated declaredType = annotated;
        JetScope jetScope = (JetScope)ResolvePackage.analyze$default(scopeExpression, null, 1).get(BindingContext.RESOLUTION_SCOPE, scopeExpression);
        if (jetScope == null) {
            return false;
        }
        JetScope scope2 = jetScope;
        JetType jetType = AnalyzerPackage.analyzeInContext$default(expression2, scope2, null, null, null, null, 30).getType(expression2);
        if (jetType == null) {
            return false;
        }
        JetType expressionType = jetType;
        return TypeUtilPackage.isSubtypeOf(expressionType, (JetType)declaredType);
    }

    private final JetExpression calcValue(@JetValueParameter(name="declaration") JetDeclarationWithBody declaration) {
        JetElement statement;
        if (declaration instanceof JetFunctionLiteral) {
            return null;
        }
        JetExpression body2 = declaration.getBodyExpression();
        if (!declaration.hasBlockBody() || !(body2 instanceof JetBlockExpression)) {
            return null;
        }
        JetElement jetElement = (JetElement)KotlinPackage.singleOrNull(((JetBlockExpression)body2).getStatements());
        if (jetElement == null) {
            return null;
        }
        JetElement jetElement2 = statement = jetElement;
        if (jetElement2 instanceof JetReturnExpression) {
            return ((JetReturnExpression)statement).getReturnedExpression();
        }
        if (jetElement2 instanceof JetDeclaration || jetElement2 instanceof JetLoopExpression) {
            return null;
        }
        if (jetElement2 instanceof JetExpression) {
            if (statement instanceof JetBinaryExpression && Intrinsics.areEqual((Object)((JetBinaryExpression)statement).getOperationToken(), (Object)((Object)JetTokens.EQ))) {
                return null;
            }
            JetType jetType = ResolvePackage.analyze$default(statement, null, 1).getType((JetExpression)statement);
            if (jetType == null) {
                return null;
            }
            JetType expressionType = jetType;
            if (!KotlinBuiltIns.isUnit(expressionType) && !KotlinBuiltIns.isNothing(expressionType)) {
                return null;
            }
            return (JetExpression)statement;
        }
        return null;
    }

    private final boolean containsReturn(@JetValueParameter(name="element") PsiElement element) {
        if (element instanceof JetReturnExpression) {
            return true;
        }
        if (element instanceof JetNamedFunction || element instanceof JetPropertyAccessor) {
            return false;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.containsReturn(child)) continue;
            return true;
        }
        return false;
    }

    public ConvertToExpressionBodyIntention() {
        super(JetDeclarationWithBody.class, "Convert to expression body", null, true, 4, null);
    }
}

