/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"^\u0006)\u00012\nR8d)f\u0004X\r\u001a%b]\u0012dWM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015\u0011YGm\\2\u000b)QK\b/\u001a3IC:$G.\u001a:EK2,w-\u0019;f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*Y1m\u001c3f\u0013:\u001c\u0018n\u001a5u\u00155)G-\u001b;pe\u0006\u001bG/[8og*1A(\u001b8jizRqBY3g_J,7\t[1s)f\u0004X\r\u001a\u0006\u0002G*!1\t[1s\u0015\u001d\u0001(o\u001c6fGRTq\u0001\u0015:pU\u0016\u001cGOC\u0004pa\u0016t\u0017\r]5\u000b\r\u0015$\u0017\u000e^8s\u0015\u0019)E-\u001b;pe*!a-\u001b7f\u0015\u001d\u00016/\u001b$jY\u0016T1\u0001]:j\u0015!1\u0017\u000e\\3UsB,'\u0002\u0003$jY\u0016$\u0016\u0010]3\u000b\u0013\u0019LG.\u001a+za\u0016\u001c(B\u0002*fgVdGOC\u000eUsB,G\rS1oI2,'\u000fR3mK\u001e\fG/\u001a\u0013SKN,H\u000e\u001e\u0006\nG\"\f'\u000fV=qK\u0012T!\u0003[1oI2,'I]1dW\u0016$H+\u001f9fI*9!i\\8mK\u0006t'bF8wKJ<(/\u001b;f\u00072|7/\u001b8h\u0005J\f7m[3uu\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\b\u0015\u0011Aa\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0004\t\u0013A1\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0006\u0011\u001da\u0001!\u0002\u0002\u0005\b!EQA\u0001C\u0007\u0011\u001f)1\u0001B\u0004\t\u00111\u0001QA\u0001C\u0007\u0011%)1\u0001\u0002\u0005\t\u00141\u0001QA\u0001C\u0004\u0011-)1\u0001B\u0005\t\u00161\u0001QA\u0001C\u0007\u00113)1\u0001\u0002\u0006\t\u00191\u0001Qa\u0001\u0003\u0006\u00115a\u0001!\u0002\u0002\u0005\n!mQA\u0001\u0003\b\u0011!)!\u0001\u0002\u0005\t\u0014\u0015\u0011A!\u0003E\u000b\u000b\t!!\u0002\u0003\u0007\u0006\u0007\u0011-\u0001b\u0004\u0007\u0001\t\ra)!\u0007\u0002\u0006\u0003!)Q&\u000f\u0003\f1\u0019ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001\u0005\u0007!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001fi!!B\u0001\t\u0010A\u001b\t!(\u0004\u0005\u0001!IQBA\u0003\u0002\u0011#\u00016!AO\u0007\t\u0001A!\"\u0004\u0002\u0006\u0003!M\u0001ka\u0001\u001e\u000e\u0011\u0001\u0001rC\u0007\u0003\u000b\u0005A)\u0002U\u0002\u0003C\t)\u0011\u0001C\u0006R\u00075!a!C\u0001\t\u00185\tA!A\u0007\u0002\u00111i\u0011\u0001#\u0007\u000e\u0003!iQ\"\u0001E\u000e[?\"1\u0002\u0007\b\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005Aa\u0001U\u0002\u0001;\u001b!\u0001\u0001c\u0004\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0002u5A\u0001\u0001\u0005\n\u001b\t)\u0011\u0001#\u0005Q\u0007\u0005ij\u0001\u0002\u0001\t\u00155\u0011Q!\u0001E\n!\u000e\r\u0011EA\u0003\u0002\u0011-\t6a\u0003\u0003\u000f\u0013\u0005A9\"D\u0001\u0005\u00035\t\u0001\u0002D\u0007\u0002\u00113i\u0011\u0001C\u0007.`\u0011\t\u0001TDO\u0007\t\u0001Ai!\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rB\u0007\u0003\u000b\u0005Ay\u0001UB\u0001;\u001b!\u0001\u0001C\u0005\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0003u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001c\u0005Q\u0007\u0007\t#!B\u0001\t\u001dE\u001b1\u0002\"\b\n\u0003\u0011\u0005Q\"\u0001\u0003\u0002\u001b\u0005AA\"D\u0001\t\u001a5\t\u0001\"D\u0017'\t\u0005Az\"(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u0019\u00016\u0001AO\u0007\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!E\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0019\u0002U\u0002\u0002C\t)\u0011\u0001\u0003\bR\u0007%!y\"C\u0001\u0005\u00025\tA!A\u0007\u0002\u00113i\u0011\u0001C\u00076\u0017\u0015QAa9\u0001\u0019\f\u0005\u0012Q!\u0001E\u0003#\u000e\u0019A1B\u0005\u0002\t\u0001\u0001"})
public final class KDocTypedHandler
extends TypedHandlerDelegate {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KDocTypedHandler.class);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(@JetValueParameter(name="c") char c, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="file") @NotNull PsiFile file, @JetValueParameter(name="fileType") @NotNull FileType fileType) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        if (this.overwriteClosingBracket(c, editor, file)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(@JetValueParameter(name="c") char c, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="file") @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.handleBracketTyped(c, project, editor, file) ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean overwriteClosingBracket(@JetValueParameter(name="c") char c, @JetValueParameter(name="editor") Editor editor, @JetValueParameter(name="file") PsiFile file) {
        if (c != ']' && c != ')') {
            return false;
        }
        if (!(file instanceof JetFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < document.getTextLength() && KotlinPackage.get((CharSequence)chars, (int)offset) == c) {
            boolean bl;
            PsiDocumentManager.getInstance((Project)((JetFile)file).getProject()).commitDocument(document);
            PsiElement psiElement = ((JetFile)file).findElementAt(offset);
            if (psiElement == null) {
                return false;
            }
            PsiElement element = psiElement;
            IElementType elementType = element.getNode().getElementType();
            switch (c) {
                case ']': {
                    void strict;
                    void $receiver;
                    PsiElement psiElement2 = element;
                    boolean bl2 = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$receiver, KDoc.class, (boolean)strict) != null && (Intrinsics.areEqual((Object)elementType, (Object)((Object)JetTokens.RBRACKET)) || offset > 0 && KotlinPackage.get((CharSequence)chars, (int)(offset - 1)) == '[')) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case ')': {
                    bl = Intrinsics.areEqual((Object)elementType, (Object)((Object)KDocTokens.MARKDOWN_INLINE_LINK));
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean handleBracketTyped(@JetValueParameter(name="c") char c, @JetValueParameter(name="project") Project project, @JetValueParameter(name="editor") Editor editor, @JetValueParameter(name="file") PsiFile file) {
        if (c != '[' && c != '(') {
            return false;
        }
        if (!(file instanceof JetFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return false;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement psiElement = ((JetFile)file).findElementAt(offset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        if (Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)((Object)KDocTokens.TEXT)) ^ true) {
            return false;
        }
        switch (c) {
            case '[': {
                document.insertString(offset, (CharSequence)"]");
                return true;
            }
            case '(': {
                if (offset <= 1 || KotlinPackage.get((CharSequence)document.getCharsSequence(), (int)(offset - 2)) != ']') break;
                document.insertString(offset, (CharSequence)")");
                return true;
            }
        }
        return false;
    }
}

