/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.ktSignature.KotlinSignatureUtil;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;

public class DeleteSignatureAction
extends AnAction {
    private final PsiModifierListOwner annotationOwner;

    public DeleteSignatureAction(@NotNull PsiModifierListOwner elementInEditor) {
        if (elementInEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInEditor", "org/jetbrains/kotlin/idea/ktSignature/DeleteSignatureAction", "<init>"));
        }
        super("Delete");
        this.annotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner((PsiElement)elementInEditor);
        this.getTemplatePresentation().setVisible(this.annotationOwner != null && KotlinSignatureUtil.isAnnotationEditable((PsiElement)elementInEditor));
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        assert (project != null);
        final PsiAnnotation annotation2 = KotlinSignatureUtil.findKotlinSignatureAnnotation((PsiElement)this.annotationOwner);
        assert (annotation2 != null);
        if (annotation2.getContainingFile() != this.annotationOwner.getContainingFile()) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/ktSignature/DeleteSignatureAction$1", "run"));
                    }
                    ExternalAnnotationsManager.getInstance((Project)project).deannotate(DeleteSignatureAction.this.annotationOwner, JvmAnnotationNames.KOTLIN_SIGNATURE.asString());
                    ExternalAnnotationsManager.getInstance((Project)project).deannotate(DeleteSignatureAction.this.annotationOwner, JvmAnnotationNames.OLD_KOTLIN_SIGNATURE.asString());
                }
            }.execute();
        } else {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/ktSignature/DeleteSignatureAction$2", "run"));
                    }
                    annotation2.delete();
                }
            }.execute();
        }
        KotlinSignatureUtil.refreshMarkers(project);
    }
}

