/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolveExtension;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.ktSignature.EditSignatureAction;
import org.jetbrains.kotlin.idea.ktSignature.KotlinSignatureUtil;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.structure.impl.JavaConstructorImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererBuilder;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolver;

public class KotlinSignatureAnnotationIntention
extends BaseIntentionAction
implements Iconable {
    private static final DescriptorRenderer RENDERER = new DescriptorRendererBuilder().setTypeNormalizer(IdeDescriptorRenderers.APPROXIMATE_FLEXIBLE_TYPES).setNameShortness(NameShortness.SHORT).setModifiers(new DescriptorRenderer.Modifier[0]).setWithDefinedIn(false).build();

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.kotlin.signature.action.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "getFamilyName"));
        }
        return string;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return JetIcons.SMALL_LOGO;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "isAvailable"));
        }
        PsiMember memberUnderCaret = KotlinSignatureAnnotationIntention.findMemberUnderCaret((PsiElement)file, editor);
        if (memberUnderCaret == null) {
            return false;
        }
        PsiMember annotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner((PsiElement)memberUnderCaret);
        if (annotationOwner == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)annotationOwner)) {
            return false;
        }
        if (KotlinSignatureUtil.findKotlinSignatureAnnotation((PsiElement)annotationOwner) != null) {
            if (KotlinSignatureUtil.isAnnotationEditable((PsiElement)annotationOwner)) {
                this.setText(JetBundle.message("edit.kotlin.signature.action.text", new Object[0]));
            } else {
                this.setText(JetBundle.message("view.kotlin.signature.action.text", new Object[0]));
            }
        } else {
            this.setText(JetBundle.message("add.kotlin.signature.action.text", new Object[0]));
        }
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "invoke"));
        }
        final PsiMember annotatedElement = KotlinSignatureAnnotationIntention.findMemberUnderCaret((PsiElement)file, editor);
        assert (annotatedElement != null);
        if (KotlinSignatureUtil.findKotlinSignatureAnnotation((PsiElement)annotatedElement) != null) {
            EditSignatureAction.invokeEditSignature((PsiElement)annotatedElement, editor, null);
            return;
        }
        String signature = KotlinSignatureAnnotationIntention.getDefaultSignature(project, annotatedElement);
        final MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(ExternalAnnotationsManager.TOPIC, (Object)new ExternalAnnotationsListener.Adapter(){

            public void afterExternalAnnotationChanging(@NotNull PsiModifierListOwner owner, @NotNull String annotationFQName, boolean successful) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention$1", "afterExternalAnnotationChanging"));
                }
                if (annotationFQName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQName", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention$1", "afterExternalAnnotationChanging"));
                }
                busConnection.disconnect();
                if (successful && owner == annotatedElement && JvmAnnotationNames.KOTLIN_SIGNATURE.asString().equals(annotationFQName)) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KotlinSignatureUtil.refreshMarkers(project);
                            EditSignatureAction.invokeEditSignature((PsiElement)annotatedElement, editor, null);
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        });
        AddAnnotationFix addAnnotationFix = new AddAnnotationFix(JvmAnnotationNames.KOTLIN_SIGNATURE.asString(), (PsiModifierListOwner)annotatedElement, KotlinSignatureUtil.signatureToNameValuePairs(annotatedElement.getProject(), signature), new String[0]);
        addAnnotationFix.invoke(project, editor, file);
    }

    private static String renderMember(PsiMember member) {
        PsiClass containingClass = member.getContainingClass();
        assert (containingClass != null);
        String qualifiedName = containingClass.getQualifiedName();
        assert (qualifiedName != null);
        return member.getName() + " in " + qualifiedName;
    }

    @NotNull
    private static String getDefaultSignature(@NotNull Project project, @NotNull PsiMember element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "getDefaultSignature"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "getDefaultSignature"));
        }
        PsiMember analyzableAnnotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner((PsiElement)element);
        assert (analyzableAnnotationOwner != null);
        JavaDescriptorResolver javaDescriptorResolver = JavaResolveExtension.INSTANCE$.getResolver(project, (PsiElement)analyzableAnnotationOwner);
        if (analyzableAnnotationOwner instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)analyzableAnnotationOwner;
            if (psiMethod.isConstructor()) {
                ConstructorDescriptor constructorDescriptor = ResolvePackage.resolveConstructor(javaDescriptorResolver, new JavaConstructorImpl(psiMethod));
                assert (constructorDescriptor != null) : "Couldn't find constructor descriptor for " + KotlinSignatureAnnotationIntention.renderMember((PsiMember)psiMethod);
                String string = KotlinSignatureAnnotationIntention.getDefaultConstructorAnnotation(constructorDescriptor);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "getDefaultSignature"));
                }
                return string;
            }
            FunctionDescriptor functionDescriptor = ResolvePackage.resolveMethod(javaDescriptorResolver, new JavaMethodImpl(psiMethod));
            assert (functionDescriptor != null) : "Couldn't find function descriptor for " + KotlinSignatureAnnotationIntention.renderMember((PsiMember)psiMethod);
            String string = RENDERER.render(functionDescriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "getDefaultSignature"));
            }
            return string;
        }
        if (analyzableAnnotationOwner instanceof PsiField) {
            PropertyDescriptor variableDescriptor = ResolvePackage.resolveField(javaDescriptorResolver, new JavaFieldImpl((PsiField)analyzableAnnotationOwner));
            assert (variableDescriptor != null) : "Couldn't find variable descriptor for field " + KotlinSignatureAnnotationIntention.renderMember(analyzableAnnotationOwner);
            String string = RENDERER.render(variableDescriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "getDefaultSignature"));
            }
            return string;
        }
        throw new IllegalStateException("PsiMethod or PsiField are expected");
    }

    private static String getDefaultConstructorAnnotation(ConstructorDescriptor constructorDescriptor) {
        return String.format("fun %s%s", constructorDescriptor.getContainingDeclaration().getName(), RENDERER.renderFunctionParameters(constructorDescriptor));
    }

    @Nullable
    private static PsiMember findMemberUnderCaret(@NotNull PsiElement file, Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "findMemberUnderCaret"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiMethod methodMember = KotlinSignatureAnnotationIntention.findMethod(file, offset);
        if (methodMember != null) {
            return methodMember;
        }
        return KotlinSignatureAnnotationIntention.findField(file, offset);
    }

    @Nullable
    private static PsiMethod findMethod(@NotNull PsiElement file, int offset) {
        TextRange bodyRange;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "findMethod"));
        }
        PsiElement element = file.findElementAt(offset);
        PsiMethod res = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (res == null) {
            return null;
        }
        PsiCodeBlock body2 = res.getBody();
        if (body2 != null && (bodyRange = body2.getTextRange()) != null && bodyRange.getStartOffset() <= offset) {
            return null;
        }
        return res;
    }

    @Nullable
    private static PsiField findField(@NotNull PsiElement file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureAnnotationIntention", "findField"));
        }
        return (PsiField)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiField.class);
    }
}

