/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import javax.swing.Icon;
import org.jetbrains.kotlin.idea.JetIconProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetPsiUtil;

public class JetDefaultNamedDeclarationPresentation
implements ColoredItemPresentation {
    private final JetNamedDeclaration declaration;

    JetDefaultNamedDeclarationPresentation(JetNamedDeclaration declaration) {
        this.declaration = declaration;
    }

    public TextAttributesKey getTextAttributesKey() {
        if (JetPsiUtil.isDeprecated(this.declaration)) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        return null;
    }

    public String getPresentableText() {
        return this.declaration.getName();
    }

    public String getLocationString() {
        FqName name2 = this.declaration.getFqName();
        if (name2 != null) {
            return "(" + name2.parent().toString() + ")";
        }
        return null;
    }

    public Icon getIcon(boolean unused) {
        return JetIconProvider.INSTANCE.getIcon(this.declaration, 0);
    }
}

