/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;

public class AddModifierFix
extends JetIntentionAction<JetModifierListOwner> {
    @NotNull
    private final JetModifierKeywordToken modifier;

    private AddModifierFix(@NotNull JetModifierListOwner element, @NotNull JetModifierKeywordToken modifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "<init>"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "<init>"));
        }
        super(element);
        this.modifier = modifier;
    }

    @NotNull
    static String getElementName(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "getElementName"));
        }
        String name2 = null;
        if (modifierListOwner instanceof PsiNameIdentifierOwner) {
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)modifierListOwner).getNameIdentifier();
            if (nameIdentifier != null) {
                name2 = nameIdentifier.getText();
            }
        } else if (modifierListOwner instanceof JetPropertyAccessor) {
            name2 = ((JetPropertyAccessor)modifierListOwner).getNamePlaceholder().getText();
        }
        if (name2 == null) {
            name2 = modifierListOwner.getText();
        }
        String string = "'" + name2 + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "getElementName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        if (this.modifier == JetTokens.ABSTRACT_KEYWORD || this.modifier == JetTokens.OPEN_KEYWORD) {
            String string = JetBundle.message("make.element.modifier", AddModifierFix.getElementName((JetModifierListOwner)this.element), this.modifier.getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "getText"));
            }
            return string;
        }
        String string = JetBundle.message("add.modifier", this.modifier.getValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.modifier.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddModifierFix", "invoke"));
        }
        ((JetModifierListOwner)this.element).addModifier(this.modifier);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static <T extends JetModifierListOwner> JetSingleIntentionActionFactory createFactory(final JetModifierKeywordToken modifier, final Class<T> modifierOwnerClass) {
        return new JetSingleIntentionActionFactory(){

            @Override
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetModifierListOwner modifierListOwner = (JetModifierListOwner)QuickFixUtil.getParentElementOfType(diagnostic, modifierOwnerClass);
                if (modifierListOwner == null) {
                    return null;
                }
                if (modifier == JetTokens.ABSTRACT_KEYWORD && modifierListOwner instanceof JetObjectDeclaration && ((JetObjectDeclaration)modifierListOwner).isObjectLiteral()) {
                    return null;
                }
                return new AddModifierFix(modifierListOwner, modifier);
            }
        };
    }

    public static JetSingleIntentionActionFactory createFactory(JetModifierKeywordToken modifier) {
        return AddModifierFix.createFactory(modifier, JetModifierListOwner.class);
    }
}

