/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;

public abstract class AddStarProjectionsFix
extends JetIntentionAction<JetUserType> {
    private final int argumentCount;

    private AddStarProjectionsFix(@NotNull JetUserType element, int count) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix", "<init>"));
        }
        super(element);
        this.argumentCount = count;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("add.star.projections", TypeReconstructionUtil.getTypeNameAndStarProjectionsString("", this.argumentCount));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Add star projections" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix", "getFamilyName"));
        }
        return "Add star projections";
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix", "invoke"));
        }
        assert (((JetUserType)this.element).getTypeArguments().isEmpty());
        String typeString = TypeReconstructionUtil.getTypeNameAndStarProjectionsString(((JetUserType)this.element).getText(), this.argumentCount);
        JetTypeElement replacement = PsiPackage.JetPsiFactory((PsiElement)file).createType(typeString).getTypeElement();
        assert (replacement != null) : "No type element after parsing " + typeString;
        ((JetUserType)this.element).replace((PsiElement)replacement);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static JetSingleIntentionActionFactory createFactoryForIsExpression() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public IntentionAction createAction(Diagnostic diagnostic) {
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)Errors.NO_TYPE_ARGUMENTS_ON_RHS.cast(diagnostic);
                JetTypeElement typeElement = ((JetTypeReference)diagnosticWithParameters.getPsiElement()).getTypeElement();
                while (typeElement instanceof JetNullableType) {
                    typeElement = ((JetNullableType)typeElement).getInnerType();
                }
                if (!(typeElement instanceof JetUserType)) {
                    return null;
                }
                Integer size = (Integer)diagnosticWithParameters.getA();
                return new AddStarProjectionsFix((JetUserType)typeElement, size){};
            }
        };
    }

    public static JetSingleIntentionActionFactory createFactoryForJavaClass() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public IntentionAction createAction(Diagnostic diagnostic) {
                DiagnosticWithParameters1 diagnosticWithParameters = (DiagnosticWithParameters1)Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.cast(diagnostic);
                Integer size = (Integer)diagnosticWithParameters.getA();
                JetUserType userType = QuickFixUtil.getParentElementOfType(diagnostic, JetUserType.class);
                if (userType == null) {
                    return null;
                }
                return new AddStarProjectionsFix(userType, size){

                    @Override
                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix$2$1", "isAvailable"));
                        }
                        return super.isAvailable(project, editor, file) && this.isZeroTypeArguments() && this.isInsideJavaClassCall();
                    }

                    private boolean isZeroTypeArguments() {
                        return ((JetUserType)this.element).getTypeArguments().isEmpty();
                    }

                    private boolean isInsideJavaClassCall() {
                        JetExpression calleeExpression;
                        PsiElement parent = ((JetUserType)this.element).getParent().getParent().getParent().getParent();
                        if (parent instanceof JetCallExpression && (calleeExpression = ((JetCallExpression)parent).getCalleeExpression()) instanceof JetSimpleNameExpression) {
                            JetSimpleNameExpression simpleNameExpression = (JetSimpleNameExpression)calleeExpression;
                            return "javaClass".equals(simpleNameExpression.getReferencedName());
                        }
                        return false;
                    }
                };
            }
        };
    }
}

