/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.BindingContext;

public class ChangeVisibilityModifierFix
extends JetIntentionAction<JetModifierListOwner> {
    public static final JetModifierKeywordToken[] VISIBILITY_TOKENS = new JetModifierKeywordToken[]{JetTokens.PUBLIC_KEYWORD, JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.INTERNAL_KEYWORD};

    public ChangeVisibilityModifierFix(@NotNull JetModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeVisibilityModifierFix", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("change.visibility.modifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVisibilityModifierFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.visibility.modifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVisibilityModifierFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeVisibilityModifierFix", "isAvailable"));
        }
        if (!(file instanceof JetFile)) {
            return false;
        }
        return super.isAvailable(project, editor, file) && this.findVisibilityChangeTo((JetFile)file) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeVisibilityModifierFix", "invoke"));
        }
        JetModifierKeywordToken modifier = this.findVisibilityChangeTo(file);
        assert (modifier != null);
        ((JetModifierListOwner)this.element).addModifier(modifier);
    }

    @Nullable
    private JetModifierKeywordToken findVisibilityChangeTo(JetFile file) {
        DeclarationDescriptor descriptor2;
        BindingContext bindingContext2 = ResolvePackage.analyzeFully(file);
        if (this.element instanceof JetParameter) {
            DeclarationDescriptor descriptor22 = bindingContext2.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, this.element);
        } else {
            descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.element);
        }
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return null;
        }
        CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)descriptor2;
        Visibility maxVisibility = null;
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Visibility overriddenDescriptorVisibility = callableMemberDescriptor.getVisibility();
            if (maxVisibility == null) {
                maxVisibility = overriddenDescriptorVisibility;
                continue;
            }
            Integer compare = Visibilities.compare(maxVisibility, overriddenDescriptorVisibility);
            if (compare == null) {
                maxVisibility = Visibilities.PUBLIC;
                continue;
            }
            if (compare >= 0) continue;
            maxVisibility = overriddenDescriptorVisibility;
        }
        if (maxVisibility == memberDescriptor.getVisibility()) {
            return null;
        }
        if (maxVisibility == null) {
            return null;
        }
        return JetRefactoringUtil.getVisibilityToken(maxVisibility);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetModifierListOwner> createAction(Diagnostic diagnostic) {
                PsiElement element = diagnostic.getPsiElement();
                if (!(element instanceof JetModifierListOwner)) {
                    return null;
                }
                return new ChangeVisibilityModifierFix((JetModifierListOwner)element);
            }
        };
    }
}

