/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;

public class RemovePsiElementSimpleFix
extends JetIntentionAction<PsiElement> {
    private final PsiElement element;
    private final String text;

    public RemovePsiElementSimpleFix(@NotNull PsiElement el, @NotNull String txt) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "org/jetbrains/kotlin/idea/quickfix/RemovePsiElementSimpleFix", "<init>"));
        }
        if (txt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txt", "org/jetbrains/kotlin/idea/quickfix/RemovePsiElementSimpleFix", "<init>"));
        }
        super(el);
        this.element = el;
        this.text = txt;
    }

    @NotNull
    public String getText() {
        String string = this.text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemovePsiElementSimpleFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.psi.element.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemovePsiElementSimpleFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemovePsiElementSimpleFix", "invoke"));
        }
        this.element.delete();
    }

    public static JetSingleIntentionActionFactory createRemoveImportFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<PsiElement> createAction(Diagnostic diagnostic) {
                JetImportDirective directive = QuickFixUtil.getParentElementOfType(diagnostic, JetImportDirective.class);
                if (directive == null) {
                    return null;
                }
                JetExpression exp = directive.getImportedReference();
                if (exp != null) {
                    return new RemovePsiElementSimpleFix((PsiElement)directive, JetBundle.message("remove.conflicting.import", exp.getText()));
                }
                return new RemovePsiElementSimpleFix((PsiElement)directive, JetBundle.message("remove.conflicting.import", ""));
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveSpreadFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<PsiElement> createAction(Diagnostic diagnostic) {
                PsiElement element = diagnostic.getPsiElement();
                if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == JetTokens.MUL) {
                    return new RemovePsiElementSimpleFix(element, JetBundle.message("remove.spread.sign", new Object[0]));
                }
                return null;
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveTypeArgumentsFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<PsiElement> createAction(Diagnostic diagnostic) {
                JetTypeArgumentList element = QuickFixUtil.getParentElementOfType(diagnostic, JetTypeArgumentList.class);
                if (element == null) {
                    return null;
                }
                return new RemovePsiElementSimpleFix((PsiElement)element, JetBundle.message("remove.type.arguments", new Object[0]));
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveVariableFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<PsiElement> createAction(Diagnostic diagnostic) {
                final JetProperty expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetProperty.class);
                if (expression2 == null) {
                    return null;
                }
                return new RemovePsiElementSimpleFix(expression2, JetBundle.message("remove.variable.action", expression2.getName())){

                    @Override
                    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemovePsiElementSimpleFix$4$1", "invoke"));
                        }
                        JetExpression initializer = expression2.getInitializer();
                        if (initializer != null) {
                            expression2.replace((PsiElement)initializer);
                        } else {
                            expression2.delete();
                        }
                    }
                };
            }
        };
    }
}

