/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.TokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public class RemoveValVarFromParameterFix
extends JetIntentionAction<JetParameter> {
    private final String varOrVal;

    public RemoveValVarFromParameterFix(@NotNull JetParameter element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix", "<init>"));
        }
        super(element);
        ASTNode valOrVarNode = element.getValOrVarNode();
        assert (valOrVarNode != null) : "Val or var node not found for " + PsiUtilPackage.getElementTextWithContext(element);
        this.varOrVal = valOrVarNode.getText();
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("remove.val.var.from.parameter", this.varOrVal);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.val.var.from.parameter", "val/var");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix", "invoke"));
        }
        ASTNode valOrVarNode = ((JetParameter)this.element).getValOrVarNode();
        if (valOrVarNode == null) {
            return;
        }
        ASTNode next2 = valOrVarNode.getTreeNext();
        ASTNode firstNodeToKeep = next2.getElementType() == TokenType.WHITE_SPACE ? next2.getTreeNext() : next2;
        ((JetParameter)this.element).getNode().removeRange(valOrVarNode, firstNodeToKeep);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix$1", "createAction"));
                }
                return new RemoveValVarFromParameterFix((JetParameter)diagnostic.getPsiElement().getParent());
            }
        };
    }
}

